; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --verify-machineinstrs --no-integrated-as < %s \
; RUN:   | FileCheck %s
; RUN: llc --mtriple=loongarch64 --verify-machineinstrs --no-integrated-as < %s \
; RUN:   | FileCheck %s

@gi = external dso_local global i32, align 4

define i32 @constraint_r(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: constraint_r:
; CHECK:       # %bb.0:
; CHECK-NEXT:    #APP
; CHECK-NEXT:    add.w $a0, $a0, $a1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret
  %1 = tail call i32 asm "add.w $0, $1, $2", "=r,r,r"(i32 %a, i32 %b)
  ret i32 %1
}

define i32 @constraint_i(i32 %a) nounwind {
; CHECK-LABEL: constraint_i:
; CHECK:       # %bb.0:
; CHECK-NEXT:    #APP
; CHECK-NEXT:    addi.w $a0, $a0, 113
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret
  %1 = tail call i32 asm "addi.w $0, $1, $2", "=r,r,i"(i32 %a, i32 113)
  ret i32 %1
}

define void @constraint_l() nounwind {
; CHECK-LABEL: constraint_l:
; CHECK:       # %bb.0:
; CHECK-NEXT:    #APP
; CHECK-NEXT:    lu12i.w $a0, 32767
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    lu12i.w $a0, -32768
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret
  tail call void asm sideeffect "lu12i.w $$a0, $0", "l"(i32 32767)
  tail call void asm sideeffect "lu12i.w $$a0, $0", "l"(i32 -32768)
  ret void
}

define void @constraint_I() nounwind {
; CHECK-LABEL: constraint_I:
; CHECK:       # %bb.0:
; CHECK-NEXT:    #APP
; CHECK-NEXT:    addi.w $a0, $a0, 2047
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    addi.w $a0, $a0, -2048
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret
  tail call void asm sideeffect "addi.w $$a0, $$a0, $0", "I"(i32 2047)
  tail call void asm sideeffect "addi.w $$a0, $$a0, $0", "I"(i32 -2048)
  ret void
}

define void @constraint_J() nounwind {
; CHECK-LABEL: constraint_J:
; CHECK:       # %bb.0:
; CHECK-NEXT:    #APP
; CHECK-NEXT:    addi.w $a0, $a0, 0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret
  tail call void asm sideeffect "addi.w $$a0, $$a0, $0", "J"(i32 0)
  ret void
}

define void @constraint_K() nounwind {
; CHECK-LABEL: constraint_K:
; CHECK:       # %bb.0:
; CHECK-NEXT:    #APP
; CHECK-NEXT:    andi $a0, $a0, 4095
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    andi $a0, $a0, 0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret
  tail call void asm sideeffect "andi $$a0, $$a0, $0", "K"(i32 4095)
  tail call void asm sideeffect "andi $$a0, $$a0, $0", "K"(i32 0)
  ret void
}

define void @operand_global() nounwind {
; CHECK-LABEL: operand_global:
; CHECK:       # %bb.0:
; CHECK-NEXT:    #APP
; CHECK-NEXT:    .8byte gi
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ret
  tail call void asm sideeffect ".8byte $0", "i"(ptr @gi)
  ret void
}

define void @operand_block_address() nounwind {
; CHECK-LABEL: operand_block_address:
; CHECK:       # %bb.0:
; CHECK-NEXT:    #APP
; CHECK-NEXT:    b .Ltmp0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:  .Ltmp0: # Block address taken
; CHECK-NEXT:  # %bb.1: # %bb
; CHECK-NEXT:    ret
  call void asm sideeffect "b $0", "i"(ptr blockaddress(@operand_block_address, %bb))
  br label %bb
bb:
  ret void
}
