; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -mattr=+architected-sgprs --verify-machineinstrs < %s | FileCheck -check-prefix=GFX9-SDAG %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -mattr=+architected-sgprs -global-isel --verify-machineinstrs < %s | FileCheck -check-prefix=GFX9-GISEL %s

define amdgpu_cs void @_amdgpu_cs_main() {
; GFX9-SDAG-LABEL: _amdgpu_cs_main:
; GFX9-SDAG:       ; %bb.0: ; %.entry
; GFX9-SDAG-NEXT:    s_lshr_b32 s2, ttmp7, 16
; GFX9-SDAG-NEXT:    s_and_b32 s1, ttmp7, 0xffff
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, ttmp9
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-SDAG-NEXT:    buffer_store_dwordx3 v[0:2], off, s[0:3], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: _amdgpu_cs_main:
; GFX9-GISEL:       ; %bb.0: ; %.entry
; GFX9-GISEL-NEXT:    s_mov_b32 s0, ttmp9
; GFX9-GISEL-NEXT:    s_and_b32 s1, ttmp7, 0xffff
; GFX9-GISEL-NEXT:    s_lshr_b32 s2, ttmp7, 16
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-GISEL-NEXT:    buffer_store_dwordx3 v[0:2], off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
.entry:
  %idx = call i32 @llvm.amdgcn.workgroup.id.x()
  %idy = call i32 @llvm.amdgcn.workgroup.id.y()
  %idz = call i32 @llvm.amdgcn.workgroup.id.z()
  %ielemx = insertelement <3 x i32> undef, i32 %idx, i64 0
  %ielemy = insertelement <3 x i32> %ielemx, i32 %idy, i64 1
  %ielemz = insertelement <3 x i32> %ielemy, i32 %idz, i64 2
  call void @llvm.amdgcn.raw.ptr.buffer.store.v3i32(<3 x i32> %ielemz, ptr addrspace(8) undef, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_cs void @caller() {
; GFX9-SDAG-LABEL: caller:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_getpc_b64 s[8:9]
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s0
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[8:11], s[8:9], 0x10
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, ttmp9
; GFX9-SDAG-NEXT:    s_mov_b32 s32, 0
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_add_u32 s8, s8, s0
; GFX9-SDAG-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-SDAG-NEXT:    s_getpc_b64 s[0:1]
; GFX9-SDAG-NEXT:    s_add_u32 s0, s0, callee@gotpcrel32@lo+4
; GFX9-SDAG-NEXT:    s_addc_u32 s1, s1, callee@gotpcrel32@hi+12
; GFX9-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-SDAG-NEXT:    s_mov_b64 s[0:1], s[8:9]
; GFX9-SDAG-NEXT:    s_mov_b64 s[2:3], s[10:11]
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: caller:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_getpc_b64 s[8:9]
; GFX9-GISEL-NEXT:    s_mov_b32 s8, s0
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[8:11], s[8:9], 0x10
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v0, ttmp9
; GFX9-GISEL-NEXT:    s_mov_b32 s32, 0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_add_u32 s8, s8, s0
; GFX9-GISEL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-GISEL-NEXT:    s_getpc_b64 s[0:1]
; GFX9-GISEL-NEXT:    s_add_u32 s0, s0, callee@gotpcrel32@lo+4
; GFX9-GISEL-NEXT:    s_addc_u32 s1, s1, callee@gotpcrel32@hi+12
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX9-GISEL-NEXT:    s_mov_b64 s[0:1], s[8:9]
; GFX9-GISEL-NEXT:    s_mov_b64 s[2:3], s[10:11]
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_swappc_b64 s[30:31], s[4:5]
; GFX9-GISEL-NEXT:    s_endpgm
  %idx = call i32 @llvm.amdgcn.workgroup.id.x()
  call amdgpu_gfx void @callee(i32 %idx)
  ret void
}

declare amdgpu_gfx void @callee(i32)

declare i32 @llvm.amdgcn.workgroup.id.x()
declare i32 @llvm.amdgcn.workgroup.id.y()
declare i32 @llvm.amdgcn.workgroup.id.z()
declare void @llvm.amdgcn.raw.ptr.buffer.store.v3i32(<3 x i32>, ptr addrspace(8), i32, i32, i32 immarg)
