dnl
dnl These are the facilities for generating Makefile.am.features and
dnl Makefile.win32.features files.
dnl

dnl ===========================================================================

dnl
dnl Define cr_feature_tag ala other cr_feature_* macros
dnl Expands to CAIRO_HAS_FEATURE_ID
dnl
m4_define([_CAIRO_BUILD_FEATURE_TAG_NORMALIZED],
	[CAIRO_HAS_[$1]m4_bmatch([$1],[$2$],,[$2])])dnl
m4_define([_CAIRO_BUILD_FEATURE_TAG],
	[_CAIRO_BUILD_FEATURE_TAG_NORMALIZED(AS_TR_CPP([$1]),AS_TR_CPP(m4_ifval([$2],[ $2])))])dnl
m4_define([cr_feature_tag],
	[_CAIRO_BUILD_FEATURE_TAG(cr_feature,cr_feature_what)])dnl


dnl ===========================================================================
dnl
dnl CAIRO_INIT_MAKEFILES([AUX-DIR])
dnl
dnl Sets up automake and win32 conditionals for all features
dnl
AC_DEFUN([CAIRO_INIT_MAKEFILES],
[dnl
	dnl Allow feature tags in the output
	m4_pattern_allow(^CAIRO_HAS_)dnl

	dnl Automake conditionals for non-builtin features
	CAIRO_FEATURE_HOOK_REGISTER(*,!always,*,
	[dnl
		AM_CONDITIONAL(cr_feature_tag, [test "x$use_]cr_feature[" = xyes])dnl
	])dnl

	CAIRO_CONFIG_MAKEFILE_PRIVATE_WIN32([_],[$1],[],[[# Generated by configure.  Modify to customize.]])dnl
	CAIRO_MAKEFILE_ACCUMULATE_FEATURE([_],*,!always,*,[cr_feature_tag=m4_if(cr_feature_default,[yes],1,[m4_bmatch(cr_feature,[win32],1,0)])])dnl
])dnl

dnl ===========================================================================

m4_define([_CAIRO_MAKEFILES])dnl

dnl
dnl CAIRO_CONFIG_MAKEFILE(TAG, DIR, [SUFFIX], [HEADER])
dnl
dnl Create DIR/Makefile.{am,win32}.SUFFIX files
dnl TAG is a TAG used by other CAIRO_MAKEFILE_* macros to append to these
dnl Makefile's.
dnl
dnl HEADER is appended at the top of the Makefile's.  If HEADER is not
dnl set, the generic "Generated by configure.  Do not edit." comment
dnl is added.
dnl
AC_DEFUN([CAIRO_CONFIG_MAKEFILE],
[dnl
	m4_append_uniq([_CAIRO_MAKEFILES], [$1], [ ])dnl
	CAIRO_CONFIG_MAKEFILE_PRIVATE([$1], [$2], [$3], [$4])dnl
])dnl

dnl Like CAIRO_CONFIG_MAKEFILE but only generate win32 makefile
AC_DEFUN([CAIRO_CONFIG_MAKEFILE_WIN32],
[dnl
	m4_append_uniq([_CAIRO_MAKEFILES], [$1], [ ])dnl
	CAIRO_CONFIG_MAKEFILE_PRIVATE_WIN32([$1], [$2], [$3], [$4])dnl
])dnl

dnl Like CAIRO_CONFIG_MAKEFILE but only generate automake makefile
AC_DEFUN([CAIRO_CONFIG_MAKEFILE_AMAKE],
[dnl
	m4_append_uniq([_CAIRO_MAKEFILES], [$1], [ ])dnl
	CAIRO_CONFIG_MAKEFILE_PRIVATE_AMAKE([$1], [$2], [$3], [$4])dnl
])dnl

dnl
dnl CAIRO_CONFIG_MAKEFILE_PRIVATE(TAG, DIR, [SUFFIX], [HEADER])
dnl
dnl Like CAIRO_CONFIG_MAKEFILE but this makefile tag won't match
dnl against '*' in makefile accumulators.
dnl
AC_DEFUN([CAIRO_CONFIG_MAKEFILE_PRIVATE],
[dnl
	m4_ifdef([cr_make_$1_dir],
		 [m4_fatal([Makefile `$1' already registered])])dnl
        m4_define([cr_make_$1_dir],[$2])dnl

	CAIRO_CONFIG_MAKEFILE_PRIVATE_AMAKE([$1], [$2], [$3], [$4])dnl
	CAIRO_CONFIG_MAKEFILE_PRIVATE_WIN32([$1], [$2], [$3], [$4])dnl
])dnl

dnl Like CAIRO_CONFIG_MAKEFILE_PRIVATE but only generate automake makefile
AC_DEFUN([CAIRO_CONFIG_MAKEFILE_PRIVATE_AMAKE],
[dnl
	m4_ifdef([cr_make_$1_dir_amake],
		 [m4_fatal([Automake makefile `$1' already registered])])dnl
        m4_define([cr_make_$1_dir_amake],[$2])dnl
        m4_define([cr_make_$1_dir_any],[$2])dnl

	dnl Accumulators
	CAIRO_ACCUMULATORS_REGISTER(MAKEFILE_$1_AMAKE, m4_newline, m4_default([$4],[[# Generated by configure.  Do not edit.]])m4_newline)dnl

	dnl Generate
	CAIRO_CONFIG_COMMANDS([$srcdir/]m4_if([$2],[.],,[$2/])[Makefile.am.]m4_default([$3],[features]),
			      [echo "$CAIRO_MAKEFILE_$1_AMAKE"],
			      [CAIRO_MAKEFILE_$1_AMAKE='$CAIRO_MAKEFILE_$1_AMAKE'])dnl
])dnl

dnl Like CAIRO_CONFIG_MAKEFILE_PRIVATE but only generate win32 makefile
AC_DEFUN([CAIRO_CONFIG_MAKEFILE_PRIVATE_WIN32],
[dnl
	m4_ifdef([cr_make_$1_dir_win32],
		 [m4_fatal([Win32 makefile `$1' already registered])])dnl
        m4_define([cr_make_$1_dir_win32],[$2])dnl
        m4_define([cr_make_$1_dir_any],[$2])dnl

	dnl Accumulators
	CAIRO_ACCUMULATORS_REGISTER(MAKEFILE_$1_WIN32, m4_newline, m4_default([$4],[[# Generated by configure.  Do not edit.]])m4_newline)dnl

	dnl Generate
	CAIRO_CONFIG_COMMANDS([$srcdir/]m4_if([$2],[.],,[$2/])[Makefile.win32.]m4_default([$3],[features]),
			      [echo "$CAIRO_MAKEFILE_$1_WIN32"],
			      [CAIRO_MAKEFILE_$1_WIN32='$CAIRO_MAKEFILE_$1_WIN32'])dnl
])dnl


m4_define([_CAIRO_MAKEFILE_CHECK],
[dnl
        m4_ifdef([cr_make_$1_dir_any],,[m4_fatal([Makefile `]$1[' not defined.])])dnl
])dnl


dnl
dnl CAIRO_MAKEFILE_INCLUDE(TAG, FILE)
dnl
dnl Include FILE from Makefile's for TAG.  FILE should be placed
dnl relative to directory for TAG. If TAG is *, FILE is included from
dnl all Makefile's.
dnl
AC_DEFUN([CAIRO_MAKEFILE_INCLUDE],
[dnl
	m4_if([$1],[*],,[_CAIRO_MAKEFILE_CHECK([$1])])dnl
	m4_foreach_w([cr_makefile], m4_if([$1],[*],_CAIRO_MAKEFILES,[$1]),
	[dnl
		m4_ifdef([cr_make_]cr_makefile[_dir_amake],dnl
			 [CAIRO_ACCUMULATE([MAKEFILE_]cr_makefile[_AMAKE],[include $(top_srcdir)/cr_make_]cr_makefile[_dir_amake/$2]m4_newline)]
		)dnl
		m4_ifdef([cr_make_]cr_makefile[_dir_win32],dnl
			 [CAIRO_ACCUMULATE([MAKEFILE_]cr_makefile[_WIN32],[ifeq ($(top_srcdir),)]m4_newline[include $2]m4_newline[else]m4_newline[include $(top_srcdir)/cr_make_]cr_makefile[_dir_win32/$2]m4_newline[endif]m4_newline)]
		)dnl
	])dnl
])dnl


m4_pattern_allow([cr_make_tmp])

dnl
dnl CAIRO_MAKEFILE_ACCUMULATE(TAG, CONTENT)
dnl
dnl Accumulates CONTENT to Makefile's for TAG.  If TAG is *,
dnl CONTENT is added to all Makefile's.
dnl
AC_DEFUN([CAIRO_MAKEFILE_ACCUMULATE],
[dnl
	m4_if([$1],[*],,[_CAIRO_MAKEFILE_CHECK([$1])])dnl
	m4_foreach_w([cr_makefile], m4_if([$1],[*],_CAIRO_MAKEFILES,[$1]),
	[dnl
		m4_pushdef([cr_make_acc_contents],[$2])dnl
		cr_make_tmp=_CAIRO_SH_ESCAPE(cr_make_acc_contents(cr_makefile))
		m4_popdef([cr_make_acc_contents])dnl
		m4_ifdef([cr_make_]cr_makefile[_dir_amake],dnl
			 [CAIRO_ACCUMULATE_UNQUOTED_UNCHECKED([MAKEFILE_]cr_makefile[_AMAKE], [$cr_make_tmp])]
		)dnl
		m4_ifdef([cr_make_]cr_makefile[_dir_win32],dnl
			 [CAIRO_ACCUMULATE_UNQUOTED_UNCHECKED([MAKEFILE_]cr_makefile[_WIN32], [$cr_make_tmp])]
		)dnl
	])dnl
])dnl

m4_define([_CAIRO_MAKEFILE_ACCUMULATE_FEATURE],
[dnl
	dnl Don't do a conditional for default=always features
	m4_pushdef([cr_mk_acc_feat_enabled],m4_if([$2],[yes],[m4_if(cr_feature_default,[always],[*],[$2])],[$2]))dnl
	m4_case(cr_mk_acc_feat_enabled,
		[*],,
		[yes],	[CAIRO_ACCUMULATE([$1], [$3])],
		[no],	[CAIRO_ACCUMULATE([$1], [$3]m4_newline[$4])],
			[m4_fatal([Invalid ENABLED value `]$2['])])dnl
	CAIRO_ACCUMULATE_UNQUOTED_UNCHECKED([$1], [$6])dnl
	m4_case(cr_mk_acc_feat_enabled,
		[*],,
		[yes],	[CAIRO_ACCUMULATE([$1], [$5])],
		[no],	[CAIRO_ACCUMULATE([$1], [$5])],
			[m4_fatal([Invalid ENABLED value `]$2['])])dnl
	m4_popdef([cr_mk_acc_feat_enabled])dnl
])dnl

dnl
dnl CAIRO_MAKEFILE_ACCUMULATE_FEATURE(TAG, ENABLED, DEFAULT, WHAT, CONTENT)
dnl
dnl Accumulates CONTENT to Makefile's for TAG for each feature matching
dnl ENABLED, DEFAULT, and WHAT.  Those parameters are similar to those
dnl passed to CAIRO_FEATURE_HOOK_REGISTER.
dnl If TAG is *, CONTENT is added to all Makefile's.
dnl
AC_DEFUN([CAIRO_MAKEFILE_ACCUMULATE_FEATURE],
[dnl
	m4_if([$1],[*],,[_CAIRO_MAKEFILE_CHECK([$1])])dnl
	m4_append([cr_make_acc_counter],[1],[])dnl
	m4_define([cr_make_acc_contents]m4_len(cr_make_acc_counter), [$5])dnl
	CAIRO_FEATURE_HOOK_REGISTER(*,[$3],[$4],
	[dnl
		m4_foreach_w([cr_makefile], m4_if([$1],[*],_CAIRO_MAKEFILES,[$1]),
		[dnl
			cr_make_tmp=_CAIRO_SH_ESCAPE(cr_make_acc_contents]]m4_len(cr_make_acc_counter)([[cr_makefile,]][$][1],[$][2],[$][3],[$][4])[[)
			m4_ifdef([cr_make_]cr_makefile[_dir_amake],
			[_CAIRO_MAKEFILE_ACCUMULATE_FEATURE(
				[MAKEFILE_]cr_makefile[_AMAKE],
				[$2],
				[if ]cr_feature_tag, [else], [endif],
				[$cr_make_tmp])
			])dnl
			m4_ifdef([cr_make_]cr_makefile[_dir_win32],
			[_CAIRO_MAKEFILE_ACCUMULATE_FEATURE(
				[MAKEFILE_]cr_makefile[_WIN32],
				[$2],
				[ifeq ($(]cr_feature_tag[),1)], [else], [endif],
				[$cr_make_tmp])dnl
			])dnl
		])dnl
	])dnl
])dnl

m4_define([cr_make_acc_counter])dnl
