/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.managers.base;

import info.aduna.collections.LRUMap;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrdf.model.Value;
import org.openrdf.sail.rdbms.managers.HashManager;
import org.openrdf.sail.rdbms.managers.base.ManagerBase;
import org.openrdf.sail.rdbms.model.RdbmsValue;
import org.openrdf.sail.rdbms.schema.IdSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueManagerBase<V extends RdbmsValue>
extends ManagerBase {
    private LRUMap<Object, V> cache;
    private HashManager hashes;
    private AtomicInteger version = new AtomicInteger();
    private IdSequence ids;

    public void setHashManager(HashManager hashes) {
        this.hashes = hashes;
    }

    public IdSequence getIdSequence() {
        return this.ids;
    }

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
    }

    public void init() {
        this.cache = new LRUMap(this.getBatchSize());
    }

    @Override
    public void flush() throws SQLException, InterruptedException {
        if (this.hashes != null) {
            this.hashes.flush();
        }
        super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V findInCache(Object key) {
        LRUMap<Object, V> lRUMap = this.cache;
        synchronized (lRUMap) {
            if (this.cache.containsKey(key)) {
                return (V)((RdbmsValue)this.cache.get(key));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(V value) throws InterruptedException {
        if (((RdbmsValue)value).isExpired(this.getIdVersion())) {
            LRUMap<Object, V> lRUMap = this.cache;
            synchronized (lRUMap) {
                this.cache.put(this.key(value), value);
            }
            if (this.hashes != null) {
                this.hashes.lookupId((RdbmsValue)value);
            }
        }
    }

    public Number getInternalId(V value) throws SQLException, InterruptedException {
        if (((RdbmsValue)value).isExpired(this.getIdVersion())) {
            if (this.hashes == null) {
                Number id = this.ids.idOf((Value)value);
                ((RdbmsValue)value).setInternalId(id);
                ((RdbmsValue)value).setVersion(this.getIdVersion());
                this.insert(id, value);
            } else if (((RdbmsValue)value).isExpired(this.getIdVersion())) {
                this.hashes.assignId((RdbmsValue)value, this.getIdVersion());
            }
        }
        return ((RdbmsValue)value).getInternalId();
    }

    public int getIdVersion() {
        return this.version.intValue() + (this.hashes == null ? 0 : this.hashes.getIdVersion());
    }

    public void removedStatements(String condition) throws SQLException {
        if (this.expunge(condition)) {
            this.version.addAndGet(1);
        }
    }

    protected abstract int getBatchSize();

    protected abstract void insert(Number var1, V var2) throws SQLException, InterruptedException;

    protected abstract Object key(V var1);

    protected abstract boolean expunge(String var1) throws SQLException;

    @Override
    protected void optimize() throws SQLException {
        if (this.hashes != null) {
            this.hashes.optimize();
        }
    }
}

