/*
|   Copyright (C) 2002-2003 Jorg Schuler <jcsjcs at users.sourceforge.net>
|   Part of the gtkpod project.
|
|   URL: http://gtkpod.sourceforge.net/
|
|   This program is free software; you can redistribute it and/or modify
|   it under the terms of the GNU General Public License as published by
|   the Free Software Foundation; either version 2 of the License, or
|   (at your option) any later version.
|
|   This program is distributed in the hope that it will be useful,
|   but WITHOUT ANY WARRANTY; without even the implied warranty of
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|   GNU General Public License for more details.
|
|   You should have received a copy of the GNU General Public License
|   along with this program; if not, write to the Free Software
|   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
|
|  iTunes and iPod are trademarks of Apple
|
|  This product is not supported/written/published by Apple!
|
|  $Id: itdb_main.c 1100 2005-09-23 16:59:34Z jcsjcs $
*/
/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <libintl.h>

#include "itdb.h"

int
main (int argc, char *argv[])
{
  GError *error=NULL;
  Itdb_iTunesDB *itdb;
  gchar *infile = NULL;
  gchar *outfile = NULL;

  if (argc >= 2)
      infile = argv[1];
  if (argc >= 3)
      outfile = argv[2];

  if (infile == 0)
  {
      printf ("Usage: %s <infile> [<outfile>]\n",  g_basename(argv[0]));
      exit (0);
  }

  itdb = itdb_parse_file (infile, &error);
  printf ("%p\n", itdb);

  if (error)
  {
      if (error->message)
	  puts (error->message);
      g_error_free (error);
      error = NULL;
  }

  if (itdb)
  {
      printf ("tracks: %d\n", g_list_length (itdb->tracks));
      printf ("playlists: %d\n", g_list_length (itdb->playlists));

      if (outfile)
	  itdb_write_file (itdb, outfile, &error);
      if (error)
      {
	  if (error->message)
	      puts (error->message);
	  g_error_free (error);
	  error = NULL;
      }
  }

  itdb_free (itdb);

  return 0;
}
