//  Copyright (c) 2006 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Each row of data contains in order:
//
// n, phi, k, PI(n, phi, k)
//
#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 4>, 380> ellint_pi3_large_data = {
      SC_(-0.882951507568359375e2), SC_(-0.80491924285888671875e1), SC_(0.814723670482635498046875e0), SC_(-0.87472421400728425336727040442604900083192977041785e0), 
      SC_(-0.882951507568359375e2), SC_(-0.7460263729095458984375e1), SC_(0.135477006435394287109375e0), SC_(-0.82718880423302271609361236805097048706326618138613e0), 
      SC_(-0.882951507568359375e2), SC_(-0.729045963287353515625e1), SC_(0.905791938304901123046875e0), SC_(-0.87747551276758882959544200152954525505618423971659e0), 
      SC_(-0.882951507568359375e2), SC_(-0.623236083984375e1), SC_(0.835008561611175537109375e0), SC_(-0.65215237953434450934522345100560800793657047297229e0), 
      SC_(-0.882951507568359375e2), SC_(-0.5579319000244140625e1), SC_(0.12698681652545928955078125e0), SC_(-0.5122762429234107157399593560830350036728566184486e0), 
      SC_(-0.882951507568359375e2), SC_(-0.443003559112548828125e1), SC_(0.968867778778076171875e0), SC_(-0.54332403292257364440317808333720203684254160082478e0), 
      SC_(-0.882951507568359375e2), SC_(-0.38366591930389404296875e1), SC_(0.9133758544921875e0), SC_(-0.51338947010848800530828929008203919356014977411471e0), 
      SC_(-0.882951507568359375e2), SC_(0.9376299381256103515625e0), SC_(0.22103404998779296875e0), SC_(0.15824345778373739469179000212986130442374553398e0), 
      SC_(-0.882951507568359375e2), SC_(0.944411754608154296875e0), SC_(0.6323592662811279296875e0), SC_(0.16010110842241419282972789586647601062389080124406e0), 
      SC_(-0.882951507568359375e2), SC_(0.264718532562255859375e1), SC_(0.308167040348052978515625e0), SC_(0.18812698999986759709990325160594334177917367010501e0), 
      SC_(-0.882951507568359375e2), SC_(0.62944736480712890625e1), SC_(0.97540400922298431396484375e-1), SC_(0.6764648718685968528811245633241126898305817526621e0), 
      SC_(-0.882951507568359375e2), SC_(0.670017147064208984375e1), SC_(0.54722058773040771484375e0), SC_(0.81778541776042463995319059339588552698088433898419e0), 
      SC_(-0.882951507568359375e2), SC_(0.81158390045166015625e1), SC_(0.278498232364654541015625e0), SC_(0.83745249382380518272911191808287678555946548573727e0), 
      SC_(-0.882951507568359375e2), SC_(0.826751708984375e1), SC_(0.188381969928741455078125e0), SC_(0.83757094918096990315704827205570637800372489102387e0), 
      SC_(-0.882951507568359375e2), SC_(0.91501369476318359375e1), SC_(0.546881496906280517578125e0), SC_(0.88536530789452037214536364734769886885031477691156e0), 
      SC_(-0.882951507568359375e2), SC_(0.929777050018310546875e1), SC_(0.992881298065185546875e0), SC_(0.10670104592156217618232174187269358103233999652509e1), 
      SC_(-0.882951507568359375e2), SC_(0.93538990020751953125e1), SC_(0.957506835460662841796875e0), SC_(0.10357277056795963385227029717982264964969263725296e1), 
      SC_(-0.882951507568359375e2), SC_(0.93773555755615234375e1), SC_(0.996461331844329833984375e0), SC_(0.11393287366513926492075339545953276894721889046337e1), 
      SC_(-0.882951507568359375e2), SC_(0.98576259613037109375e1), SC_(0.964888513088226318359375e0), SC_(0.12490646709828734017662810793035855992633603697925e1), 
      SC_(-0.882951507568359375e2), SC_(0.992922687530517578125e1), SC_(0.967694938182830810546875e0), SC_(0.12562075694306417376583251897842403492180529464883e1), 
      SC_(-0.8681658935546875e2), SC_(-0.80491924285888671875e1), SC_(0.15761308372020721435546875e0), SC_(-0.84140469773208335456919923830249117896698295285825e0), 
      SC_(-0.8681658935546875e2), SC_(-0.7460263729095458984375e1), SC_(0.725838959217071533203125e0), SC_(-0.85987671052370888277919669524246227679947360493402e0), 
      SC_(-0.8681658935546875e2), SC_(-0.729045963287353515625e1), SC_(0.970592796802520751953125e0), SC_(-0.91443922525100421734210147418874666650910614494338e0), 
      SC_(-0.8681658935546875e2), SC_(-0.623236083984375e1), SC_(0.981109678745269775390625e0), SC_(-0.7106272156738935312370492307790173553201815649551e0), 
      SC_(-0.8681658935546875e2), SC_(-0.5579319000244140625e1), SC_(0.957166969776153564453125e0), SC_(-0.58106009812366507614405013631862001052582083043834e0), 
      SC_(-0.8681658935546875e2), SC_(-0.443003559112548828125e1), SC_(0.109861753880977630615234375e0), SC_(-0.49983870530384115095256605303312645824352714073227e0), 
      SC_(-0.8681658935546875e2), SC_(-0.38366591930389404296875e1), SC_(0.4853756427764892578125e0), SC_(-0.49428566816516318921025209597689924685446558273393e0), 
      SC_(-0.8681658935546875e2), SC_(0.9376299381256103515625e0), SC_(0.79810583591461181640625e0), SC_(0.16264406175756977733142719519534386130654412249944e0), 
      SC_(-0.8681658935546875e2), SC_(0.944411754608154296875e0), SC_(0.80028045177459716796875e0), SC_(0.16282022749627678393354605008370427957677491731307e0), 
      SC_(-0.8681658935546875e2), SC_(0.264718532562255859375e1), SC_(0.297029435634613037109375e0), SC_(0.18977993070188281230059741069586097466083740104406e0), 
      SC_(-0.8681658935546875e2), SC_(0.62944736480712890625e1), SC_(0.14188633859157562255859375e0), SC_(0.68239209777614933756004515248637654641240799137633e0), 
      SC_(-0.8681658935546875e2), SC_(0.670017147064208984375e1), SC_(0.47834846191108226776123046875e-2), SC_(0.81288526517388767163902468894469430412802255190882e0), 
      SC_(-0.8681658935546875e2), SC_(0.81158390045166015625e1), SC_(0.4217612743377685546875e0), SC_(0.84924877776215008160678238935268625874487764674281e0), 
      SC_(-0.8681658935546875e2), SC_(0.826751708984375e1), SC_(0.1124645173549652099609375e0), SC_(0.8436484863509619135739901228550661577676789921708e0), 
      SC_(-0.8681658935546875e2), SC_(0.91501369476318359375e1), SC_(0.915735542774200439453125e0), SC_(0.95373283829252902405087581062925853275855864089375e0), 
      SC_(-0.8681658935546875e2), SC_(0.929777050018310546875e1), SC_(0.639763355255126953125e0), SC_(0.93674317644311585360231935232845892831637346827973e0), 
      SC_(-0.8681658935546875e2), SC_(0.93538990020751953125e1), SC_(0.792207300662994384765625e0), SC_(0.98735879657086553764434857657877232118368138213484e0), 
      SC_(-0.8681658935546875e2), SC_(0.93773555755615234375e1), SC_(0.878430664539337158203125e0), SC_(0.1025248511731665221473972396370335124655052772948e1), 
      SC_(-0.8681658935546875e2), SC_(0.98576259613037109375e1), SC_(0.9594924449920654296875e0), SC_(0.12550759972155121101731042438144441861148487473869e1), 
      SC_(-0.8681658935546875e2), SC_(0.992922687530517578125e1), SC_(0.50366270542144775390625e0), SC_(0.11673484395886820589854473845868240195541869146431e1), 
      SC_(-0.847615814208984375e2), SC_(-0.80491924285888671875e1), SC_(0.655740678310394287109375e0), SC_(-0.87330537529798589363707267477409442925913183364478e0), 
      SC_(-0.847615814208984375e2), SC_(-0.7460263729095458984375e1), SC_(0.797928631305694580078125e0), SC_(-0.87904389668569057123243043710903035434038423609968e0), 
      SC_(-0.847615814208984375e2), SC_(-0.729045963287353515625e1), SC_(0.357116796076297760009765625e-1), SC_(-0.84078525712373178220947745986249080780651559495176e0), 
      SC_(-0.847615814208984375e2), SC_(-0.623236083984375e1), SC_(0.3612940013408660888671875e0), SC_(-0.63550174673913486415783145741809241052044800786891e0), 
      SC_(-0.847615814208984375e2), SC_(-0.5579319000244140625e1), SC_(0.84912931919097900390625e0), SC_(-0.55823097207697128640129681058469928375758518851429e0), 
      SC_(-0.847615814208984375e2), SC_(-0.443003559112548828125e1), SC_(0.21192432940006256103515625e0), SC_(-0.50653264566656418790206483978766196380143408274079e0), 
      SC_(-0.847615814208984375e2), SC_(-0.38366591930389404296875e1), SC_(0.93399322032928466796875e0), SC_(-0.52768082863143565944979426054840570548981898393827e0), 
      SC_(-0.847615814208984375e2), SC_(0.9376299381256103515625e0), SC_(0.6813595294952392578125e0), SC_(0.16345840597997446286580518084575460850493778657533e0), 
      SC_(-0.847615814208984375e2), SC_(0.944411754608154296875e0), SC_(0.67873513698577880859375e0), SC_(0.16358167818281164666410027933856064945511994225518e0), 
      SC_(-0.847615814208984375e2), SC_(0.264718532562255859375e1), SC_(0.3987385332584381103515625e0), SC_(0.19345780441354699416180322379934184345689867702227e0), 
      SC_(-0.847615814208984375e2), SC_(0.62944736480712890625e1), SC_(0.75774013996124267578125e0), SC_(0.71608605816567507682817792208387170386687198164273e0), 
      SC_(-0.847615814208984375e2), SC_(0.670017147064208984375e1), SC_(0.740647256374359130859375e0), SC_(0.8478488690134601561699988304099457366052743530796e0), 
      SC_(-0.847615814208984375e2), SC_(0.81158390045166015625e1), SC_(0.74313247203826904296875e0), SC_(0.88382693905031403996710245196053643566630916949913e0), 
      SC_(-0.847615814208984375e2), SC_(0.826751708984375e1), SC_(0.474758684635162353515625e0), SC_(0.86418097073779732383859343034185666552250993263043e0), 
      SC_(-0.847615814208984375e2), SC_(0.91501369476318359375e1), SC_(0.3922270238399505615234375e0), SC_(0.89564552708012969117963354018008675677974201436592e0), 
      SC_(-0.847615814208984375e2), SC_(0.929777050018310546875e1), SC_(0.42208766937255859375e0), SC_(0.9334232677038391406419076040839712278510329146248e0), 
      SC_(-0.847615814208984375e2), SC_(0.93538990020751953125e1), SC_(0.65547788143157958984375e0), SC_(0.98146659133251440967385843955400661406021307071047e0), 
      SC_(-0.847615814208984375e2), SC_(0.93773555755615234375e1), SC_(0.1738651692867279052734375e0), SC_(0.97451533127978846620711239186218485925497514027631e0), 
      SC_(-0.847615814208984375e2), SC_(0.98576259613037109375e1), SC_(0.1711866855621337890625e0), SC_(0.11640615124862612845435426946332017761732520618732e1), 
      SC_(-0.847615814208984375e2), SC_(0.992922687530517578125e1), SC_(0.3019131124019622802734375e0), SC_(0.11713665086347343936895377340529335101677296861788e1), 
      SC_(-0.8374275970458984375e2), SC_(-0.80491924285888671875e1), SC_(0.70604610443115234375e0), SC_(-0.88372212295494797215463296933963444292870259636239e0), 
      SC_(-0.8374275970458984375e2), SC_(-0.7460263729095458984375e1), SC_(0.797279894351959228515625e0), SC_(-0.884389956118873376054758977202078439642291683025e0), 
      SC_(-0.8374275970458984375e2), SC_(-0.729045963287353515625e1), SC_(0.318328440189361572265625e-1), SC_(-0.84577029328727123401881371301402450233725081369182e0), 
      SC_(-0.8374275970458984375e2), SC_(-0.623236083984375e1), SC_(0.316550433635711669921875e0), SC_(-0.63846339574416113373567010945277191420999632246177e0), 
      SC_(-0.8374275970458984375e2), SC_(-0.5579319000244140625e1), SC_(0.2769229710102081298828125e0), SC_(-0.52812726569592954195895319102905048273155320868794e0), 
      SC_(-0.8374275970458984375e2), SC_(-0.443003559112548828125e1), SC_(0.872428834438323974609375e0), SC_(-0.53746635053062118915090780793573108757406487056503e0), 
      SC_(-0.8374275970458984375e2), SC_(-0.38366591930389404296875e1), SC_(0.46171389520168304443359375e-1), SC_(-0.4978762597668464206276192008228893226722813811404e0), 
      SC_(-0.8374275970458984375e2), SC_(0.9376299381256103515625e0), SC_(0.1491139829158782958984375e0), SC_(0.16209570966545400371269348571638126889054705147418e0), 
      SC_(-0.8374275970458984375e2), SC_(0.944411754608154296875e0), SC_(0.9713177382946014404296875e-1), SC_(0.16215817203425741002240097327218770385678258272821e0), 
      SC_(-0.8374275970458984375e2), SC_(0.264718532562255859375e1), SC_(0.99406850337982177734375e0), SC_(0.24935641010054892689504363293132394056863376116041e0), 
      SC_(-0.8374275970458984375e2), SC_(0.62944736480712890625e1), SC_(0.82345783710479736328125e0), SC_(0.72852379014503319754408501161321583349729036432449e0), 
      SC_(-0.8374275970458984375e2), SC_(0.670017147064208984375e1), SC_(0.821903288364410400390625e0), SC_(0.86270426560123185475538774782641331349592543872963e0), 
      SC_(-0.8374275970458984375e2), SC_(0.81158390045166015625e1), SC_(0.69482862949371337890625e0), SC_(0.88363983765216152553062848228708719834142032113472e0), 
      SC_(-0.8374275970458984375e2), SC_(0.826751708984375e1), SC_(0.12518276274204254150390625e0), SC_(0.85904842549017092823420177568413379740184383148217e0), 
      SC_(-0.8374275970458984375e2), SC_(0.91501369476318359375e1), SC_(0.3170994818210601806640625e0), SC_(0.89832924292136367981143072212508421961914678883024e0), 
      SC_(-0.8374275970458984375e2), SC_(0.929777050018310546875e1), SC_(0.763750016689300537109375e0), SC_(0.97059068496073066167426174338823328956007114792457e0), 
      SC_(-0.8374275970458984375e2), SC_(0.93538990020751953125e1), SC_(0.950222074985504150390625e0), SC_(0.10612006545080664262749301630323796044048051408918e1), 
      SC_(-0.8374275970458984375e2), SC_(0.93773555755615234375e1), SC_(0.4905890524387359619140625e0), SC_(0.99255282683993851607920003517607189200775637266586e0), 
      SC_(-0.8374275970458984375e2), SC_(0.98576259613037109375e1), SC_(0.344460792839527130126953125e-1), SC_(0.11694252936742709575870544267044683470268199336139e1), 
      SC_(-0.8374275970458984375e2), SC_(0.992922687530517578125e1), SC_(0.663605511188507080078125e0), SC_(0.12020640620567294828443963915397922730117672481235e1), 
      SC_(-0.8108643341064453125e2), SC_(-0.80491924285888671875e1), SC_(0.438744366168975830078125e0), SC_(-0.87859118361492932890635940712463342603487276934114e0), 
      SC_(-0.8108643341064453125e2), SC_(-0.7460263729095458984375e1), SC_(0.125896632671356201171875e0), SC_(-0.86246232942728654389337818078876608085517066480744e0), 
      SC_(-0.8108643341064453125e2), SC_(-0.729045963287353515625e1), SC_(0.3815584480762481689453125e0), SC_(-0.86531869882965558516728450736093330408902320934679e0), 
      SC_(-0.8108643341064453125e2), SC_(-0.623236083984375e1), SC_(0.210209071636199951171875e0), SC_(-0.64738119246583903225050875393603159385656430274696e0), 
      SC_(-0.8108643341064453125e2), SC_(-0.5579319000244140625e1), SC_(0.765516817569732666015625e0), SC_(-0.56059463304084913173305663916600337025735588584011e0), 
      SC_(-0.8108643341064453125e2), SC_(-0.443003559112548828125e1), SC_(0.512164272367954254150390625e-1), SC_(-0.51665269949646002578918679272747584030640662128209e0), 
      SC_(-0.8108643341064453125e2), SC_(-0.38366591930389404296875e1), SC_(0.795199930667877197265625e0), SC_(-0.52384451344806999102617231824644764934621420943259e0), 
      SC_(-0.8108643341064453125e2), SC_(0.9376299381256103515625e0), SC_(0.3644125163555145263671875e-1), SC_(0.16445840518160456987391702277105422285907920849628e0), 
      SC_(-0.8108643341064453125e2), SC_(0.944411754608154296875e0), SC_(0.18687260150909423828125e0), SC_(0.16474696767300879366689546666380048282158346568439e0), 
      SC_(-0.8108643341064453125e2), SC_(0.264718532562255859375e1), SC_(0.408731162548065185546875e0), SC_(0.19840797638343060351692950308522644766521690786984e0), 
      SC_(-0.8108643341064453125e2), SC_(0.62944736480712890625e1), SC_(0.489764392375946044921875e0), SC_(0.71398140563703891872395460648428468137491882028094e0), 
      SC_(-0.8108643341064453125e2), SC_(0.670017147064208984375e1), SC_(0.457989156246185302734375e0), SC_(0.84822404783963092440991500193019683748102739719831e0), 
      SC_(-0.8108643341064453125e2), SC_(0.81158390045166015625e1), SC_(0.44558620452880859375e0), SC_(0.87986308474470030225798228603982857953905170417852e0), 
      SC_(-0.8108643341064453125e2), SC_(0.826751708984375e1), SC_(0.487568914890289306640625e0), SC_(0.88436325947691236451283766306608904084596781441351e0), 
      SC_(-0.8108643341064453125e2), SC_(0.91501369476318359375e1), SC_(0.646313011646270751953125e0), SC_(0.93444932755501769404248763040422379675950233463442e0), 
      SC_(-0.8108643341064453125e2), SC_(0.929777050018310546875e1), SC_(0.79397499561309814453125e0), SC_(0.99303396891886873286899719168424962345736666539291e0), 
      SC_(-0.8108643341064453125e2), SC_(0.93538990020751953125e1), SC_(0.709364831447601318359375e0), SC_(0.10113089860618333347517191530980568395386039428603e1), 
      SC_(-0.8108643341064453125e2), SC_(0.93773555755615234375e1), SC_(0.920874774456024169921875e0), SC_(0.10808552929543756610700604208995474057559564496361e1), 
      SC_(-0.8108643341064453125e2), SC_(0.98576259613037109375e1), SC_(0.754686653614044189453125e0), SC_(0.12295354495632079463330845547157275058202866491388e1), 
      SC_(-0.8108643341064453125e2), SC_(0.992922687530517578125e1), SC_(0.80753099918365478515625e0), SC_(0.12436454456645077592862193908866202419074285645364e1), 
      SC_(-0.773941650390625e2), SC_(-0.80491924285888671875e1), SC_(0.2760250866413116455078125e0), SC_(-0.8932148540886565731208171346158555892348489069094e0), 
      SC_(-0.773941650390625e2), SC_(-0.7460263729095458984375e1), SC_(0.705774247646331787109375e0), SC_(-0.90911600170226072523733344752741827766312826644628e0), 
      SC_(-0.773941650390625e2), SC_(-0.729045963287353515625e1), SC_(0.679702699184417724609375e0), SC_(-0.90307252252996060327047412347492031067987770551927e0), 
      SC_(-0.773941650390625e2), SC_(-0.623236083984375e1), SC_(0.281843240372836589813232421875e-2), SC_(-0.66184524324461086674676425686608102718274423987422e0), 
      SC_(-0.773941650390625e2), SC_(-0.5579319000244140625e1), SC_(0.655098021030426025390625e0), SC_(-0.56485567871439342824368759056518192042211356086454e0), 
      SC_(-0.773941650390625e2), SC_(-0.443003559112548828125e1), SC_(0.71070384979248046875e0), SC_(-0.54499556216095973731688980195992035683166980474925e0), 
      SC_(-0.773941650390625e2), SC_(-0.38366591930389404296875e1), SC_(0.16261173784732818603515625e0), SC_(-0.51759806991286134428377470768412712612017399270998e0), 
      SC_(-0.773941650390625e2), SC_(0.9376299381256103515625e0), SC_(0.6439609527587890625e0), SC_(0.17034640052266207186217781808632212721557190770662e0), 
      SC_(-0.773941650390625e2), SC_(0.944411754608154296875e0), SC_(0.11899767816066741943359375e0), SC_(0.16827148558288149859617822732363124521057243025749e0), 
      SC_(-0.773941650390625e2), SC_(0.264718532562255859375e1), SC_(0.456032812595367431640625e0), SC_(0.20438692374997551280023837500342413658498324878043e0), 
      SC_(-0.773941650390625e2), SC_(0.62944736480712890625e1), SC_(0.4983640611171722412109375e0), SC_(0.7309276134651405358086552048418329391801285475197e0), 
      SC_(-0.773941650390625e2), SC_(0.670017147064208984375e1), SC_(0.773917138576507568359375e0), SC_(0.89055977088355358439307320365748586774294360201894e0), 
      SC_(-0.773941650390625e2), SC_(0.81158390045166015625e1), SC_(0.959743976593017578125e0), SC_(0.99531676335901754810767630388113881874963219048658e0), 
      SC_(-0.773941650390625e2), SC_(0.826751708984375e1), SC_(0.57375466823577880859375e0), SC_(0.91117067311165093475982474002810561885330485399815e0), 
      SC_(-0.773941650390625e2), SC_(0.91501369476318359375e1), SC_(0.340385735034942626953125e0), SC_(0.93658342858480195937131579391711322436258042482381e0), 
      SC_(-0.773941650390625e2), SC_(0.929777050018310546875e1), SC_(0.876757442951202392578125e0), SC_(0.10397605043701780663060081372287147634699232294846e1), 
      SC_(-0.773941650390625e2), SC_(0.93538990020751953125e1), SC_(0.585267722606658935546875e0), SC_(0.10229369326315928906031121661140437619872328367048e1), 
      SC_(-0.773941650390625e2), SC_(0.93773555755615234375e1), SC_(0.808175504207611083984375e0), SC_(0.10722518384675640802147083500108659767503088646595e1), 
      SC_(-0.773941650390625e2), SC_(0.98576259613037109375e1), SC_(0.22381193935871124267578125e0), SC_(0.12176494797531315014416783578033364372790018390469e1), 
      SC_(-0.773941650390625e2), SC_(0.992922687530517578125e1), SC_(0.177738964557647705078125e-1), SC_(0.12190970933171117457967124449247889503348868475836e1), 
      SC_(-0.7347591400146484375e2), SC_(-0.80491924285888671875e1), SC_(0.75126707553863525390625e0), SC_(-0.95087480937103345785882377849311565120110564437638e0), 
      SC_(-0.7347591400146484375e2), SC_(-0.7460263729095458984375e1), SC_(0.821245968341827392578125e0), SC_(-0.94950993098396462121375210867253607422224927849825e0), 
      SC_(-0.7347591400146484375e2), SC_(-0.729045963287353515625e1), SC_(0.25509512424468994140625e0), SC_(-0.9045200860401375626315358789054868718505322190016e0), 
      SC_(-0.7347591400146484375e2), SC_(-0.623236083984375e1), SC_(0.820840775966644287109375e0), SC_(-0.71903825783534776610954520666065893889758555857181e0), 
      SC_(-0.7347591400146484375e2), SC_(-0.5579319000244140625e1), SC_(0.505957067012786865234375e0), SC_(-0.57170590587188313676826490532672893226496030624593e0), 
      SC_(-0.7347591400146484375e2), SC_(-0.443003559112548828125e1), SC_(0.940074026584625244140625e0), SC_(-0.58848704844694094917916885897249874192908410303486e0), 
      SC_(-0.7347591400146484375e2), SC_(-0.38366591930389404296875e1), SC_(0.699076712131500244140625e0), SC_(-0.54395952653919301847102230439509251513820671720908e0), 
      SC_(-0.7347591400146484375e2), SC_(0.9376299381256103515625e0), SC_(0.4126665294170379638671875e0), SC_(0.17310711621587319726163250266391593650519967029982e0), 
      SC_(-0.7347591400146484375e2), SC_(0.944411754608154296875e0), SC_(0.8909032344818115234375e0), SC_(0.17752902948723979782039869827626355347160537390438e0), 
      SC_(-0.7347591400146484375e2), SC_(0.264718532562255859375e1), SC_(0.4231651127338409423828125e0), SC_(0.20980384271452026798575538829326733452462406895996e0), 
      SC_(-0.7347591400146484375e2), SC_(0.62944736480712890625e1), SC_(0.959291398525238037109375e0), SC_(0.82086333400151687698897951981706597500774785782777e0), 
      SC_(-0.7347591400146484375e2), SC_(0.670017147064208984375e1), SC_(0.5809566974639892578125e0), SC_(0.89610426115226375331268690519494509999425108823564e0), 
      SC_(-0.7347591400146484375e2), SC_(0.81158390045166015625e1), SC_(0.547215521335601806640625e0), SC_(0.93069116944348264332798545618518025050601300111396e0), 
      SC_(-0.7347591400146484375e2), SC_(0.826751708984375e1), SC_(0.15805758535861968994140625e0), SC_(0.91723576267139431165402940672716686870465495104736e0), 
      SC_(-0.7347591400146484375e2), SC_(0.91501369476318359375e1), SC_(0.13862444460391998291015625e0), SC_(0.95637671681392516587796946344990127808067074081669e0), 
      SC_(-0.7347591400146484375e2), SC_(0.929777050018310546875e1), SC_(0.761731207370758056640625e0), SC_(0.10413633010402629935885186303991761629601547367282e1), 
      SC_(-0.7347591400146484375e2), SC_(0.93538990020751953125e1), SC_(0.14929400384426116943359375e0), SC_(0.10296784809989317698803281996894596021922140169983e1), 
      SC_(-0.7347591400146484375e2), SC_(0.93773555755615234375e1), SC_(0.23015606403350830078125e0), SC_(0.10501297999166441907280121655001731450321290904874e1), 
      SC_(-0.7347591400146484375e2), SC_(0.98576259613037109375e1), SC_(0.2575082480907440185546875e0), SC_(0.12496419008656533189921781582218971934138022766036e1), 
      SC_(-0.7347591400146484375e2), SC_(0.992922687530517578125e1), SC_(0.809734523296356201171875e0), SC_(0.13075339829659951141421742562150260254408805079828e1), 
      SC_(-0.665802154541015625e2), SC_(-0.80491924285888671875e1), SC_(0.840717256069183349609375e0), SC_(-0.10188273068137002157811845899293366196751404623348e1), 
      SC_(-0.665802154541015625e2), SC_(-0.7460263729095458984375e1), SC_(0.988521575927734375e0), SC_(-0.10896711710037999407125986590139024748941957043169e1), 
      SC_(-0.665802154541015625e2), SC_(-0.729045963287353515625e1), SC_(0.254282176494598388671875e0), SC_(-0.94921935951206273103486119985951451353744945023903e0), 
      SC_(-0.665802154541015625e2), SC_(-0.623236083984375e1), SC_(0.3324482738971710205078125e0), SC_(-0.72093569286169587462569345892994331413933209655934e0), 
      SC_(-0.665802154541015625e2), SC_(-0.5579319000244140625e1), SC_(0.814284801483154296875e0), SC_(-0.62920826774684038107957598026589974209853888829193e0), 
      SC_(-0.665802154541015625e2), SC_(-0.443003559112548828125e1), SC_(0.2998317182064056396484375e0), SC_(-0.57164640115497264513848696876101131605723935622895e0), 
      SC_(-0.665802154541015625e2), SC_(-0.38366591930389404296875e1), SC_(0.243524968624114990234375e0), SC_(-0.55710727670602591390039391663442128128111057798818e0), 
      SC_(-0.665802154541015625e2), SC_(0.9376299381256103515625e0), SC_(0.13539127074182033538818359375e-1), SC_(0.18024669606887376221738847713236560081387665795213e0), 
      SC_(-0.665802154541015625e2), SC_(0.944411754608154296875e0), SC_(0.929263651371002197265625e0), SC_(0.1867600495413145208998726836094505670779096922184e0), 
      SC_(-0.665802154541015625e2), SC_(0.264718532562255859375e1), SC_(0.21723784506320953369140625e0), SC_(0.21895569911849486446155497352191284985201480630693e0), 
      SC_(-0.665802154541015625e2), SC_(0.62944736480712890625e1), SC_(0.349983751773834228515625e0), SC_(0.78092451307667541706139295421653294407669234196721e0), 
      SC_(-0.665802154541015625e2), SC_(0.670017147064208984375e1), SC_(0.90736472606658935546875e0), SC_(0.98826473823950068612417716920226018353302777435485e0), 
      SC_(-0.665802154541015625e2), SC_(0.81158390045166015625e1), SC_(0.196595251560211181640625e0), SC_(0.96146543728501332020960328049092986515308213947491e0), 
      SC_(-0.665802154541015625e2), SC_(0.826751708984375e1), SC_(0.848467767238616943359375e0), SC_(0.10269900029299020133992969273694842932510481147321e1), 
      SC_(-0.665802154541015625e2), SC_(0.91501369476318359375e1), SC_(0.251083850860595703125e0), SC_(0.10089283079579986340968754531420948668429390499878e1), 
      SC_(-0.665802154541015625e2), SC_(0.929777050018310546875e1), SC_(0.955017566680908203125e0), SC_(0.11775854562840446904405699037220635771661867806639e1), 
      SC_(-0.665802154541015625e2), SC_(0.93538990020751953125e1), SC_(0.616044700145721435546875e0), SC_(0.11107403391640015213404677110283900580694627478772e1), 
      SC_(-0.665802154541015625e2), SC_(0.93773555755615234375e1), SC_(0.778897702693939208984375e0), SC_(0.11552618410136336171509628042037351937018229651029e1), 
      SC_(-0.665802154541015625e2), SC_(0.98576259613037109375e1), SC_(0.473288834095001220703125e0), SC_(0.13221383720258285984513734807011511703421959348329e1), 
      SC_(-0.665802154541015625e2), SC_(0.992922687530517578125e1), SC_(0.987459599971771240234375e0), SC_(0.15024269882107774743502539665001810907698548175078e1), 
      SC_(-0.6435646820068359375e2), SC_(-0.80491924285888671875e1), SC_(0.3516595065593719482421875e0), SC_(-0.9817165960179087152726590328661203544092211870457e0), 
      SC_(-0.6435646820068359375e2), SC_(-0.7460263729095458984375e1), SC_(0.6759537756443023681640625e-1), SC_(-0.96538678194946875594576577465920713344794683420125e0), 
      SC_(-0.6435646820068359375e2), SC_(-0.729045963287353515625e1), SC_(0.830828607082366943359375e0), SC_(-0.10133284014247603716459775304959877628994268756e1), 
      SC_(-0.6435646820068359375e2), SC_(-0.623236083984375e1), SC_(0.79359757900238037109375e0), SC_(-0.76840043572249960219837227522269364466391173244608e0), 
      SC_(-0.6435646820068359375e2), SC_(-0.5579319000244140625e1), SC_(0.58526408672332763671875e0), SC_(-0.61667383392065171823591906057950002149491251832054e0), 
      SC_(-0.6435646820068359375e2), SC_(-0.443003559112548828125e1), SC_(0.594503581523895263671875e0), SC_(-0.59093783467978499643545265943887405937777474424327e0), 
      SC_(-0.6435646820068359375e2), SC_(-0.38366591930389404296875e1), SC_(0.54972362518310546875e0), SC_(-0.57343614327375731547647986833382833135785422850524e0), 
      SC_(-0.6435646820068359375e2), SC_(0.9376299381256103515625e0), SC_(0.73279869556427001953125e0), SC_(0.18670691881147002417117313950467332320722346461714e0), 
      SC_(-0.6435646820068359375e2), SC_(0.944411754608154296875e0), SC_(0.9171936511993408203125e0), SC_(0.18959407313520176656360185314820894089038687280444e0), 
      SC_(-0.6435646820068359375e2), SC_(0.264718532562255859375e1), SC_(0.695232868194580078125e0), SC_(0.23434052914949470882728223063559974291611964287342e0), 
      SC_(-0.6435646820068359375e2), SC_(0.62944736480712890625e1), SC_(0.285839021205902099609375e0), SC_(0.79208308995030110951386884974283642578125957216677e0), 
      SC_(-0.6435646820068359375e2), SC_(0.670017147064208984375e1), SC_(0.679819762706756591796875e0), SC_(0.96404391319487077627796490967938971550946060810627e0), 
      SC_(-0.6435646820068359375e2), SC_(0.81158390045166015625e1), SC_(0.7572002410888671875e0), SC_(0.10203825214491552379106223664363875813234384638789e1), 
      SC_(-0.6435646820068359375e2), SC_(0.826751708984375e1), SC_(0.3923204839229583740234375e0), SC_(0.98757622792126226190502515447988405388474664377118e0), 
      SC_(-0.6435646820068359375e2), SC_(0.91501369476318359375e1), SC_(0.7537291049957275390625e0), SC_(0.10726263442312762552866095199193489225305106100888e1), 
      SC_(-0.6435646820068359375e2), SC_(0.929777050018310546875e1), SC_(0.561557471752166748046875e0), SC_(0.10902014671256490017045890530601878226899940746231e1), 
      SC_(-0.6435646820068359375e2), SC_(0.93538990020751953125e1), SC_(0.38044583797454833984375e0), SC_(0.11112511164324106462787438914977149990321935332184e1), 
      SC_(-0.6435646820068359375e2), SC_(0.93773555755615234375e1), SC_(0.20806805789470672607421875e0), SC_(0.11233205201488051119834974335442507168381438412903e1), 
      SC_(-0.6435646820068359375e2), SC_(0.98576259613037109375e1), SC_(0.56782162189483642578125e0), SC_(0.13526541087049132183289874385476747389694582496712e1), 
      SC_(-0.6435646820068359375e2), SC_(0.992922687530517578125e1), SC_(0.527371466159820556640625e0), SC_(0.13539587921924345769977234823571137863565379759269e1), 
      SC_(-0.63019954681396484375e2), SC_(-0.80491924285888671875e1), SC_(0.75854294002056121826171875e-1), SC_(-0.98500590690622495958090408113313427850035679560375e0), 
      SC_(-0.63019954681396484375e2), SC_(-0.7460263729095458984375e1), SC_(0.4042085111141204833984375e0), SC_(-0.98412863749897126977607259739114076572076938942833e0), 
      SC_(-0.63019954681396484375e2), SC_(-0.729045963287353515625e1), SC_(0.539501197636127471923828125e-1), SC_(-0.97189137379734463759122464015058860586785292328841e0), 
      SC_(-0.63019954681396484375e2), SC_(-0.623236083984375e1), SC_(0.352762401103973388671875e0), SC_(-0.74269788804239642012872127953182668059308423879464e0), 
      SC_(-0.63019954681396484375e2), SC_(-0.5579319000244140625e1), SC_(0.530797541141510009765625e0), SC_(-0.62005785085207845051844205441148792788340980014671e0), 
      SC_(-0.63019954681396484375e2), SC_(-0.443003559112548828125e1), SC_(0.59282386302947998046875e0), SC_(-0.597059143795725250705919305765788031814303367226e0), 
      SC_(-0.63019954681396484375e2), SC_(-0.38366591930389404296875e1), SC_(0.779167234897613525390625e0), SC_(-0.59209104695778783703470799000957039737742060559891e0), 
      SC_(-0.63019954681396484375e2), SC_(0.9376299381256103515625e0), SC_(0.3563451468944549560546875e0), SC_(0.18566644649955566637841875495067297091050117737277e0), 
      SC_(-0.63019954681396484375e2), SC_(0.944411754608154296875e0), SC_(0.934010684490203857421875e0), SC_(0.19182574957907954921849822011736028299192760496169e0), 
      SC_(-0.63019954681396484375e2), SC_(0.264718532562255859375e1), SC_(0.964966356754302978515625e0), SC_(0.27188964239796694238940440658822118662901998900666e0), 
      SC_(-0.63019954681396484375e2), SC_(0.62944736480712890625e1), SC_(0.1299062073230743408203125e0), SC_(0.79727537820039161658416433826246692454270885756196e0), 
      SC_(-0.63019954681396484375e2), SC_(0.670017147064208984375e1), SC_(0.15443842113018035888671875e0), SC_(0.94832446598989097197762015761507479997386259580165e0), 
      SC_(-0.63019954681396484375e2), SC_(0.81158390045166015625e1), SC_(0.568823635578155517578125e0), SC_(0.10073151413041581203666466746194579312685969632522e1), 
      SC_(-0.63019954681396484375e2), SC_(0.826751708984375e1), SC_(0.3949082195758819580078125e0), SC_(0.99812651758556271402054140359168395197326899687466e0), 
      SC_(-0.63019954681396484375e2), SC_(0.91501369476318359375e1), SC_(0.4693906307220458984375e0), SC_(0.10495027136918084682299358741490935779364803240006e1), 
      SC_(-0.63019954681396484375e2), SC_(0.929777050018310546875e1), SC_(0.387295901775360107421875e0), SC_(0.10888718630252144153980406708608581585871568467485e1), 
      SC_(-0.63019954681396484375e2), SC_(0.93538990020751953125e1), SC_(0.1190206967294216156005859375e-1), SC_(0.11133564704439333169474640711725371148300660942283e1), 
      SC_(-0.63019954681396484375e2), SC_(0.93773555755615234375e1), SC_(0.7269546985626220703125e0), SC_(0.11789865268828697806765849246641829515571854757345e1), 
      SC_(-0.63019954681396484375e2), SC_(0.98576259613037109375e1), SC_(0.3371226489543914794921875e0), SC_(0.13492787097950413298503737277521718702647137760674e1), 
      SC_(-0.63019954681396484375e2), SC_(0.992922687530517578125e1), SC_(0.3885698020458221435546875e0), SC_(0.13573834162755449357438378572504748466832889364914e1), 
      SC_(-0.4175492095947265625e2), SC_(-0.80491924285888671875e1), SC_(0.1621823012828826904296875e0), SC_(-0.120795261246058046094427409425800499482700613075e1), 
      SC_(-0.4175492095947265625e2), SC_(-0.7460263729095458984375e1), SC_(0.9274928569793701171875e0), SC_(-0.13174752300415630669485025374126187413863221080021e1), 
      SC_(-0.4175492095947265625e2), SC_(-0.729045963287353515625e1), SC_(0.794284522533416748046875e0), SC_(-0.12529561815575374606363360092969101368442032236984e1), 
      SC_(-0.4175492095947265625e2), SC_(-0.623236083984375e1), SC_(0.4361175596714019775390625e0), SC_(-0.9250452379885350159859795235944251926347543194692e0), 
      SC_(-0.4175492095947265625e2), SC_(-0.5579319000244140625e1), SC_(0.31121504306793212890625e0), SC_(-0.7538145969086396421224084652562621089655298505018e0), 
      SC_(-0.4175492095947265625e2), SC_(-0.443003559112548828125e1), SC_(0.86267817020416259765625e0), SC_(-0.76741616650994055602680866373057361490958141543863e0), 
      SC_(-0.4175492095947265625e2), SC_(-0.38366591930389404296875e1), SC_(0.528533160686492919921875e0), SC_(-0.70482408941893316804322816995626853819821807220181e0), 
      SC_(-0.4175492095947265625e2), SC_(0.9376299381256103515625e0), SC_(0.62036001682281494140625e0), SC_(0.22675666588050360907864991174641846495089194336662e0), 
      SC_(-0.4175492095947265625e2), SC_(0.944411754608154296875e0), SC_(0.1656487286090850830078125e0), SC_(0.22361257639294591468520562032875589983389610668123e0), 
      SC_(-0.4175492095947265625e2), SC_(0.264718532562255859375e1), SC_(0.119547180831432342529296875e0), SC_(0.28291475589845511069693388388718700321326522633299e0), 
      SC_(-0.4175492095947265625e2), SC_(0.62944736480712890625e1), SC_(0.601981937885284423828125e0), SC_(0.99995519291018168171725132061178520364978180674488e0), 
      SC_(-0.4175492095947265625e2), SC_(0.670017147064208984375e1), SC_(0.471956789493560791015625e0), SC_(0.11666873923248537852675579183118050354735765930848e1), 
      SC_(-0.4175492095947265625e2), SC_(0.81158390045166015625e1), SC_(0.26297128200531005859375e0), SC_(0.12133153387822629978232861051967343996399885782447e1), 
      SC_(-0.4175492095947265625e2), SC_(0.826751708984375e1), SC_(0.3402197062969207763671875e0), SC_(0.12217178356852959376032196472008153885377815037761e1), 
      SC_(-0.4175492095947265625e2), SC_(0.91501369476318359375e1), SC_(0.65407907962799072265625e0), SC_(0.13279252914501877561507955936796843070673005732138e1), 
      SC_(-0.4175492095947265625e2), SC_(0.929777050018310546875e1), SC_(0.529841959476470947265625e0), SC_(0.13656676123466169022712955081182486001106665498498e1), 
      SC_(-0.4175492095947265625e2), SC_(0.93538990020751953125e1), SC_(0.689214527606964111328125e0), SC_(0.14337545471116318094856403555847079818004907883012e1), 
      SC_(-0.4175492095947265625e2), SC_(0.93773555755615234375e1), SC_(0.7161006927490234375e0), SC_(0.14607306414559000356444256630640763896008527344224e1), 
      SC_(-0.4175492095947265625e2), SC_(0.98576259613037109375e1), SC_(0.748151600360870361328125e0), SC_(0.17085140665784459363918709055928708315385830054916e1), 
      SC_(-0.4175492095947265625e2), SC_(0.992922687530517578125e1), SC_(0.988379418849945068359375e0), SC_(0.19446986681889952661021520443896477218754466943203e1), 
      SC_(-0.343742218017578125e2), SC_(-0.80491924285888671875e1), SC_(0.4505415856838226318359375e0), SC_(-0.13479975513922595551769378292693820169944079349109e1), 
      SC_(-0.343742218017578125e2), SC_(-0.7460263729095458984375e1), SC_(0.72049343585968017578125e0), SC_(-0.13703556121569037399000627811561678552285461106504e1), 
      SC_(-0.343742218017578125e2), SC_(-0.729045963287353515625e1), SC_(0.83821378648281097412109375e-1), SC_(-0.1303342505681818948447295923953804059935413644859e1), 
      SC_(-0.343742218017578125e2), SC_(-0.623236083984375e1), SC_(0.91257750988006591796875e0), SC_(-0.11294830414606136778667009626697912105252028682613e1), 
      SC_(-0.343742218017578125e2), SC_(-0.5579319000244140625e1), SC_(0.2289769649505615234375e0), SC_(-0.82890505767135632841245606272875702379699274786215e0), 
      SC_(-0.343742218017578125e2), SC_(-0.443003559112548828125e1), SC_(0.50549852848052978515625e0), SC_(-0.79934667651914845927640385358968563214392195753056e0), 
      SC_(-0.343742218017578125e2), SC_(-0.38366591930389404296875e1), SC_(0.91333734989166259765625e0), SC_(-0.82682535778223123699046084359484621989324749067695e0), 
      SC_(-0.343742218017578125e2), SC_(0.9376299381256103515625e0), SC_(0.5582687854766845703125e0), SC_(0.24685830836478899133045090397417486519430646436729e0), 
      SC_(-0.343742218017578125e2), SC_(0.944411754608154296875e0), SC_(0.152378022670745849609375e0), SC_(0.24398748687404748781743632838424801718263030559703e0), 
      SC_(-0.343742218017578125e2), SC_(0.264718532562255859375e1), SC_(0.50319004058837890625e0), SC_(0.32475815298585388051217187166943870406639890288675e0), 
      SC_(-0.343742218017578125e2), SC_(0.62944736480712890625e1), SC_(0.82581698894500732421875e0), SC_(0.11487205744846719651900666371036908548224029447782e1), 
      SC_(-0.343742218017578125e2), SC_(0.670017147064208984375e1), SC_(0.4624741971492767333984375e0), SC_(0.12781972640570686895211039067960987037176484629231e1), 
      SC_(-0.343742218017578125e2), SC_(0.81158390045166015625e1), SC_(0.538342416286468505859375e0), SC_(0.13612343388208463390090639154711944895417233344461e1), 
      SC_(-0.343742218017578125e2), SC_(0.826751708984375e1), SC_(0.546591937541961669921875e0), SC_(0.13680530164078413056057430863001410157204666851678e1), 
      SC_(-0.343742218017578125e2), SC_(0.91501369476318359375e1), SC_(0.996134698390960693359375e0), SC_(0.18655695809680774366714326899093076682373542523498e1), 
      SC_(-0.343742218017578125e2), SC_(0.929777050018310546875e1), SC_(0.4475843906402587890625e0), SC_(0.15004687166502580782333712850281558671535405873258e1), 
      SC_(-0.343742218017578125e2), SC_(0.93538990020751953125e1), SC_(0.7817552983760833740234375e-1), SC_(0.15181488238754879931513195889959090600253799328776e1), 
      SC_(-0.343742218017578125e2), SC_(0.93773555755615234375e1), SC_(0.854451000690460205078125e0), SC_(0.16760909597075604362773160009790333071013619466631e1), 
      SC_(-0.343742218017578125e2), SC_(0.98576259613037109375e1), SC_(0.442678272724151611328125e0), SC_(0.18152146396602763271153860892382470806721161498474e1), 
      SC_(-0.343742218017578125e2), SC_(0.992922687530517578125e1), SC_(0.60423147678375244140625e0), SC_(0.18508520738181786128694649050909747053325716149189e1), 
      SC_(-0.34333530426025390625e2), SC_(-0.80491924285888671875e1), SC_(0.106652773916721343994140625e0), SC_(-0.13279977284904041350281000241938369548785223697577e1), 
      SC_(-0.34333530426025390625e2), SC_(-0.7460263729095458984375e1), SC_(0.4985441863536834716796875e0), SC_(-0.1334511622966934522664921590597835503735575547594e1), 
      SC_(-0.34333530426025390625e2), SC_(-0.729045963287353515625e1), SC_(0.9618980884552001953125e0), SC_(-0.14897917634191362332402630913581746649519180819487e1), 
      SC_(-0.34333530426025390625e2), SC_(-0.623236083984375e1), SC_(0.979925632476806640625e0), SC_(-0.1217204537505011042501342908103217792690814382835e1), 
      SC_(-0.34333530426025390625e2), SC_(-0.5579319000244140625e1), SC_(0.463422574102878570556640625e-2), SC_(-0.82568435419092317843441647933912906296313127078829e0), 
      SC_(-0.34333530426025390625e2), SC_(-0.443003559112548828125e1), SC_(0.34317314624786376953125e-1), SC_(-0.78462936005604349430919825872962477090224791930058e0), 
      SC_(-0.34333530426025390625e2), SC_(-0.38366591930389404296875e1), SC_(0.774910449981689453125e0), SC_(-0.79664639148531813063607869208741112387341335494939e0), 
      SC_(-0.34333530426025390625e2), SC_(0.9376299381256103515625e0), SC_(0.97700202465057373046875e0), SC_(0.25656860596889451120028077862413338482440877002465e0), 
      SC_(-0.34333530426025390625e2), SC_(0.944411754608154296875e0), SC_(0.817303240299224853515625e0), SC_(0.2520924137849429911434650768834743243609584274321e0), 
      SC_(-0.34333530426025390625e2), SC_(0.264718532562255859375e1), SC_(0.3631864488124847412109375e0), SC_(0.31993149126421029963751218590715125280138845779776e0), 
      SC_(-0.34333530426025390625e2), SC_(0.62944736480712890625e1), SC_(0.868694722652435302734375e0), SC_(0.11664250660215187060602386358108081959735100324201e1), 
      SC_(-0.34333530426025390625e2), SC_(0.670017147064208984375e1), SC_(0.679519712924957275390625e0), SC_(0.13069359111529715358978257153546992330592505947366e1), 
      SC_(-0.34333530426025390625e2), SC_(0.81158390045166015625e1), SC_(0.844358503818511962890625e-1), SC_(0.13295715108775444839528476157145770231834928108712e1), 
      SC_(-0.34333530426025390625e2), SC_(0.826751708984375e1), SC_(0.3462333977222442626953125e0), SC_(0.13464880482579583789080729576915252804514158778708e1), 
      SC_(-0.34333530426025390625e2), SC_(0.91501369476318359375e1), SC_(0.399782657623291015625e0), SC_(0.14312418120119051757097649396370747274218343935686e1), 
      SC_(-0.34333530426025390625e2), SC_(0.929777050018310546875e1), SC_(0.85587513446807861328125e0), SC_(0.16148925024405359404552782420491687146836901056951e1), 
      SC_(-0.34333530426025390625e2), SC_(0.93538990020751953125e1), SC_(0.25987040996551513671875e0), SC_(0.15262980724861982196631463226450350415827916935991e1), 
      SC_(-0.34333530426025390625e2), SC_(0.93773555755615234375e1), SC_(0.450595431029796600341796875e-1), SC_(0.15395174965016545160280499554617795840656649867521e1), 
      SC_(-0.34333530426025390625e2), SC_(0.98576259613037109375e1), SC_(0.80006849765777587890625e0), SC_(0.19025623542859519938528700880258842846879099856296e1), 
      SC_(-0.34333530426025390625e2), SC_(0.992922687530517578125e1), SC_(0.660119473934173583984375e0), SC_(0.18648209052720236320619177899513333819481990439113e1), 
      SC_(-0.241168880462646484375e2), SC_(-0.80491924285888671875e1), SC_(0.431413829326629638671875e0), SC_(-0.16023502713402494472723003516587049998209785546895e1), 
      SC_(-0.241168880462646484375e2), SC_(-0.7460263729095458984375e1), SC_(0.74994099140167236328125e0), SC_(-0.16456360566700002297427798153127364630861157638657e1), 
      SC_(-0.241168880462646484375e2), SC_(-0.729045963287353515625e1), SC_(0.910647571086883544921875e0), SC_(-0.17266003527583797748130431834380479246102745294251e1), 
      SC_(-0.241168880462646484375e2), SC_(-0.623236083984375e1), SC_(0.13299603760242462158203125e0), SC_(-0.12057606990231589776592810687151553595414706314624e1), 
      SC_(-0.241168880462646484375e2), SC_(-0.5579319000244140625e1), SC_(0.18184702098369598388671875e0), SC_(-0.98954385708862193740632461032650778809879826353565e0), 
      SC_(-0.241168880462646484375e2), SC_(-0.443003559112548828125e1), SC_(0.982360541820526123046875e0), SC_(-0.11177365522434554666194320059624646206412030819708e1), 
      SC_(-0.241168880462646484375e2), SC_(-0.38366591930389404296875e1), SC_(0.2638029158115386962890625e0), SC_(-0.89778711803164644220095019446212441642706564004599e0), 
      SC_(-0.241168880462646484375e2), SC_(0.9376299381256103515625e0), SC_(0.95355175435543060302734375e-1), SC_(0.28453468481817449880562759769641913603812839859891e0), 
      SC_(-0.241168880462646484375e2), SC_(0.944411754608154296875e0), SC_(0.145538985729217529296875e0), SC_(0.28510725672839938842843953939313088243819071411751e0), 
      SC_(-0.241168880462646484375e2), SC_(0.264718532562255859375e1), SC_(0.282673299312591552734375e0), SC_(0.38806416515257251994451900474201338041932494961011e0), 
      SC_(-0.241168880462646484375e2), SC_(0.62944736480712890625e1), SC_(0.1360685527324676513671875e0), SC_(0.12669328056141228178678376410162804212761576165186e1), 
      SC_(-0.241168880462646484375e2), SC_(0.670017147064208984375e1), SC_(0.802111446857452392578125e0), SC_(0.15866920300492384671906062444616074158561009589133e1), 
      SC_(-0.241168880462646484375e2), SC_(0.81158390045166015625e1), SC_(0.869292199611663818359375e0), SC_(0.17580740177364505152978420916456554527932644010013e1), 
      SC_(-0.241168880462646484375e2), SC_(0.826751708984375e1), SC_(0.77557027339935302734375e-1), SC_(0.15854002003461329001582140234962559880549849362185e1), 
      SC_(-0.241168880462646484375e2), SC_(0.91501369476318359375e1), SC_(0.579704582691192626953125e0), SC_(0.17519871309560501964641364820634189603930907023157e1), 
      SC_(-0.241168880462646484375e2), SC_(0.929777050018310546875e1), SC_(0.627384364604949951171875e0), SC_(0.18427916539366589294455916469285828510962125225628e1), 
      SC_(-0.241168880462646484375e2), SC_(0.93538990020751953125e1), SC_(0.549860179424285888671875e0), SC_(0.18674316708523376822796984823486841996872762318407e1), 
      SC_(-0.241168880462646484375e2), SC_(0.93773555755615234375e1), SC_(0.80939121544361114501953125e-2), SC_(0.18339823844391585199178838406559806663824944159363e1), 
      SC_(-0.241168880462646484375e2), SC_(0.98576259613037109375e1), SC_(0.14495480060577392578125e0), SC_(0.21160590802963202158749936227001100026331858328541e1), 
      SC_(-0.241168880462646484375e2), SC_(0.992922687530517578125e1), SC_(0.680287063121795654296875e0), SC_(0.22210678951847687738723989633440228220976733521782e1), 
      SC_(-0.128993244171142578125e2), SC_(-0.80491924285888671875e1), SC_(0.853031098842620849609375e0), SC_(-0.24079361851204479921891268817182253251232689836778e1), 
      SC_(-0.128993244171142578125e2), SC_(-0.7460263729095458984375e1), SC_(0.533933103084564208984375e0), SC_(-0.21454521037373319640079056178938384238377823309896e1), 
      SC_(-0.128993244171142578125e2), SC_(-0.729045963287353515625e1), SC_(0.622055113315582275390625e0), SC_(-0.21576028937097498916608800866807907042683606024172e1), 
      SC_(-0.128993244171142578125e2), SC_(-0.623236083984375e1), SC_(0.438666820526123046875e0), SC_(-0.16727712487955901880521454949575269670899198271666e1), 
      SC_(-0.128993244171142578125e2), SC_(-0.5579319000244140625e1), SC_(0.3509523868560791015625e0), SC_(-0.1367589634320150725173132003026336230738172555467e1), 
      SC_(-0.128993244171142578125e2), SC_(-0.443003559112548828125e1), SC_(0.19955120980739593505859375e0), SC_(-0.12481677362168626813305915580886898862058145245232e1), 
      SC_(-0.128993244171142578125e2), SC_(-0.38366591930389404296875e1), SC_(0.51324951648712158203125e0), SC_(-0.12111972445052865188571007381329352452899049551273e1), 
      SC_(-0.128993244171142578125e2), SC_(0.9376299381256103515625e0), SC_(0.13800132274627685546875e0), SC_(0.36961245357279766982192761986474662555034295891376e0), 
      SC_(-0.128993244171142578125e2), SC_(0.944411754608154296875e0), SC_(0.4018080234527587890625e0), SC_(0.37365897757366594690230982682926729188171480701809e0), 
      SC_(-0.128993244171142578125e2), SC_(0.264718532562255859375e1), SC_(0.3823329508304595947265625e0), SC_(0.55802560396267272549148764986721981955704897042777e0), 
      SC_(-0.128993244171142578125e2), SC_(0.62944736480712890625e1), SC_(0.75966693460941314697265625e-1), SC_(0.1697635886982840929361398122359491269105661967274e1), 
      SC_(-0.128993244171142578125e2), SC_(0.670017147064208984375e1), SC_(0.762421309947967529296875e0), SC_(0.21133604370430735932215952668677325486130857445504e1), 
      SC_(-0.128993244171142578125e2), SC_(0.81158390045166015625e1), SC_(0.23991616070270538330078125e0), SC_(0.21396387948259641643216926338689636512223316574779e1), 
      SC_(-0.128993244171142578125e2), SC_(0.826751708984375e1), SC_(0.404711104929447174072265625e-1), SC_(0.21384708015630843067007079645791906394706351959173e1), 
      SC_(-0.128993244171142578125e2), SC_(0.91501369476318359375e1), SC_(0.123318932950496673583984375e0), SC_(0.2314779449400068343659213264082432822031924922705e1), 
      SC_(-0.128993244171142578125e2), SC_(0.929777050018310546875e1), SC_(0.252955973148345947265625e0), SC_(0.24264097675863925255167755532256061802966767141351e1), 
      SC_(-0.128993244171142578125e2), SC_(0.93538990020751953125e1), SC_(0.18390779197216033935546875e0), SC_(0.2467759375685390663293985869012447296877874727909e1), 
      SC_(-0.128993244171142578125e2), SC_(0.93773555755615234375e1), SC_(0.5047709941864013671875e0), SC_(0.25585955275249889700976428791221494716932973983553e1), 
      SC_(-0.128993244171142578125e2), SC_(0.98576259613037109375e1), SC_(0.23995251953601837158203125e0), SC_(0.2824392841101831227091786623896912706301389023636e1), 
      SC_(-0.128993244171142578125e2), SC_(0.992922687530517578125e1), SC_(0.822604954242706298828125e0), SC_(0.31215115735264316651757015163351424114015959581724e1), 
      SC_(-0.422729969024658203125e1), SC_(-0.80491924285888671875e1), SC_(0.4172670543193817138671875e0), SC_(-0.35764220116276091744932472903421688990599962425547e1), 
      SC_(-0.422729969024658203125e1), SC_(-0.7460263729095458984375e1), SC_(0.981723129749298095703125e0), SC_(-0.48063333717671114488090570427265318173987703125174e1), 
      SC_(-0.422729969024658203125e1), SC_(-0.729045963287353515625e1), SC_(0.49654424190521240234375e-1), SC_(-0.33184188366452256813741116772425826277382283754391e1), 
      SC_(-0.422729969024658203125e1), SC_(-0.623236083984375e1), SC_(0.823455393314361572265625e0), SC_(-0.31647281735977406397662322137297899587454929059036e1), 
      SC_(-0.422729969024658203125e1), SC_(-0.5579319000244140625e1), SC_(0.902716100215911865234375e0), SC_(-0.29339747579279786325572091229475038788240508927069e1), 
      SC_(-0.422729969024658203125e1), SC_(-0.443003559112548828125e1), SC_(0.30182731151580810546875e0), SC_(-0.20332118474589978967014457229751417815334257007725e1), 
      SC_(-0.422729969024658203125e1), SC_(-0.38366591930389404296875e1), SC_(0.944787204265594482421875e0), SC_(-0.23309638234265258085236518289500875872382670635531e1), 
      SC_(-0.422729969024658203125e1), SC_(0.9376299381256103515625e0), SC_(0.47944284975528717041015625e-1), SC_(0.55127743131805946640653697589948126175960821694939e0), 
      SC_(-0.422729969024658203125e1), SC_(0.944411754608154296875e0), SC_(0.490864098072052001953125e0), SC_(0.56493782092073377291148430267312534227403657862246e0), 
      SC_(-0.422729969024658203125e1), SC_(0.264718532562255859375e1), SC_(0.24784760177135467529296875e0), SC_(0.99764875182145400934630080614259208150412409509119e0), 
      SC_(-0.422729969024658203125e1), SC_(0.62944736480712890625e1), SC_(0.489252626895904541015625e0), SC_(0.28734824786581909285845654210597622170300733533946e1), 
      SC_(-0.422729969024658203125e1), SC_(0.670017147064208984375e1), SC_(0.544056117534637451171875e0), SC_(0.32431260560094122699651897155841037329270811778132e1), 
      SC_(-0.422729969024658203125e1), SC_(0.81158390045166015625e1), SC_(0.3377194106578826904296875e0), SC_(0.3552545326446817241133924081320996120058335192491e1), 
      SC_(-0.422729969024658203125e1), SC_(0.826751708984375e1), SC_(0.887726128101348876953125e0), SC_(0.43951652637374153998422296875036327337396811436615e1), 
      SC_(-0.422729969024658203125e1), SC_(0.91501369476318359375e1), SC_(0.90005385875701904296875e0), SC_(0.48896014631866115132055935386096009319586005592127e1), 
      SC_(-0.422729969024658203125e1), SC_(0.929777050018310546875e1), SC_(0.34383952617645263671875e0), SC_(0.40767517905568657166494213191421071678457476778443e1), 
      SC_(-0.422729969024658203125e1), SC_(0.93538990020751953125e1), SC_(0.369246780872344970703125e0), SC_(0.41436207389706064482444445954737364758418812617667e1), 
      SC_(-0.422729969024658203125e1), SC_(0.93773555755615234375e1), SC_(0.332685671746730804443359375e-1), SC_(0.40756534641409571950446138635247828926930790279057e1), 
      SC_(-0.422729969024658203125e1), SC_(0.98576259613037109375e1), SC_(0.111202754080295562744140625e0), SC_(0.4485670727454841708415959087291569852354460985191e1), 
      SC_(-0.422729969024658203125e1), SC_(0.992922687530517578125e1), SC_(0.16287212073802947998046875e0), SC_(0.45334366508455232455528579705650267157785917194655e1), 
      SC_(-0.396634578704833984375e1), SC_(-0.80491924285888671875e1), SC_(0.780252039432525634765625e0), SC_(-0.40943621028986137634975703353728608171096349083644e1), 
      SC_(-0.396634578704833984375e1), SC_(-0.7460263729095458984375e1), SC_(0.8773639202117919921875e0), SC_(-0.41529939833416188958459732301077246683216449362382e1), 
      SC_(-0.396634578704833984375e1), SC_(-0.729045963287353515625e1), SC_(0.3897388279438018798828125e0), SC_(-0.3480702220830587340721759704232773754695850228748e1), 
      SC_(-0.396634578704833984375e1), SC_(-0.623236083984375e1), SC_(0.210301876068115234375e0), SC_(-0.27885209025273530237198094751157992754542254286699e1), 
      SC_(-0.396634578704833984375e1), SC_(-0.5579319000244140625e1), SC_(0.241691291332244873046875e0), SC_(-0.23574190979731764925820378430269429039999026821228e1), 
      SC_(-0.396634578704833984375e1), SC_(-0.443003559112548828125e1), SC_(0.2727530300617218017578125e0), SC_(-0.20795595903717808369226602920751548446608046498173e1), 
      SC_(-0.396634578704833984375e1), SC_(-0.38366591930389404296875e1), SC_(0.4039121568202972412109375e0), SC_(-0.19363504684946027378474342759829701188128121771172e1), 
      SC_(-0.396634578704833984375e1), SC_(0.9376299381256103515625e0), SC_(0.4924419820308685302734375e0), SC_(0.57439960450437229566178730657936055087445971602828e0), 
      SC_(-0.396634578704833984375e1), SC_(0.944411754608154296875e0), SC_(0.964545309543609619140625e-1), SC_(0.56442474196093604965583566632417577278742858368547e0), 
      SC_(-0.396634578704833984375e1), SC_(0.264718532562255859375e1), SC_(0.22341994941234588623046875e0), SC_(0.10268979775772100508568940610675973674681502356369e1), 
      SC_(-0.396634578704833984375e1), SC_(0.62944736480712890625e1), SC_(0.1319732964038848876953125e0), SC_(0.28383877275791007314386299295586348532858393601241e1), 
      SC_(-0.396634578704833984375e1), SC_(0.670017147064208984375e1), SC_(0.49030148983001708984375e0), SC_(0.32907839164490880888445582345626377534487551184709e1), 
      SC_(-0.396634578704833984375e1), SC_(0.81158390045166015625e1), SC_(0.94205057621002197265625e0), SC_(0.48362019411346784721294532477720592781436962781609e1), 
      SC_(-0.396634578704833984375e1), SC_(0.826751708984375e1), SC_(0.954943358898162841796875e0), SC_(0.50567832895539918958405915199892399369403297399246e1), 
      SC_(-0.396634578704833984375e1), SC_(0.91501369476318359375e1), SC_(0.9561345577239990234375e0), SC_(0.55399195596034391177588570332150200763269427826113e1), 
      SC_(-0.396634578704833984375e1), SC_(0.929777050018310546875e1), SC_(0.651968657970428466796875e0), SC_(0.44651151939772538632794635991507283967810574236258e1), 
      SC_(-0.396634578704833984375e1), SC_(0.93538990020751953125e1), SC_(0.575208604335784912109375e0), SC_(0.44208286802520298236946850661246282685292115127784e1), 
      SC_(-0.396634578704833984375e1), SC_(0.93773555755615234375e1), SC_(0.75750362873077392578125e0), SC_(0.47354975575487988811361588081480294631498903701242e1), 
      SC_(-0.396634578704833984375e1), SC_(0.98576259613037109375e1), SC_(0.597795434296131134033203125e-1), SC_(0.45905273890268042154281499664878219445864193449935e1), 
      SC_(-0.396634578704833984375e1), SC_(0.992922687530517578125e1), SC_(0.435245692729949951171875e0), SC_(0.47676238150782921841655206628063738779088064504765e1), 
      SC_(-0.2233159542083740234375e1), SC_(-0.80491924285888671875e1), SC_(0.23477990925312042236328125e0), SC_(-0.44748533126920831422349545820794806553371277385033e1), 
      SC_(-0.2233159542083740234375e1), SC_(-0.7460263729095458984375e1), SC_(0.552881181240081787109375e0), SC_(-0.45036034718645244567658910223019378062296243109396e1), 
      SC_(-0.2233159542083740234375e1), SC_(-0.729045963287353515625e1), SC_(0.3531585633754730224609375e0), SC_(-0.42726238657165988625899083013084234770927337383475e1), 
      SC_(-0.2233159542083740234375e1), SC_(-0.623236083984375e1), SC_(0.53152568638324737548828125e-1), SC_(-0.34453886271845466532767992962242203359531735591743e1), 
      SC_(-0.2233159542083740234375e1), SC_(-0.5579319000244140625e1), SC_(0.82119405269622802734375e0), SC_(-0.36214083786208780467420759923323534444796335095604e1), 
      SC_(-0.2233159542083740234375e1), SC_(-0.443003559112548828125e1), SC_(0.3225107491016387939453125e0), SC_(-0.25784058164296168294688388728197558401803014682815e1), 
      SC_(-0.2233159542083740234375e1), SC_(-0.38366591930389404296875e1), SC_(0.15403441153466701507568359375e-1), SC_(-0.22937304274191202625404745929401752108326363938647e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.9376299381256103515625e0), SC_(0.4049813747406005859375e0), SC_(0.66882671905380321365353696629501581726839659732368e0), 
      SC_(-0.2233159542083740234375e1), SC_(0.944411754608154296875e0), SC_(0.430237986147403717041015625e-1), SC_(0.66092945746372938652588605746346208982917240808408e0), 
      SC_(-0.2233159542083740234375e1), SC_(0.264718532562255859375e1), SC_(0.908433616161346435546875e0), SC_(0.18536900080764993605645667717175921713955588720638e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.62944736480712890625e1), SC_(0.16899003088474273681640625e0), SC_(0.35237325007404202330837864635359809500592160070051e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.670017147064208984375e1), SC_(0.80913722515106201171875e0), SC_(0.45426945752272245371383350900233494955058093762277e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.81158390045166015625e1), SC_(0.649115502834320068359375e0), SC_(0.49038329428638199567178903183066367562827357258082e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.826751708984375e1), SC_(0.25829589366912841796875e0), SC_(0.45593877951262054200620352500821353887097951116667e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.91501369476318359375e1), SC_(0.731722414493560791015625e0), SC_(0.57004523382308203815337495168340937882687351079681e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.929777050018310546875e1), SC_(0.12984652817249298095703125e0), SC_(0.51319275680071863858207399358794549369987990555794e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.93538990020751953125e1), SC_(0.64774596691131591796875e0), SC_(0.56823138039205519976075282866343588596541504718097e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.93773555755615234375e1), SC_(0.493326842784881591796875e0), SC_(0.5455958348692104517652116375856606963768856463546e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.98576259613037109375e1), SC_(0.4509237110614776611328125e0), SC_(0.58425715884572127603208314559986328209865929040183e1), 
      SC_(-0.2233159542083740234375e1), SC_(0.992922687530517578125e1), SC_(0.3785004317760467529296875e0), SC_(0.58235654495321593144993439337365609617712620177635e1), 
      SC_(0.201027393341064453125e0), SC_(-0.80491924285888671875e1), SC_(0.54700887203216552734375e0), SC_(-0.99225565272299265057474332033452451298257411758289e1), 
      SC_(0.201027393341064453125e0), SC_(-0.7460263729095458984375e1), SC_(0.71846997737884521484375e0), SC_(-0.98733924062829495855268464439174693001319340908722e1), 
      SC_(0.201027393341064453125e0), SC_(-0.729045963287353515625e1), SC_(0.29632079601287841796875e0), SC_(-0.82838310087004006715984395376110573887564954006723e1), 
      SC_(0.201027393341064453125e0), SC_(-0.623236083984375e1), SC_(0.2878049910068511962890625e0), SC_(-0.71399649768593994233565781388330571566404664291638e1), 
      SC_(0.201027393341064453125e0), SC_(-0.5579319000244140625e1), SC_(0.74469280242919921875e0), SC_(-0.7852838275875078318898768277396954817312338949233e1), 
      SC_(0.201027393341064453125e0), SC_(-0.443003559112548828125e1), SC_(0.623435556888580322265625e0), SC_(-0.55353469466832669055948998690680459923127869705195e1), 
      SC_(0.201027393341064453125e0), SC_(-0.38366591930389404296875e1), SC_(0.188955008983612060546875e0), SC_(-0.42670151795740926550616070898142650427001824200856e1), 
      SC_(0.201027393341064453125e0), SC_(0.9376299381256103515625e0), SC_(0.811873972415924072265625e0), SC_(0.10948999881609283534865564650155039154841364221285e1), 
      SC_(0.201027393341064453125e0), SC_(0.944411754608154296875e0), SC_(0.6867754459381103515625e0), SC_(0.10678437743348588891519840198915283249591294529495e1), 
      SC_(0.201027393341064453125e0), SC_(0.264718532562255859375e1), SC_(0.31250798702239990234375e0), SC_(0.31064483566488608931281755219427099993121689654282e1), 
      SC_(0.201027393341064453125e0), SC_(0.62944736480712890625e1), SC_(0.18351115286350250244140625e0), SC_(0.71043510436913445771405941909028349861445575844728e1), 
      SC_(0.201027393341064453125e0), SC_(0.670017147064208984375e1), SC_(0.3857105076313018798828125e0), SC_(0.77553041204136176774038756662263769147319302501976e1), 
      SC_(0.201027393341064453125e0), SC_(0.81158390045166015625e1), SC_(0.3684845864772796630859375e0), SC_(0.94787138653519013648251654059066285072949428515173e1), 
      SC_(0.201027393341064453125e0), SC_(0.826751708984375e1), SC_(0.3439297378063201904296875e0), SC_(0.96231456672706330197751945234594804514605578493294e1), 
      SC_(0.201027393341064453125e0), SC_(0.91501369476318359375e1), SC_(0.62561857700347900390625e0), SC_(0.11697431340770649519046006010297689812160093617617e2), 
      SC_(0.201027393341064453125e0), SC_(0.929777050018310546875e1), SC_(0.81576907634735107421875e0), SC_(0.13689559632918850897185479014035065907489555706468e2), 
      SC_(0.201027393341064453125e0), SC_(0.93538990020751953125e1), SC_(0.7802274227142333984375e0), SC_(0.13252477031585661466687278470237361058228506710271e2), 
      SC_(0.201027393341064453125e0), SC_(0.93773555755615234375e1), SC_(0.669285118579864501953125e0), SC_(0.12219207125307825999387228477920190151422215626939e2), 
      SC_(0.201027393341064453125e0), SC_(0.98576259613037109375e1), SC_(0.811257660388946533203125e-1), SC_(0.11000670184663049479533855890007560504469595099336e2), 
      SC_(0.201027393341064453125e0), SC_(0.992922687530517578125e1), SC_(0.379418849945068359375e0), SC_(0.11497477476964669120779679338120232828710984170976e2)
   };
#undef SC_

