/**
   File : qxsldbgdoc.h
   Author : Keith Isdale
   Date : 19th April 2002
   Description : The document to handle source and breakpoints
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ************************************************************************* */


#ifndef QXSLDBGDOC_H
#define QXSLDBGDOC_H

#include <kio/job.h>
#include <QString>
#include <QPointer>
#include <ktexteditor/document.h>
#include <ktexteditor/view.h>

class QXsldbgDoc : public QObject {

Q_OBJECT

 public:
  explicit QXsldbgDoc(QWidget *parent=0, KUrl url=KUrl());
  ~QXsldbgDoc();

  void enableBreakPoint(uint lineNumber, bool state);
  void addBreakPoint(uint lineNumber);
  void deleteBreakPoint(uint lineNumber);
  void selectBreakPoint(uint lineNumberbool);
  bool isSelected(uint lineNumberbool);
  void close();

  KUrl url() const;
  KTextEditor::Document *kateDoc() {return kDoc;};
  KTextEditor::View *kateView();
 

  bool isLocked() {return locked;};
  void refresh();

signals:
    void docChanged();

private slots:
    void slotResult( KJob *job );
    void lockDoc();
    void unlockDoc();

 private:
  QPointer<KTextEditor::Document> kDoc;
  bool locked;
};

#endif
