/*
 * Copyright (C) 2003 the xine-project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: actions.c,v 1.23 2003/03/14 20:46:59 guenter Exp $
 *
 */

#include <config.h>

#include <stdio.h>

#include "globals.h"
#include "actions.h"

static se_t *engine;

static void print_cb (void *user_data, char *str) {

  if (verbosity)
    printf ("actions: < %s\n", str);

}

void action_exec (char *cmd, se_print_cb_t cb, void *cb_data) {

  int  num;
  char *str;

  if (verbosity)
    printf ("action: > executing '%s'...\n", cmd);

  if (!cb) {
    cb = print_cb;
    cb_data = NULL;
  }

  se_eval (engine, cmd, cb, cb_data);

  if ( (str = se_result_str (engine)) ) {
    cb (cb_data, "result: ");
    cb (cb_data, str);
  }

  if ( se_result_num (engine, &num) ) {

    char str[256];

    snprintf (str, 256, "result: %d", num);
    cb (cb_data, str);
  }
}

int action_eval_view (char *cmd, se_view_cb_t cb, void *cb_data) {

  int  num;

  if (verbosity)
    printf ("action: > executing '%s'...\n", cmd);

  se_eval_view (engine, cmd, cb, cb_data);

  if ( se_result_num (engine, &num) ) 
    return num;
  
  printf ("actions: eval_view: error: no numerical result from '%s'\n",
	  cmd);

  return 0;
}

void action_init () {

  engine = se_new ();

}

