
#include "bugdetailsjob.h"
#include "bug.h"
#include "bugdetails.h"
#include "bugdetailsimpl.h"
#include "packageimpl.h"
#include "bugserver.h"
#include "domprocessor.h"

#include <kdebug.h>
#include <assert.h>

#include <qdom.h>

BugDetailsJob::BugDetailsJob( BugServer *server )
  : XmlBugJob( server )
{
}

BugDetailsJob::~BugDetailsJob()
{
}

void BugDetailsJob::start( const Bug &bug )
{
    m_bug = bug;

    KURL bugUrl = server()->bugDetailsUrl( bug );

    kdDebug() << "BugDetailsJob::start(): " << bugUrl.url() << endl;
    XmlBugJob::start( bugUrl );
}

void BugDetailsJob::process( const QByteArray &data )
{
    QDomDocument doc;
    if ( !doc.setContent( data ) ) {
      kdDebug() << "Error parsing xml response for bug " << m_bug.number()
                << "." << endl;
      return;
    }
    
    QDomElement bugzilla = doc.documentElement();

    if ( bugzilla.isNull() ) {
      kdDebug() << "No document in xml response." << endl;
      return;
    }
    
    QDomNode p;
    for ( p = bugzilla.firstChild(); !p.isNull(); p = p.nextSibling() ) {
        QDomElement bug = p.toElement();
        if ( bug.tagName() != "bug" ) continue;

        BugDetails bugDetails = dom()->parseBugDetails( bug );

        if ( !bugDetails.isNull() ) {
            emit bugDetailsAvailable( m_bug, bugDetails );
        }
    }
}

#include "bugdetailsjob.moc"

/*
 * vim:sw=4:ts=4:et
 */
