/***************************************************************************
                           datawidget.h  -  description
                             -------------------
    begin                : Tue Feb 12 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#ifndef DATAWIDGET_H
#define DATAWIDGET_H

#include <klistview.h>
#include <klineedit.h>

#include <qwidget.h>

#include "card.h"

class DataWidget : public QWidget
{
  Q_OBJECT
public: 
  DataWidget(QWidget *parent = 0, const char *name = 0);
  ~DataWidget();

  CardList cardList() const;
  void clear();
  void loadCards(const CardList &cards);
  void cut();
  void copy();
  bool hasSelectedText() const;

private:
  void setupLayout();
  virtual bool eventFilter(QObject *object, QEvent *event);
  
  KListView *cardListView;
  KLineEdit *frontBox, *backBox;
  
private slots:
  void changeSelection(QListViewItem *);
  void addCard();
  void deleteCard();
  void updateCard();

signals:
  void dataChanged();
  void selectionChanged();
  void lineEditFocusIn(KLineEdit *);
  void lineEditFocusOut();
};

#endif
