/***************************************************************************
                            KAuthIcon.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KAUTHICON_H
#define KAUTHICON_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 This is the base class from which different authorization icon widget
 which actually do something should be derived.  You can use these
 widgets to show that the user has (or doesn't have) the ability to do
 something, and why that is.

 One of the most useful things you can do with this is connect
 @ref authChanged(bool) to @ref setEnabled(bool) for a widget to turn it on and
 off depending on the status of whatever it is you are monitoring.

 @author Preston Brown <pbrown@kde.org>
 
 @short ABC for authorization icon widgets.
*/
@interface KAuthIcon : QWidget 
- (void) dealloc;
- (QSize*) sizeHint;

/** 
 return the status of whatever is being monitored.
   
*/
- (BOOL) status;

/** 
 Re-implement this method if you want the icon to update itself
 when something external has changed (i.e. a file on disk, uid/gid).
   
*/
- updateStatus;
@end

/** Override these methods in subclasses of KAuthIcon to customise event handling behaviour */
@protocol KAuthIconEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
