#ifndef _MAINWIDGET_H_
#define _MAINWIDGET_H_ 1
#include <qwidget.h>
#include <qlistbox.h>
#include <qtabwidget.h>
#include <qevent.h>
#include "general.h"
#include "images.h"
#include "expert.h"

class MainWidget: public QTabWidget {
	Q_OBJECT
public:
	MainWidget(QWidget *parent, const char *name=0);
	void arrangeWidgets();
    void makeReadOnly();
public slots:
	void load();
	void save();
	void reset();
	void defaults();
	void tabChanged(const QString &lbl);
signals:
	void configChanged();
private:
	QString previous;
	General *general;
	Images	*images;
	Expert	*expert;
	liloconf *l;
};
#endif
