Name: sgml-common
Version: 0.5
Release: 7
Group: Applications/Text

Summary: Common SGML catalog and DTD files.

License: GPL
URL: http://www.iso.ch/cate/3524030.html

Requires: sh-utils fileutils textutils grep

BuildRoot: %{_tmppath}/%{name}-%{version}

BuildArch: noarch
Source0: %{name}-%{version}.tgz
Source1: sgml-common-CHANGES
Patch0: sgml-common-oldsyntax.patch
Patch1: sgml-common-quiet.patch
Patch2: sgml-common-umask.patch


%description
The sgml-common package contains a collection of entities and DTDs
that are useful for processing SGML, but that don't need to be
included in multiple packages.  Sgml-common also includes an
up-to-date Open Catalog file.


%prep
%setup -q
%patch0 -p1 -b .oldsyntax
%patch1 -p1 -b .quiet
%patch2 -p1 -b .umask

%build


%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/share/sgml/sgml-iso-entities-8879.1986
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/etc/sgml
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man8
install -m 0644 *.dcl $RPM_BUILD_ROOT/usr/share/sgml
install -m 0644 iso-entities/*.ent $RPM_BUILD_ROOT/usr/share/sgml/sgml-iso-entities-8879.1986
install -m 0644 iso-entities/catalog $RPM_BUILD_ROOT/usr/share/sgml/sgml-iso-entities-8879.1986
install -m 0755 bin/* $RPM_BUILD_ROOT/usr/bin/
install -m 0644 config/* $RPM_BUILD_ROOT/etc/sgml/
install -m 0644 doc/man/*.8 $RPM_BUILD_ROOT/%{_mandir}/man8/
cp %{SOURCE1} CHANGES


%clean
DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR


%files
%defattr (-,root,root)
%doc doc/HTML/ CHANGES
%config /etc/sgml/sgml.conf
/usr/share/sgml/xml.dcl
/usr/share/sgml/sgml-iso-entities-8879.1986/*
/usr/bin/sgmlwhich
/usr/bin/install-catalog
%{_mandir}/*/*

%changelog
* Wed May 23 2001 Tim Waugh <twaugh@redhat.com> 0.5-7
- Remove execute bit from data files.

* Mon May 21 2001 Tim Waugh <twaugh@redhat.com> 0.5-6
- install-catalog needs to make sure that it creates world-readable files
  (bug #41552).

* Wed Mar 14 2001 Tim Powers <timp@redhat.com> 0.5-5
- fixed license

* Wed Jan 24 2001 Tim Waugh <twaugh@redhat.com>
- Make install-catalog quieter during normal operation.

* Tue Jan 23 2001 Tim Waugh <twaugh@redhat.com>
- Require textutils, fileutils, grep (bug #24719).

* Wed Jan 17 2001 Tim Waugh <twaugh@redhat.com>
- Require sh-utils.

* Mon Jan 15 2001 Tim Waugh <twaugh@redhat.com>
- Don't play so many macro games.
- Fix typo in install-catalog patch.

* Mon Jan 08 2001 Tim Waugh <twaugh@redhat.com>
- Change group.
- Install by hand (man/en/...).  Use %%{_mandir}.
- Use %%{_tmppath}.
- Make install-catalog fail silently if given the old syntax.
- Add CHANGES file.
- Change Copyright: to License:.
- Remove Packager: line.

* Mon Jan 08 2001 Tim Waugh <twaugh@redhat.com>
- Based on Eric Bischoff's new-trials packages.
