/*
  Methods to Reduce the Number of Unique Colors in an Image.
*/
#ifndef _MAGICK_QUANTIZE_H
#define _MAGICK_QUANTIZE_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/*
  Define declarations.
*/
#define MaxTreeDepth  8
#define NodesInAList  1536

extern MagickExport DoublePixelPacket
  GetImageDynamicThreshold(const Image *,const double,const double,
    ExceptionInfo *);

extern MagickExport QuantizeInfo
  *CloneQuantizeInfo(const QuantizeInfo *);

extern MagickExport unsigned int
  GetImageQuantizeError(Image *),
  MapImage(Image *,const Image *,const unsigned int),
  MapImages(Image *,const Image *,const unsigned int),
  OrderedDitherImage(Image *),
  QuantizeImage(const QuantizeInfo *,Image *),
  QuantizeImages(const QuantizeInfo *,Image *),
  SegmentImage(Image *,const ColorspaceType,const unsigned int,const double,
    const double);

extern MagickExport void
  CompressImageColormap(Image *),
  DestroyQuantizeInfo(QuantizeInfo *),
  GetQuantizeInfo(QuantizeInfo *);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
