/***************************************************************************
                            KSystemTray.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSYSTEMTRAY_H
#define KSYSTEMTRAY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QLabel.h>

/**

  KDE System Tray Window class

 This class implements system tray windows.

 A tray window is a small window (typically 24x24 pixel) that docks
 into the system tray in the desktop panel. It usually displays an
 icon or an animated icon there. The icon serves as representative
 for the application, similar to a taskbar button, but consumes less
 screen space.

 When the user clicks with the left mouse button on the icon, the
 main application window is shown/raised and activated. With the
 right mouse button, she gets a popupmenu with application specific
 commands, including "Minimize/Restore" and "Quit".

 Docking happens magically when calling -show. The window undocks
 with either -hide or when it is destroyed.

 KSystemTray inherits methods such as @ref -setPixmap and @ref -setMovie to
 specify an icon or movie (animated icon) respectively. It is
 designed to be usable "as is", without the need to subclass it. In
 case you need to provide something special (such as an additional
 popupmenu on a click with the left mouse button), you can subclass
 anyway, of course.

 Having an icon on the system tray is a useful technique for
 daemon-like applications that may run for some time without user
 interaction but have to be there immediately when the user needs
 them. Examples are kppp, kisdn, kscd, kmix or knotes. With kppp and
 kisdn, the docked icon even provides real-time information about
 the network status.

 @author Matthias Ettrich <ettrich@kde.org>

 @short KDE System Tray Window class.
*/
@class KPopupMenu; 

@interface KSystemTray : QLabel 

/** 
 Construct a KSystemTray widget just like any other widget.

 The parent widget @p parent has a special meaning:
 Besides owning the tray window, the parent widget will
 dissappear from taskbars when it is iconified while the tray
 window is visible. This is the desired behaviour. After all,
 the tray window @p is the parent's taskbar icon.

 Furthermore, the parent widget is shown or raised respectively
 when the user clicks on the trray window with the left mouse
 button.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;
- (void) dealloc;

/** 
       Access to the context menu. This makes it easy to add new items
       to it.
     
*/
- (KPopupMenu*) contextMenu;

/** 
       Makes it easy to adjust some menu items right before the
       context menu becomes visible.
     
*/
- contextMenuAboutToShow: (KPopupMenu*)menu;
@end

/** Override these methods in subclasses of KSystemTray to customise event handling behaviour */
@protocol KSystemTrayEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;

/** 
       Reimplemented for internal reasons.
     
*/
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;

/** 
       Reimplemented to provide the standard show/raise behaviour
       for the -parentWidget and the context menu.

       Feel free to reimplement this if you need something special.
     
*/
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;

/** 
       Reimplemented to provide the standard show/raise behaviour
       for the -parentWidget and the context menu.

       Feel free to reimplement this if you need something special.
     
*/
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;

/** 
       Reimplemented for internal reasons.
     
*/
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
