/***************************************************************************
                            kde_PartManager.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_PARTMANAGER
#define KDE_PARTMANAGER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The part manager is an object which knows about a collection of parts
 (even nested ones) and handles activation/deactivation.

 Applications that want to embed parts without merging GUIs
 only use a KParts::PartManager. Those who want to merge GUIs use a
 @ref KParts::MainWindow for example, in addition to a part manager.

 Parts know about the part manager to add nested parts to it.
 See also @ref KParts::Part::manager() and @ref KParts::Part::setManager().
 
 @short *
 The part manager is an object which knows about a collection of parts
 (even nested ones) and handles activation/deactivation.
*/
#define PARTMANAGER_Direct	0
#define PARTMANAGER_TriState	1

/** *
 Constructs a part manager.

*/
kde_PartManager * kde_new_PartManager(qt_QWidget * parent, char* name);

/** *
 Constructs a part manager.

*/
kde_PartManager * kde_new_PartManager1(qt_QWidget * topLevel, qt_QObject * parent, char* name);
void kde_del_PartManager( kde_PartManager* p );

/** *
 Sets the selection policy of the partmanager.
   
*/
void kde_PartManager_setSelectionPolicy(kde_PartManager* instPointer,int policy);

/** *
 Returns the current selection policy.
   
*/
int kde_PartManager_selectionPolicy(kde_PartManager* instPointer);

/** *
 Specifies whether the partmanager should handle/allow nested parts
 or not.

  This is a property the shell has to set/specify. Per
 default we assume that the shell cannot handle nested
 parts. However in case of a KOffice shell for example we allow
 nested parts.  A Part is nested (a child part) if its parent
 object inherits @ref KParts::Part.  If a child part is activated and
 nested parts are not allowed/handled, then the top parent part in
 the tree is activated.
   
*/
void kde_PartManager_setAllowNestedParts(kde_PartManager* instPointer,int allow);

/** *

*/
int kde_PartManager_allowNestedParts(kde_PartManager* instPointer);

/** *
 Specifies whether the partmanager should ignore mouse click events for
 scrollbars or not. If the partmanager ignores them, then clicking on the
 scrollbars of a non-active/non-selected part will not change the selection
 or activation state.

 The default value is false (read: scrollbars are NOT ignored).
   
*/
void kde_PartManager_setIgnoreScrollBars(kde_PartManager* instPointer,int ignore);

/** *

*/
int kde_PartManager_ignoreScrollBars(kde_PartManager* instPointer);

/** *
 Specifies which mouse buttons the partmanager should react upon.
 By default it reacts on all mouse buttons (LMB/MMB/RMB).

*/
void kde_PartManager_setActivationButtonMask(kde_PartManager* instPointer,short int buttonMask);

/** *

*/
short int kde_PartManager_activationButtonMask(kde_PartManager* instPointer);

/** *

   
*/
int kde_PartManager_eventFilter(kde_PartManager* instPointer,qt_QObject * obj, qt_QEvent * ev);

/** *
 Adds a part to the manager.

 Sets it to the active part automatically if @p setActive is true (default ).
   
*/
void kde_PartManager_addPart(kde_PartManager* instPointer,kde_Part* part, int setActive);

/** *
 Removes a part from the manager (this does not delete the object) .

 Sets the active part to 0 if @p part is the @ref activePart() .
   
*/
void kde_PartManager_removePart(kde_PartManager* instPointer,kde_Part* part);

/** *
 Replaces @p oldPart with @p newPart, and sets @p newPart as active if
 @p setActive is true.
 This is an optimised version of @ref removePart + @ref addPart
   
*/
void kde_PartManager_replacePart(kde_PartManager* instPointer,kde_Part* oldPart, kde_Part* newPart, int setActive);

/** *
 Sets the active part.

 The active part receives activation events.

 @p widget can be used to specify which widget was responsible for the activation.
 This is important if you have multiple views for a document/part , like in KOffice .
   
*/
void kde_PartManager_setActivePart(kde_PartManager* instPointer,kde_Part* part, qt_QWidget * widget);

/** *
 Returns the active part.

*/
kde_Part* kde_PartManager_activePart(kde_PartManager* instPointer);

/** *
 Returns the active widget of the current active part (see @ref activePart ).
   
*/
qt_QWidget * kde_PartManager_activeWidget(kde_PartManager* instPointer);

/** *
 Sets the selected part.

 The selected part receives selection events.

 @p widget can be used to specify which widget was responsible for the selection.
 This is important if you have multiple views for a document/part , like in KOffice .
   
*/
void kde_PartManager_setSelectedPart(kde_PartManager* instPointer,kde_Part* part, qt_QWidget * widget);

/** *
 Returns the current selected part.
   
*/
kde_Part* kde_PartManager_selectedPart(kde_PartManager* instPointer);

/** *
 Returns the selected widget of the current selected part (see @ref selectedPart ).
   
*/
qt_QWidget * kde_PartManager_selectedWidget(kde_PartManager* instPointer);

/** *
 Adds the @p topLevel widget to the list of managed toplevel widgets.
 Usually a PartManager only listens for events (for activation/selection)
 for one toplevel widget (and its children) , the one specified in the
 constructor. Sometimes however (like for example when using the KDE dockwidget
 library) , it is necessary to extend this.
   
*/
void kde_PartManager_addManagedTopLevelWidget(kde_PartManager* instPointer,qt_QWidget * topLevel);

/** *
 Removes the @p topLevel widget from the list of managed toplevel widgets.

*/
void kde_PartManager_removeManagedTopLevelWidget(kde_PartManager* instPointer,qt_QWidget * topLevel);

/** *
 Changes the active instance when the active part changes.
 The active instance is used by KBugReport and KAboutDialog.
 Override if you really need to - usually you don't need to.
   
*/
void kde_PartManager_setActiveInstance(kde_PartManager* instPointer,kde_KInstance* instance);
void kde_PartManager_virtual_hook(kde_PartManager* instPointer,int identifier, void* data);

/** *
 Removes a part when it is destroyed.

*/
void kde_PartManager_slotObjectDestroyed(kde_PartManager* instPointer);

/** *

   
*/
void kde_PartManager_slotWidgetDestroyed(kde_PartManager* instPointer);

/** *

   
*/
void kde_PartManager_slotManagedTopLevelWidgetDestroyed(kde_PartManager* instPointer);

#endif
