/***************************************************************************
                          mediacontrolconfig.cpp  -  description
                             -------------------
    begin                : forgot :/
    copyright            : (C) 2000-2002 by Stefan Gehn
    email                : sgehn@gmx.net
    
    code-skeleton taken from knewsticker which is
    Copyright (c) Frerich Raabe <raabe@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "mediacontrolconfig.h"
#include "mediacontrolconfig.moc"
#include "mediacontrolconfigwidget.h"

#include <dcopclient.h>
#include <qdir.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qgroupbox.h>

#include <kapp.h>
#include <kdebug.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klistbox.h>
#include <klocale.h>
#include <knuminput.h>
#include <kstandarddirs.h>

MediaControlConfig::MediaControlConfig( ConfigFrontend *cfg, QWidget *parent, const char* name)
: KDialogBase( parent, name, /*modal = */false, QString::null, Ok | Apply | Cancel, Ok, false )
{
/*	if (!kapp->dcopClient()->isAttached())
		kapp->dcopClient()->attach();
*/
//	kdDebug() << "MediaControlConfig::MediaControlConfig()" << endl;
	_configFrontend = cfg;
	if ( !_configFrontend ) // emergency!!!
		return;

//	QVBoxLayout *top = new QVBoxLayout(this);

	setCaption( i18n("MediaControl") );

//	_configFrontend = new ConfigFrontend(new KConfig("mediacontrol_panelappletrc", false, false));
	_child = new MediaControlConfigWidget(this);
	setMainWidget ( _child );
//	top->addWidget(_child);

#ifdef HAVE_XMMS
	_child->playerListBox->insertItem ( "XMMS", -1 );
#endif
	_child->playerListBox->insertItem ( "Noatun", -1 );


	_child->themeListBox->clear();
	// fill with available skins
	KGlobal::dirs()->addResourceType("themes", KStandardDirs::kde_default("data") + "mediacontrol");
	QStringList list = KGlobal::dirs()->resourceDirs("themes");
    for (QStringList::ConstIterator it = list.begin(); it != list.end(); it++)
        readSkinDir(*it);

	connect(_child->mWheelScrollAmount, SIGNAL(valueChanged(int)), SLOT(slotConfigChanged()));
	connect(_child->playerListBox, SIGNAL(selectionChanged()), SLOT(slotConfigChanged()));
	connect(_child->themeListBox, SIGNAL(selectionChanged()), SLOT(slotConfigChanged()));
	connect(_child->themeListBox, SIGNAL(selectionChanged(QListBoxItem *)), SLOT(slotChangePreview(QListBoxItem *)));
	connect(_child->mUseThemes, SIGNAL(toggled(bool)), SLOT(slotConfigChanged()) );
	connect(_child->mUseThemes, SIGNAL(toggled(bool)), SLOT(slotUseThemesToggled(bool)) );
/*
	connect( this, SIGNAL(cancelClicked()), this, SLOT(slotCancelClicked()) );
	connect( this, SIGNAL(applyClicked()), this, SLOT(slotApplyClicked()) );
	connect( this, SIGNAL(okClicked()), this, SLOT(slotOkClicked()) );
*/

	load();
	show();

	enableButtonApply ( false ); // apply id disabled until something changed
}

void MediaControlConfig::readSkinDir( const QString &dir )
{
//	kdDebug() << "MediaControlConfig::readSkinDir " << dir << endl;

	QDir directory( dir );
	if (!directory.exists())
		return;

	const QFileInfoList *list = directory.entryInfoList();
	QFileInfoListIterator it(*list);

	while ( it.current() )
	{
		if ( QFile(it.current()->absFilePath()+"/play.png").exists() )
		{	// append directory-name to our theme-listbox
//		    kdDebug() << "got skindir: " << it.current()->absFilePath() << endl;
			_child->themeListBox->insertItem ( it.current()->baseName(), -1 );
		}
		++it;
	}
}


// ============================================================================


void MediaControlConfig::load()
{
	// find the playerstring from config in the playerlist and select it if found
	QListBoxItem *item = 0;

	item = _child->playerListBox->findItem(  _configFrontend->player() );
	if ( item )
		_child->playerListBox->setCurrentItem ( item );
	else
		_child->playerListBox->setCurrentItem( 0 );

	// reset item to a proper state
	item=0;

	_child->mWheelScrollAmount->setValue( _configFrontend->mouseWheelSpeed() );

	// Select the used Theme
	item = _child->themeListBox->findItem(  _configFrontend->theme() );
	if ( item )
		_child->themeListBox->setCurrentItem( item );
	else
		_child->themeListBox->setCurrentItem( 0 );
		

	bool ison = _configFrontend->useCustomTheme();
	_child->mUseThemes->setChecked( ison );
	slotUseThemesToggled( ison );

//	emit changed(false);
}

void MediaControlConfig::save()
{
//	kdDebug() << "MediaControlConfig::save()" << endl;
	for ( int it=0 ; it <= _child->playerListBox->numRows(); it++ )
		if ( _child->playerListBox->isSelected(it) )
		{
			_configFrontend->setPlayer ( _child->playerListBox->text(it) );
		}

	_configFrontend->setMouseWheelSpeed ( _child->mWheelScrollAmount->value() );

	for ( int it=0 ; it <= _child->themeListBox->numRows(); it++ )
		if ( _child->themeListBox->isSelected(it) )
		{
			_configFrontend->setTheme ( _child->themeListBox->text(it) );
		}

	_configFrontend->setUseCustomTheme( _child->mUseThemes->isChecked() );

/*	QByteArray data;
	kapp->dcopClient()->send("mediacontrol", "MediaControl", "reparseConfig()", data);
*/
	emit configChanged();
}
/*
void MediaControlConfig::defaults()
{
	ConfigFrontend cfDefaults;
	QListBoxItem *item = 0;

	// search if playername stored in config can be found in the list of supported players
	item = _child->playerListBox->findItem( cfDefaults.player() );
	if ( item )
		_child->playerListBox->setCurrentItem ( item );
	else
		_child->playerListBox->setCurrentItem( 0 );

	_child->mWheelScrollAmount->setValue ( cfDefaults.mouseWheelSpeed() );

	item = 0;
	item = _child->themeListBox->findItem( cfDefaults.theme() );
	if ( item )
		_child->themeListBox->setCurrentItem( item );
	else
		_child->themeListBox->setCurrentItem( 0 );
	
	_configFrontend->setUseCustomTheme ( cfDefaults.useCustomTheme() );

	emit changed(true);
}

QString MediaControlConfig::quickHelp() const
{
	return i18n("<h1>MediaControl</h1> This module allows you to configure the"
		" MediaControl applet for KDE's panel." );
}
*/

void MediaControlConfig::slotApply( void )
{
//	kdDebug() << "MediaControlConfig::slotApply()" << endl;
	save();
	enableButtonApply ( false );
}

void MediaControlConfig::slotOk( void )
{
//	kdDebug() << "MediaControlConfig::slotOk()" << endl;
	save();
	emit closing();
}

void MediaControlConfig::slotCancel( void )
{
//	kdDebug() << "MediaControlConfig::slotCancel()" << endl;
	emit closing();
}


void MediaControlConfig::slotConfigChanged()
{
//	emit changed(true);
	enableButtonApply ( true );
}

void MediaControlConfig::slotChangePreview( QListBoxItem *item )
{
// kdDebug() << "new preview" << endl;
	_child->previewPrev->setPixmap ( QPixmap( locate("themes",item->text()+"/prev.png") ) );
	_child->previewPlay->setPixmap ( QPixmap(locate("themes",item->text()+"/play.png")) );
	_child->previewPause->setPixmap ( QPixmap(locate("themes",item->text()+"/pause.png")) );
	_child->previewStop->setPixmap ( QPixmap(locate("themes",item->text()+"/stop.png")) );
	_child->previewNext->setPixmap ( QPixmap(locate("themes",item->text()+"/next.png")) );
}

void MediaControlConfig::slotUseThemesToggled( bool on )
{
	_child->themeListBox->setEnabled(on);
	_child->previewGroupBox->setEnabled(on);
}
