//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMFINISHEDIT_H
#define PMFINISHEDIT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmtexturebaseedit.h"

class PMFinish;
class PMFloatEdit;
class PMColorEdit;
class QCheckBox;
class QLabel;

/**
 * Dialog edit class for @ref PMFinish
 */
class PMFinishEdit : public PMTextureBaseEdit
{
   Q_OBJECT
   typedef PMTextureBaseEdit Base;
public:
   /** Creates a PMFinishEdit with parent and name */
   PMFinishEdit( QWidget* parent, const char* name = 0 );

   /** */
   virtual void displayObject( PMObject* o );

   /** */
   virtual bool isDataValid( );
protected:
   /** */
   virtual void createTopWidgets( );
   /** */
   virtual void saveContents( );

protected slots:
   void slotIridClicked( );
   void slotAmbientClicked( );
   void slotPhongClicked( );
   void slotPhongSizeClicked( );
   void slotBrillianceClicked( );
   void slotDiffuseClicked( );
   void slotMetallicClicked( );
   void slotCrandClicked( );
   void slotSpecularClicked( );
   void slotRoughnessClicked( );
   void slotReflectionClicked( );
   void slotExponentClicked( );

private:
   PMFinish* m_pDisplayedObject;
   PMColorEdit* m_pAmbientColorEdit;
   QLabel* m_pAmbientColorLabel;
   PMFloatEdit* m_pDiffuseEdit;
   PMFloatEdit* m_pBrillianceEdit;
   PMFloatEdit* m_pCrandEdit;
   PMFloatEdit* m_pPhongEdit;
   PMFloatEdit* m_pPhongSizeEdit;
   PMFloatEdit* m_pMetallicEdit;
   PMFloatEdit* m_pSpecularEdit;
   PMFloatEdit* m_pRoughnessEdit;
   PMColorEdit* m_pReflectionColorEdit; 
   PMFloatEdit* m_pReflectionExponentEdit;
   QCheckBox* m_pIridEdit;
   PMFloatEdit* m_pIridAmountEdit;
   PMFloatEdit* m_pIridThicknessEdit;
   PMFloatEdit* m_pIridTurbulenceEdit;
   QLabel* m_pIridAmountLabel;
   QLabel* m_pIridThicknessLabel;
   QLabel* m_pIridTurbulenceLabel;
   QLabel* m_pReflectionColorLabel; 
   QCheckBox* m_pEnableAmbientEdit;
   QCheckBox* m_pEnablePhongEdit;
   QCheckBox* m_pEnablePhongSizeEdit;
   QCheckBox* m_pEnableDiffuseEdit;
   QCheckBox* m_pEnableBrillianceEdit;
   QCheckBox* m_pEnableCrandEdit;
   QCheckBox* m_pEnableSpecularEdit;
   QCheckBox* m_pEnableRoughnessEdit;
   QCheckBox* m_pEnableMetallicEdit;
   QCheckBox* m_pEnableReflectionEdit;
   QCheckBox* m_pEnableExponentEdit;
};


#endif
