/*
    kiconedit - a small graphics drawing program for creating KDE icons
    Copyright (C) 1998  Thomas Tanghus (tanghus@kde.org)

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/  

#ifndef __KICONEDIT_H__
#define __KICONEDIT_H__

#include <qdir.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qfileinfo.h> 
#include <qptrlist.h>
#include <qkeycode.h>
#include <qtimer.h>

#include <kapplication.h>
#include <kmainwindow.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <ktoolbar.h>
#include <kaccel.h>
#include <kurl.h>

#include "knew.h"
#include "kicon.h"
#include "kiconconfig.h"
#include "kicongrid.h"
#include "kresize.h"
#include "properties.h"

class KIconEdit;
typedef QPtrList<KIconEdit> WindowList;

#define ID_VIEW_ZOOM_IN      520
#define ID_VIEW_ZOOM_OUT     521
#define ID_VIEW_ZOOM_1TO1    522
#define ID_VIEW_ZOOM_1TO5    523
#define ID_VIEW_ZOOM_1TO10   524

#define ID_OPTIONS_TOGGLE_GRID  560
#define ID_OPTIONS_TOGGLE_TOOL1 561
#define ID_OPTIONS_TOGGLE_TOOL2 562
#define ID_OPTIONS_TOGGLE_STATS 563
#define ID_OPTIONS_SAVE         565

#define ID_EDIT_PASTE_AS_NEW 513

#define ID_CUSTOM_COLORS        600
#define ID_SYSTEM_COLORS        601
#define ID_PREVIEW              602


class QWhatsThis;
class QToolButton;
class QLabel;
class KSysColors;
class KCustomColors;

/**
* KIconEdit
* @short KIconEdit
* @author Thomas Tanghus <tanghus@kde.org>
* @version 0.4
*/
class KIconEdit : public KMainWindow
{
    Q_OBJECT
public:
  KIconEdit( const QString &xpm = QString::null, const char *name = "kiconedit");
  KIconEdit( const QImage image, const char *name = "kiconedit");
  ~KIconEdit();

  virtual QSize sizeHint() const;
  static WindowList windowList;

signals:

public slots:
  virtual void saveProperties(KConfig*);
  virtual void readProperties(KConfig*);
  void updateProperties();

protected slots:
  void addColors(uint, uint*);
  void addColor(uint);
  void slotNewWin(const QString & url = 0);
  void slotNew();
  void slotOpen();
  void slotClose();
  void slotSave();
  void slotSaveAs();
  void slotPrint();
  void slotView(int);
  void slotZoomIn();
  void slotZoomOut();
  void slotCopy();
  void slotCut();
  void slotPaste();
  void slotClear();
  void slotSaved();
  void slotSelectAll();
  //void slotOpenRecent(int id);
  void slotOpenRecent(const KURL&);
  void slotToolPointer();
  void slotToolFreehand();
  void slotToolRectangle();
  void slotToolFilledRectangle();
  void slotToolCircle();
  void slotToolFilledCircle();
  void slotToolEllipse();
  void slotToolFilledEllipse();
  void slotToolSpray();
  void slotToolFlood();
  void slotToolLine();
  void slotToolEraser();
  void slotToolSelectRect();
  void slotToolSelectCircle();
  void slotConfigureSettings();
  void slotConfigureKeys();
  void slotConfigure(int);

  void slotUpdateStatusColors(uint);
  void slotUpdateStatusColors(uint, uint*);
  void slotUpdateStatusPos(int, int);
  void slotUpdateStatusSize(int, int);
  void slotClearStatusMessage();
  void slotUpdateStatusMessage(const QString &);
  void slotUpdateStatusName(const QString &);
  void slotUpdateStatusScaling(int, bool);
  void slotUpdatePaste(bool);
  void slotUpdateCopy(bool);
  void slotOpenBlank(const QSize);
  void addRecent(const QString &);

  virtual void dragEnterEvent(QDragEnterEvent* event);
  virtual void dropEvent(QDropEvent *e);

protected:
  void init();
  bool setupMenuBar();
  void setupTools();
  bool setupToolBar();
  bool setupDrawToolBar();
  bool setupPaletteToolBar();
  bool setupStatusBar();
  bool setupWhatsThis();
  virtual bool queryClose();
  virtual void resizeEvent(QResizeEvent*);
  void writeConfig();

  void updateAccels();

  QLabel *syslabel, *customlabel;
  QLabel *preview;
  KSysColors *syscolors;
  KCustomColors *customcolors;

  KMenuBar *menubar;
  KToolBar *toolbar, *drawtoolbar, *palettetoolbar;
  KStatusBar *statusbar;
  QPopupMenu *edit, *file, *view, *help;
  QPopupMenu *tools, *options, *zoom, /*recent,*/ *select;
  KIconEditGrid *grid;
  QTimer *msgtimer;
  KGridView *gridview;
  KIconEditIcon *icon;
  QImage img;
  
  KAction* actPrint, *actCopy, *actPaste, *actCut;
};

#endif //__KICONEDIT_H__
