/***************************************************************************
                          kgeoMenuToolbarSlots.cpp  -  description
                             -------------------
    begin                : Sun Oct 8 2000
    copyright            : (C) 2000 by Marc Bartsch
    email                : marc.bartsch@topmail.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kgeo.h"

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////
void KGeoApp::toolBar2Clicked( int x )
{
	if ( newObject != 0 )
	{
		delete newObject;
	}
 	newObject = 0;
	disconnectAll();
	deselectParamObjects();
	currentButtonID = x;

	switch ( x )
	{
		case ID_buttonPointer:
			startMoveMode();
			break;
		case ID_buttonMoveGrid:
			drawingMode = ID_drawingModeMovingGrid;
			canvas->setCursor( sizeAllCursor );
	  	statusBar()->changeItem( " " + i18n( "Move the underlying grid." ), 1 );
			startMoveGridMode();
			canvas->setCentered( false );
			break;
		case ID_buttonPoint:
			newObject = new Point();
			startConstructionMode( i18n( "Click anywhere on the screen to draw a point." ) );
			break;
		case ID_buttonSegment:
			newObject = new Segment();
			startConstructionMode(  i18n( "Click anywhere to draw a segment between two points. New points will be created." ) );
			break;
		case ID_buttonLine:
			newObject = new Line();
			startConstructionMode(  i18n( "Click anywhere to draw a line through two points. New points will be created." ) );
			break;
		case ID_buttonPointOnLine:
			newObject = new PointOnLine();
			startConstructionMode(  i18n( "Click on a line or a circle to draw a point on that object." ) );
			break;
		case ID_buttonPointOfConc:
			newObject = new PointOfConc();
			startConstructionMode(  i18n( "Click on two lines to draw the point of concurrency." ) );
			break;
		case ID_buttonBisection:
			newObject = new Bisection();
			startConstructionMode(  i18n( "Click on any two points to draw the bisection of them." ) );
			break;
		case ID_buttonMirrorPoint:
			newObject = new MirrorPoint();
			startConstructionMode(  i18n( "Click on a point you want to mirror and then on another point or a line." ) );
			break;
		case ID_buttonTriangle:
			newObject = new Triangle();
			startConstructionMode(  i18n( "Click anywhere to draw a triangle. New points will be created." ) );
			break;
		case ID_buttonCircle:
			newObject = new Circle();
			startConstructionMode(  i18n( "First, click on the center point of the circle and then on another to determine the radius." ) );
			break;
		case ID_buttonBaseCircle:
			newObject = new FixedCircle();
			startConstructionMode(  i18n( "First, click on the center point. You will then be asked to enter diameter." ) );
			break;
		case ID_buttonArc:
			newObject = new Arc();
			startConstructionMode(  i18n( "Click on three points to draw an arc." ) );
			break;
		case ID_buttonVector:
			newObject = new Vector();
			startConstructionMode(  i18n( "Click anywhere to draw a vector from the first to the second. New points will be created." )  );
			break;
		case ID_buttonRay:
			newObject = new Ray();
			startConstructionMode(  i18n( "Click anywhere to draw a ray from the first through the second. New points will be created." ) );
			break;
		case ID_buttonParallel:
			newObject = new Parallel();
			startConstructionMode(  i18n( "Click on a line and then on a point through which the parallel line will run." ) );
			break;
		case ID_buttonPerpendicular:
			newObject = new Perpendicular();
			startConstructionMode(  i18n( "Click on a line and then on a point through which the perpendicular line will run." ) );
			break;
		case ID_buttonMove:
			newObject = new Move();
			startConstructionMode(  i18n( "First, click on the point to move and then on a vector to define the movement." ) );
			break;
		case ID_buttonRotation:
			newObject = new Rotation();
			startConstructionMode(  i18n( "Click on the point to rotate, then on the center of the rotation and then on an arc to define the rotation." ) );
			break;
		case ID_buttonEraser:
			newObject = new Eraser();
			startConstructionMode(  i18n( "Click on any object to delete it and all of its child objects." ) );
			break;
		case ID_buttonAttacher:
			newObject = new Attacher();
			startConstructionMode(  i18n( "Click on a point and then on a line or circle to attach this point." ) );
			break;
		case ID_buttonTracer:
			newObject = new Tracer();
			startConstructionMode(  i18n( "Click on a point to turn its trace mode on, or, if it is on, to turn it off." ) );
			break;
		case ID_buttonText:
			newObject = new Text();
			startConstructionMode(  i18n( "Click anywhere to add a text field at that spot." ) );
			break;
		case ID_buttonDistance:
			newObject = new Distance();
			startConstructionMode(  i18n( "Click on any two point to measure its distance." ) );
			break;
		case ID_buttonAngle:
			newObject = new Angle();
			startConstructionMode(  i18n( "Click on an arc to measure the angle." ) );
			break;
		case ID_buttonArea:
			newObject = new Area();
			startConstructionMode(  i18n( "Click on a circle to measure its area." ) );
			break;
		case ID_buttonSlope:
			newObject = new Slope();
			startConstructionMode(  i18n( "Click on any two points to measure the slope between them." ) );
			break;
		case ID_buttonCircumference:
			newObject = new Circumference();
			startConstructionMode(  i18n( "Click on a circle to measure its circumference." ) );
			break;
		case ID_buttonDrawColor:
			newObject = new Colorizer();
		 	kapp->config()->setGroup( "Colors" );
			newObject->setColor( kapp->config()->readColorEntry( "Draw" ) );
			startConstructionMode(  i18n( "Click on any object to apply current draw color" ) );
			break;
		case ID_buttonSizer:
			newObject = new Thicker();
  		kapp->config()->setGroup( "Sizes" );
			newObject->setSize( kapp->config()->readNumEntry( "PointSize", MinimumPointSize ) );
			newObject->setWidth( kapp->config()->readNumEntry( "LineWidth", 1 ) );
			startConstructionMode(  i18n( "Click on any object to apply current size." ) );
			break;
		case ID_buttonPointxy:
			if ( lastButtonID == currentButtonID )
			{
				startMoveMode();
				break;
			}
			CoordinatesDialog *coords = new CoordinatesDialog( 0, 0, true,0 );
			//coords->X->setRange( - MetricsCenter::xMax, MetricsCenter::xMax, 1, false );
			//coords->Y->setRange( - MetricsCenter::yMax, MetricsCenter::yMax, 1, false );
			coords->X->setFocus();
		  if ( ( coords->exec() ) )
			{
				Coordinates coord1( coords->X->text().toDouble(), coords->Y->text().toDouble() );
				MetricsCenter::mapGridToCanvas( coord1 );
				newObject = new Point();
				startConstructionMode( i18n( "Please, enter the coordinates at which you want to draw a point." ) );
				lastButtonID = currentButtonID;
				insertObject( coord1 );
			}
			else
			{
				startMoveMode();
			}
			delete coords;
			break;
	}

	lastButtonID = currentButtonID;
}

void KGeoApp::commandCallback( int id_ )
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
         slotFileNewWindow();
    	 break;

    case ID_FILE_NEW:
    	 slotFileNew();
         break;

    case ID_FILE_OPEN:
         slotFileOpen();
         break;

    case ID_FILE_SAVE:
         slotFileSave();
         break;

    case ID_FILE_SAVE_AS:
         slotFileSaveAs();
         break;

    case ID_FILE_CLOSE:
         slotFileClose();
         break;

    case ID_FILE_PRINT:
         slotFilePrint();
         break;

    case ID_FILE_QUIT:
         slotFileQuit();
         break;

    case ID_EDIT_CUT:
         slotEditCut();
         break;

    case ID_EDIT_COPY:
         slotEditCopy();
         break;

    case ID_EDIT_PASTE:
         slotEditPaste();
         break;

    case ID_EDIT_PREFERENCES:
         slotEditPreferences();
         break;

    case ID_VIEW_TOOLBAR:
         slotViewToolBar();
         break;

    case ID_VIEW_STATUSBAR:
         slotViewStatusBar();
         break;

    case ID_EDIT_FULLSCREEN:
         startKioskMode();
         break;

    default:
         break;
  }
}


void KGeoApp::slotFileNewWindow()
{
}

void KGeoApp::slotFileNew()
{
	newDrawing();
	startMoveMode();
}

void KGeoApp::slotFileOpen()
{
	loadDrawingDialog();
}

void KGeoApp::slotFileOpenRecent( int )
{
}

void KGeoApp::slotFileSave()
{
	if ( unnamedDrawing )
	{
		slotFileSaveAs();
	} else {
		saveDrawing( currentFilename );
	}
}

void KGeoApp::slotFileSaveAs()
{
  QString fileName = KFileDialog::getSaveFileName(QDir::currentDirPath(),
                                               i18n("*.kgeo"), 0, i18n("Save As"));
	if( !fileName.isEmpty() )
	{
		if ( QFile::exists( fileName ) )
		{
			int result;
			result = QMessageBox::warning ( 0, i18n( "KGeo - Warning" ),
						i18n( "The file already exists!\n\n"
									"Do you want to overwrite it? " ),
						QMessageBox::Yes, QMessageBox::No | QMessageBox::Default | QMessageBox::Escape);

			if ( result == QMessageBox::Yes )
			{
				currentFilename = fileName;
				saveDrawing( fileName );
				updateRecentFiles( fileName );
			}
		} else {
				currentFilename = fileName;
				saveDrawing( fileName );
				updateRecentFiles( fileName );
		}

	}
}

void KGeoApp::slotFileClose()
{
}

void KGeoApp::slotFilePrint()
{
	printDialog();
}

void KGeoApp::slotFileQuit()
{
	kapp->quit();
}

void KGeoApp::slotEditCut()
{
}

void KGeoApp::slotEditCopy()
{
}

void KGeoApp::slotEditPaste()
{
}

void KGeoApp::slotEditPreferences()
{
	//	Show prefences window
 	deselectParamObjects();
	move();
	startMoveMode();

	getPreferences();

  if ( ( preferencesDialog->exec() ) )
	{
		savePreferences();
	}
}

void KGeoApp::slotViewToolBar()
{
}

void KGeoApp::slotViewStatusBar()
{
}

void KGeoApp::slotStatusMsg( const QString& )
{
}

void KGeoApp::slotStatusHelpMsg( const QString& )
{
}

void KGeoApp::slotChooseDrawColor()
{
	QColor myColor;
  int result = KColorDialog::getColor( myColor );
  if ( result == KColorDialog::Accepted )
	{
		colorLabel->setBackgroundColor( myColor );
	  kapp->config()->setGroup( "Colors" );
		kapp->config()->writeEntry( "Draw", myColor );
		if ( newObject != 0 )
		{
			newObject->setColor( myColor );
		}
	}
}

void KGeoApp::setPointSize( int size )
{
  kapp->config()->setGroup( "Sizes" );
	config->writeEntry( "PointSize", size + MinimumPointSize );

	if ( newObject != 0 )
	{
		newObject->setSize( size + MinimumPointSize );
	}
}

void KGeoApp::setLineWidth( int width )
{
  kapp->config()->setGroup( "Sizes" );
	config->writeEntry( "LineWidth", width + 1 );

	if ( newObject != 0 )
	{
		newObject->setWidth( width + 1 );
	}
}

void KGeoApp::setBackgroundColor( QColor color )
{
 	kapp->config()->setGroup( "Colors" );
	kapp->config()->writeEntry( "Background", color );

	canvas->setBackgroundColor( color );
	canvas->drawGrid();
	canvas->drawObjects( objectList );
}

void KGeoApp::setDrawColor( QColor color )
{
  kapp->config()->setGroup( "Colors" );
	kapp->config()->writeEntry( "Draw", color );

	if ( newObject != 0 )
	{
		newObject->setColor( color );
	}
}

