// -*- c++ -*-

/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBEDJSHOOKLOADER_H
#define KJSEMBEDJSHOOKLOADER_H

#include <qstring.h>

class KConfig;
namespace KJS { class Interpreter; }

namespace KJSEmbed {

/**
 * A class for executing javascript code fragment loaded from a config
 * file. By default the commands are loaded from the config group 
 * 'JScript Hooks'.
 *
 * @author Richard Moore, rich@kde.org
 * @version $Id: jshookloader.h,v 1.3.2.1 2003/05/19 14:59:35 mueller Exp $
 */
class JSHookLoader
{
public:
    /**
     * Create a hook loader with the specified interpreter and the global config.
     */
    JSHookLoader( KJS::Interpreter *js );

    /**
     * Create a hook loader for the specified config file.
     */
    JSHookLoader( KJS::Interpreter *js, KConfig *conf );

    /**
     * Create a hook loader for the specified config file and group.
     */
    JSHookLoader( KJS::Interpreter *js, KConfig *conf, const QString &group );

    virtual ~JSHookLoader();

    /**
     * Returns the code for the specified hook in the current config/group.
     */
    void runHook( const QString &name );

    /**
     * Returns true if the config/group combination defines any hooks.
     */
    bool hasHooks() const;

    /**
     * Returns the code for the specified hook in the current config/group.
     */
    virtual QString hook( const QString &name ) const;

    /**
     * Set the config file to load commands from.
     */
    void setConfig( KConfig *conf );

    /**
     * Set the group to load commands from.
     */
    void setGroup( const QString &group );

private:
    KJS::Interpreter *js;
    KConfig *cfg;
    QString grp;
    class Private *d;
};

} // namespace KJSEmbed

#endif // KJSEMBEDJSHOOKLOADER_H

// Local Variables:
// c-basic-offset: 4
// End:

