/***************************************************************************
                            KFileViewInterface.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import java.util.*;
import org.kde.qt.*;

public interface KFileViewInterface {

/** 
 inserts a list of items.

*/
//	void addItemList( ArrayList list);

/** 
 a pure virtual function to get a QWidget, that can be added to
 other widgets. This function is needed to make it possible for
 derived classes to derive from other widgets.

*/
	QWidget widget();

/** 
 ### As const-method, to be fixed in 3.0
     
*/
//	QWidget widget();

/** 
 Sets <code>filename</code> the current item in the view, if available.
     
*/
	void setCurrentItem( String filename);

/** 
 Reimplement this to set <code>item</code> the current item in the view, e.g.
 the item having focus.
     
*/
	void setCurrentItem( KFileItem item);

/** 

*/
	KFileItem currentFileItem();

/** 
 Clears the view and all item lists.
     
*/
	void clear();

/** 
 does a repaint of the view.

 The default implementation calls
 <pre>widget().repaint(f)</pre>

*/
	void updateView( boolean f);
	void updateView();
	void updateView( KFileItem arg1);

/** 
 Removes an item from the list; has to be implemented by the view.
 Call KFileView.removeItem( item ) after removing it.
     
*/
	void removeItem( KFileItem item);

/** 
 This hook is called when all items of the currently listed directory
 are listed and inserted into the view, i.e. there won't come any new
 items anymore.
     
*/
	void listingCompleted();

/** 
 Returns the sorting order of the internal list. Newly added files
 are added through this sorting.
      
*/
	boolean sorting();

/** 
 Sets the sorting order of the view.

 Default is QDir.Name | QDir.IgnoreCase | QDir.DirsFirst
 Override this in your subclass and sort accordingly (usually by
 setting the sorting-key for every item and telling QIconView
 or QListView to sort.

 A view may choose to use a different sorting than QDir.Name, Time
 or Size. E.g. to sort by mimetype or any possible string. Set the
 sorting to QDir.Unsorted for that and do the rest internally.

*/
	void setSorting( int sort);

/** 
 Tells whether the current items are in reversed order (shortcut to
 sorting() & QDir.Reversed).
     
*/
	boolean isReversed();
	void sortReversed();

/** 

*/
	int count();

/** 

*/
	int numFiles();

/** 

*/
	int numDirs();
	void setSelectionMode( int sm);
	int selectionMode();
	void setViewMode( int vm);
	int viewMode();

/** 

*/
	String viewName();

/** 
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".
     
*/
	void setViewName( String name);
	void setParentView( KFileViewInterface parent);

/** 
 The derived view must implement this function to add
 the file in the widget.

 Make sure to call this implementation, i.e.
 KFileView.insertItem( i );

     
*/
	void insertItem( KFileItem i);

/** 
 pure virtual function, that should be implemented to clear
 the view. At this moment the list is already empty

*/
	void clearView();

/** 
 pure virtual function, that should be implemented to make item i
 visible, i.e. by scrolling the view appropriately.
     
*/
	void ensureItemVisible( KFileItem i);

/** 
 Clears any selection, unhighlights everything. Must be implemented by
 the view.
     
*/
	void clearSelection();

/** 
 Selects all items. You may want to override this, if you can implement
 it more efficiently than calling setSelected() with every item.
 This works only in Multiselection mode of course.
     
*/
	void selectAll();

/** 
 Inverts the current selection, i.e. selects all items, that were up to
 now not selected and deselects the other.
     
*/
	void invertSelection();

/** 
 Tells the view that it should highlight the item.
 This function must be implemented by the view.

*/
	void setSelected( KFileItem arg1, boolean enable);

/** 

*/
	boolean isSelected( KFileItem arg1);

/** 

*/
	ArrayList selectedItems();

/** 

*/
	ArrayList items();
	KFileItem firstFileItem();
	KFileItem nextItem( KFileItem arg1);
	KFileItem prevItem( KFileItem arg1);

/** 
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on {@link #onlyDoubleClickSelectsFiles}.
     
*/
	void setOnlyDoubleClickSelectsFiles( boolean enable);

/** 

*/
	boolean onlyDoubleClickSelectsFiles();

/** 
 increases the number of dirs and files.

*/
	boolean updateNumbers( KFileItem i);

/** 

*/
	KActionCollection actionCollection();
	KFileViewSignaler signaler();
	void readConfig( KConfig arg1, String group);
	void readConfig( KConfig arg1);
	void writeConfig( KConfig arg1, String group);
	void writeConfig( KConfig arg1);
}
