/***************************************************************************
                            kde_KToolBar.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KTOOLBAR
#define KDE_KTOOLBAR

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A KDE-style toolbar.

 KToolBar can be dragged around in and between different docks.

 A KToolBar can contain all sorts of widgets.

 KToolBar can be used as a standalone widget, but @ref KMainWindow
 provides easy factories and management of one or more toolbars.
 Once you have a KToolBar object, you can insert items into it with the
 insert... methods, or remove them with the @ref removeItem() method. This
 can be done at any time; the toolbar will be automatically updated.
 There are also many methods to set per-child properties like alignment
 and toggle behaviour.

 KToolBar uses a global config group to load toolbar settings on
 construction. It will reread this config group on a
 @ref KApplication::appearanceChanged() signal.

 @author Reginald Stadlbauer <reggie@kde.org>, Stephan Kulow <coolo@kde.org>, Sven Radej <radej@kde.org>.
  
 @version $Id: kde_KToolBar.h,v 1.4 2002/11/25 12:24:35 rdale Exp $

 @short Floatable toolbar with auto resize.

*/
#define KTOOLBAR_IconOnly	0
#define KTOOLBAR_IconTextRight	0
#define KTOOLBAR_TextOnly	1
#define KTOOLBAR_IconTextBottom	2
#define KTOOLBAR_Toggle	0
#define KTOOLBAR_Show	1
#define KTOOLBAR_Hide	2
#define KTOOLBAR_Unmanaged	0
#define KTOOLBAR_Floating	1
#define KTOOLBAR_Top	2
#define KTOOLBAR_Bottom	3
#define KTOOLBAR_Right	4
#define KTOOLBAR_Left	5
#define KTOOLBAR_Flat	6

/** *
 Constructor.
 This constructor is used by the XML-GUI. If you use it, you need
 to call QMainWindow::addToolBar to specify the position of the toolbar.
 So it's simpler to use the other constructor.

 The toolbar will read in various global config settings for
 things like icon size and text position, etc.  However, some of
 the settings will be honored only if @ref #_honor_mode is set to
 true.  All other toolbars will be IconOnly and use Medium icons.

*/
kde_KToolBar * kde_new_KToolBar(qt_QWidget * parent, char* name, int honor_style, int readConfig);

/** *
 Constructor for non-XML-GUI applications.

 The toolbar will read in various global config settings for
 things like icon size and text position, etc.  However, some of
 the settings will be honored only if @ref #_honor_mode is set to
 true.  All other toolbars will be IconOnly and use Medium icons.

*/
kde_KToolBar * kde_new_KToolBar1(qt_QMainWindow* parentWindow, int dock, int newLine, char* name, int honor_style, int readConfig);

/** *
 Constructor for non-XML-GUI applications.

 The toolbar will read in various global config settings for
 things like icon size and text position, etc.  However, some of
 the settings will be honored only if @ref #_honor_mode is set to
 true.  All other toolbars will be IconOnly and use Medium icons.

*/
kde_KToolBar * kde_new_KToolBar2(qt_QMainWindow* parentWindow, qt_QWidget * dock, int newLine, char* name, int honor_style, int readConfig);
void kde_del_KToolBar( kde_KToolBar* p );

/** *
 Insert a button (a @ref KToolBarButton) with a pixmap.  The
 pixmap is loaded by the button itself based on the global icon
 settings.

 You should connect to one or more signals in KToolBar:
 @ref clicked() , @ref pressed() , @ref released() , or
 @ref highlighted()  and if the button is a toggle button
 (@ref setToggle() ) @ref toggled() .  Those signals have @p id
 of a button that caused the signal.  If you want to bind a popup
 to button, see @ref setButton().

*/
int kde_KToolBar_insertButton(kde_KToolBar* instPointer,qt_QString * icon, int identifier, int enabled, qt_QString * text, int index, kde_KInstance* _instance);

/** *
 This is the same as above, but with specified signals and
 slots to which this button will be connected.

 You can add more signals with @ref addConnection().

*/
int kde_KToolBar_insertButton1(kde_KToolBar* instPointer,qt_QString * icon, int identifier, char* signal, qt_QObject * receiver, char* slot, int enabled, qt_QString * text, int index, kde_KInstance* _instance);

/** *
 Inserts a button (a @ref KToolBarButton) with the specified
 pixmap.  This pixmap will be used as the "active" one and the
 disabled and default ones will be autogenerated.

 It is recommended that you use the insertButton function that
 allows you to specify the icon name rather then the pixmap
 itself.  Specifying the icon name is much more flexible.

 You should connect to one or more signals in KToolBar:
 @ref clicked() , @ref pressed() , @ref released() , or
 @ref highlighted()  and if the button is a toggle button
 (@ref setToggle() ) @ref toggled() .  Those signals have @p id
 of a button that caused the signal.  If you want to bind a popup
 to button, see @ref setButton().

*/
int kde_KToolBar_insertButton2(kde_KToolBar* instPointer,qt_QPixmap * pixmap, int identifier, int enabled, qt_QString * text, int index);

/** *
 This is the same as above, but with specified signals and
 slots to which this button will be connected.

 You can add more signals with @ref addConnection().

*/
int kde_KToolBar_insertButton3(kde_KToolBar* instPointer,qt_QPixmap * pixmap, int identifier, char* signal, qt_QObject * receiver, char* slot, int enabled, qt_QString * text, int index);

/** *
 Inserts a button with popupmenu.

 Button will have small
 triangle. You have to connect to popup's signals. The
 signals @ref KButton::pressed(), @ref KButton::released(),
 @ref KButton::clicked() or @ref KButton::doubleClicked() are @p not
 emmited by
 this button (see @ref setDelayedPopup() for that).
 You can add custom popups which inherit @ref QPopupMenu to get popups
 with tables, drawings etc. Just don't fiddle with events there.
   
*/
int kde_KToolBar_insertButton4(kde_KToolBar* instPointer,qt_QString * icon, int identifier, qt_QPopupMenu* popup, int enabled, qt_QString * _text, int index);

/** *
 Inserts a button with popupmenu.

 Button will have small
 triangle. You have to connect to popup's signals. The
 signals @ref KButton::pressed(), @ref KButton::released(),
 @ref KButton::clicked() or @ref KButton::doubleClicked() are @p not
 emmited by
 this button (see @ref setDelayedPopup() for that).
 You can add custom popups which inherit @ref QPopupMenu to get popups
 with tables, drawings etc. Just don't fiddle with events there.
   
*/
int kde_KToolBar_insertButton5(kde_KToolBar* instPointer,qt_QPixmap * pixmap, int identifier, qt_QPopupMenu* popup, int enabled, qt_QString * _text, int index);

/** *
 Inserts a @ref KLineEdit. You have to specify signals and slots to
 which KLineEdit will be connected. KLineEdit has all slots QLineEdit
 has, plus signals @ref KLineEdit::completion and @ref KLineEdit::textRotation
 KLineEdit can be set to autoresize itself to full free width
 in toolbar, that is to last right aligned item. For that,
 toolbar must be set to full width (which it is by default).

*/
int kde_KToolBar_insertLined(kde_KToolBar* instPointer,qt_QString * text, int identifier, char* signal, qt_QObject * receiver, char* slot, int enabled, qt_QString * toolTipText, int size, int index);

/** *
 Inserts a @ref KComboBox with list.

 Can be writable, but cannot contain
 pixmaps. By default inserting policy is AtBottom, i.e. typed items
 are placed at the bottom of the list. Can be autosized. If the size
 argument is specified as -1, the width of the combobox is automatically
 computed.

*/
int kde_KToolBar_insertCombo(kde_KToolBar* instPointer,qt_QStringList* list, int identifier, int writable, char* signal, qt_QObject * receiver, char* slot, int enabled, qt_QString * tooltiptext, int size, int index, int policy);

/** *
 Insert a @ref KComboBox with text.

  The rest is the same as above.

*/
int kde_KToolBar_insertCombo1(kde_KToolBar* instPointer,qt_QString * text, int identifier, int writable, char* signal, qt_QObject * recevier, char* slot, int enabled, qt_QString * tooltiptext, int size, int index, int policy);

/** *
 Inserts a separator into the toolbar with the given id.
 Returns the separator's index
     
*/
int kde_KToolBar_insertSeparator(kde_KToolBar* instPointer,int index, int identifier);

/** *
 Inserts a line separator into the toolbar with the given id.
 Returns the separator's index
     
*/
int kde_KToolBar_insertLineSeparator(kde_KToolBar* instPointer,int index, int identifier);

/** *
 Inserts a user-defined widget.  The widget @p must have this
 toolbar as its parent.

 Widget must have a QWidget for base class.  Widget can be
 autosized to full width. If you forget about it, you can get a
 pointer to this widget with @ref getWidget().

*/
int kde_KToolBar_insertWidget(kde_KToolBar* instPointer,int identifier, int width, qt_QWidget * _widget, int index);

/** *
 Inserts an animated widget.  A @ref KAnimWidget will be created
 internally using the icon name you provide.
 This will emit a signal (clicked()) whenever the
 animation widget is clicked.

*/
int kde_KToolBar_insertAnimatedWidget(kde_KToolBar* instPointer,int identifier, qt_QObject * receiver, char* slot, qt_QString * icons, int index);

/** *
 This will return a pointer to the given animated widget, if it
 exists.

*/
kde_KAnimWidget* kde_KToolBar_animatedWidget(kde_KToolBar* instPointer,int identifier);

/** *
 Adds connections to items.

 It is important that you
 know the @p id of particular item. Nothing happens if you forget @p id.
   
*/
void kde_KToolBar_addConnection(kde_KToolBar* instPointer,int identifier, char* signal, qt_QObject * receiver, char* slot);

/** *
 Enables/disables item.
   
*/
void kde_KToolBar_setItemEnabled(kde_KToolBar* instPointer,int identifier, int enabled);

/** *
 Sets the icon for a button.

 Can be used while button is visible.
   
*/
void kde_KToolBar_setButtonIcon(kde_KToolBar* instPointer,int identifier, qt_QString * _icon);

/** *
 Sets button pixmap.

 Can be used while button is visible.
   
*/
void kde_KToolBar_setButtonPixmap(kde_KToolBar* instPointer,int identifier, qt_QPixmap * _pixmap);

/** *
 Sets a button icon from a QIconSet.

 Can be used while button is visible.
   
*/
void kde_KToolBar_setButtonIconSet(kde_KToolBar* instPointer,int identifier, qt_QIconSet* iconset);

/** *
 Sets a delayed popup for a button.

 Delayed popup is what you see in
 Netscape Navigator's Previous and Next buttons: If you click them you
 go back
 or forth. If you press them long enough, you get a history-menu.
 This is exactly what we do here.

 You will insert normal a button with connection (or use signals from
 toolbar):
 <pre>
 bar->insertButton(icon, id, SIGNAL(clicked ()), this,
                   SLOT (slotClick()), true, "click or wait for popup");
 </pre> And then add a delayed popup:
 <pre>
 bar->setDelayedPopup (id, historyPopup); </pre>

 Don't add delayed popups to buttons which have normal popups.

 You may add popups which are derived from @ref QPopupMenu. You may
 add popups that are already in the menu bar or are submenus of
 other popups.
   
*/
void kde_KToolBar_setDelayedPopup(kde_KToolBar* instPointer,int identifier, qt_QPopupMenu* _popup, int toggle);

/** *
 Turns a button into an autorepeat button.

 Toggle buttons, buttons with menus, or
 buttons with delayed menus cannot be made into autorepeat buttons.
 Moreover, you can and will receive
 only the signal clicked(), but not pressed() or released().
 When the user presses this button, you will receive the signal clicked(),
 and if the button is still pressed after some time,
 you will receive more clicked() signals separated by regular
 intervals.  Since this uses @ref QButton::setAutoRepeat() ,
 I can't quantify 'some'.
   
*/
void kde_KToolBar_setAutoRepeat(kde_KToolBar* instPointer,int identifier, int flag);

/** *
 Turns button into a toggle button if @p flag is true.
   
*/
void kde_KToolBar_setToggle(kde_KToolBar* instPointer,int identifier, int flag);

/** *
 Toggles a togglebutton.

 If the button is a toggle button  (see @ref setToggle())
 the button state will be toggled. This will also cause the toolbar to
 emit the signal @ref KButton::toggled() with parameter @p id. You must connect to
 this signal, or use @ref addConnection() to connect directly to the
 button signal @ref KButton::toggled().
   
*/
void kde_KToolBar_toggleButton(kde_KToolBar* instPointer,int identifier);

/** *
 Sets a toggle button state.

 If the button is a toggle button (see @ref setToggle())
 this will set its state flag. This will also emit the signal
 @ref KButton::toggled().

*/
void kde_KToolBar_setButton(kde_KToolBar* instPointer,int identifier, int flag);

/** *

*/
int kde_KToolBar_isButtonOn(kde_KToolBar* instPointer,int identifier);

/** *
 Sets the text of a line editor.

 Cursor is set at end of text.
   
*/
void kde_KToolBar_setLinedText(kde_KToolBar* instPointer,int identifier, qt_QString * text);

/** *
 Returns a line editor text.
   
*/
qt_QString * kde_KToolBar_getLinedText(kde_KToolBar* instPointer,int identifier);

/** *
 Inserts @p text in combobox @p id at position @p index.
   
*/
void kde_KToolBar_insertComboItem(kde_KToolBar* instPointer,int identifier, qt_QString * text, int index);

/** *
 Inserts @p list in combobox @p id at position @p index.
   
*/
void kde_KToolBar_insertComboList(kde_KToolBar* instPointer,int identifier, qt_QStringList* list, int index);

/** *
 Removes item @p index from combobox @p id.
   
*/
void kde_KToolBar_removeComboItem(kde_KToolBar* instPointer,int identifier, int index);

/** *
 Sets item @p index to be current item in combobox @p id.
   
*/
void kde_KToolBar_setCurrentComboItem(kde_KToolBar* instPointer,int identifier, int index);

/** *
 Changes item @p index in combobox @p id to text.

 @p index = -1 refers current item (one displayed in the button).
   
*/
void kde_KToolBar_changeComboItem(kde_KToolBar* instPointer,int identifier, qt_QString * text, int index);

/** *
 Clears the combobox @p id.

 Does not delete it or hide it.
   
*/
void kde_KToolBar_clearCombo(kde_KToolBar* instPointer,int identifier);

/** *
 Returns text of item @p index from combobox @p id.

 @p index = -1 refers to current item.
   
*/
qt_QString * kde_KToolBar_getComboItem(kde_KToolBar* instPointer,int identifier, int index);

/** *
 Returns a pointer to the combobox.

 Example:
 <pre>
 KComboBox *combo = toolbar->getCombo(combo_id);
 </pre>
 That way you can get access to other public methods
 that @ref KComboBox provides.
   
*/
kde_KComboBox* kde_KToolBar_getCombo(kde_KToolBar* instPointer,int identifier);

/** *
 Returns a pointer to KToolBarLined.

 Example:
 <pre>
 KLineEdit * lined = toolbar->getKTollBarLined(lined_id);
 </pre>
 That way you can get access to other public methods
 that @ref KLineEdit provides. @ref KLineEdit is the same thing
 as @ref QLineEdit plus completion signals.
   
*/
kde_KLineEdit* kde_KToolBar_getLined(kde_KToolBar* instPointer,int identifier);

/** *
 Returns a pointer to KToolBarButton.

 Example:
 <pre>
 KToolBarButton * button = toolbar->getButton(button_id);
 </pre>
 That way you can get access to other public methods
 that @ref KToolBarButton provides.

  Using this method is not recommended.
   
*/
kde_KToolBarButton* kde_KToolBar_getButton(kde_KToolBar* instPointer,int identifier);

/** *
 Align item to the right.

 This works only if toolbar is set to full width.

*/
void kde_KToolBar_alignItemRight(kde_KToolBar* instPointer,int identifier, int right);

/** *
 Returns a pointer to an inserted widget.

 Wrong ids are not tested.
 You can do with this whatever you want,
 except change its height (hardcoded). If you change its width
 you will probably have to call QToolBar::updateRects(true)

*/
qt_QWidget * kde_KToolBar_getWidget(kde_KToolBar* instPointer,int identifier);

/** *
 Set item autosized.

 This works only if the toolbar is set to full width.
 Only @p one item can be autosized, and it has to be
 the last left-aligned item. Items that come after this must be right
 aligned. Items that can be right aligned are Lineds, Frames, Widgets and
 Combos. An autosized item will resize itself whenever the toolbar geometry
 changes to the last right-aligned item (or to end of toolbar if there
 are no right-aligned items.)

*/
void kde_KToolBar_setItemAutoSized(kde_KToolBar* instPointer,int identifier, int yes);

/** *
 Remove all items.

 The toolbar is redrawn after it.
   
*/
void kde_KToolBar_clear(kde_KToolBar* instPointer);

/** *
 Remove item @p id.

 Item is deleted. Toolbar is redrawn after it.
   
*/
void kde_KToolBar_removeItem(kde_KToolBar* instPointer,int identifier);

/** *
 Hide item.
   
*/
void kde_KToolBar_hideItem(kde_KToolBar* instPointer,int identifier);

/** *
 Show item.
   
*/
void kde_KToolBar_showItem(kde_KToolBar* instPointer,int identifier);

/** *
 Set toolbar to full parent size (default).

  In full size mode the bar
 extends over the parent's full width or height. If the mode is disabled
 the toolbar tries to take as much space as it needs without wrapping, but
 it does not exceed the parent box. You can force a certain width or
 height with @ref setMaxWidth() or @ref setMaxHeight().

 If you want to use right-aligned items or auto-sized items you must use
 full size mode.
   
*/
void kde_KToolBar_setFullSize(kde_KToolBar* instPointer,int flag);

/** *

*/
int kde_KToolBar_fullSize(kde_KToolBar* instPointer);

/** *

 Enable or disable moving of toolbar.
   
*/
void kde_KToolBar_enableMoving(kde_KToolBar* instPointer,int flag);

/** *
 Set position of toolbar.

*/
void kde_KToolBar_setBarPos(kde_KToolBar* instPointer,int bpos);

/** *
 Returns position of toolbar.
   
*/
int kde_KToolBar_barPos(kde_KToolBar* instPointer);

/** *

 Show, hide, or toggle toolbar.

 This method is provided for compatibility only,
 please use show() and/or hide() instead.

*/
int kde_KToolBar_enable(kde_KToolBar* instPointer,int stat);

/** *

 Use setMaximumHeight() instead.
   
*/
void kde_KToolBar_setMaxHeight(kde_KToolBar* instPointer,int h);

/** *

 Use maximumHeight() instead.
 Returns the value that was set with @ref setMaxHeight().
   
*/
int kde_KToolBar_maxHeight(kde_KToolBar* instPointer);

/** *

 Use setMaximumWidth() instead.
 Set maximal width of horizontal (top or bottom) toolbar.
   
*/
void kde_KToolBar_setMaxWidth(kde_KToolBar* instPointer,int dw);

/** *

 Use maximumWidth() instead.
 Returns the value that was set with @ref setMaxWidth().
   
*/
int kde_KToolBar_maxWidth(kde_KToolBar* instPointer);

/** *
 Set title for toolbar when it floats.

 Titles are however not (yet)
 visible. You can't change toolbar's title while it's floating.
   
*/
void kde_KToolBar_setTitle(kde_KToolBar* instPointer,qt_QString * _title);

/** *

 Use enableMoving() instead.
   
*/
void kde_KToolBar_enableFloating(kde_KToolBar* instPointer,int arrrrrrgh);

/** *
 Set the kind of painting for buttons.

 Choose from:

   
*/
void kde_KToolBar_setIconText(kde_KToolBar* instPointer,int it);

/** *
 Similar to @ref setIconText(IconText it) but allows you to
 disable or enable updating.  If @p update is false, then the
 buttons will not be updated.  This is useful only if you know
 that you will be forcing an update later.
   
*/
void kde_KToolBar_setIconText1(kde_KToolBar* instPointer,int it, int update);

/** *

*/
int kde_KToolBar_iconText(kde_KToolBar* instPointer);

/** *
 Set the icon size to load. Usually you should not call
 this, the icon size is taken care of by KIconLoader
 and globally configured.
 By default, the toolbar will load icons of size 32 for main
 toolbars and 22 for other toolbars

*/
void kde_KToolBar_setIconSize(kde_KToolBar* instPointer,int size);

/** *
 Same as @ref setIconText(int size) but allows you
 to disable the toolbar update.

*/
void kde_KToolBar_setIconSize1(kde_KToolBar* instPointer,int size, int update);

/** *

*/
int kde_KToolBar_iconSize(kde_KToolBar* instPointer);

/** *
 This allows you to enable or disable the context menu.

*/
void kde_KToolBar_setEnableContextMenu(kde_KToolBar* instPointer,int enable);

/** *
 Returns whether or not the context menu is disabled

*/
int kde_KToolBar_contextMenuEnabled(kde_KToolBar* instPointer);

/** *
 This will inform a toolbar button to ignore certain style
 changes.  Specifically, it will ignore IconText (always IconOnly)
 and will not allow image effects to apply.

*/
void kde_KToolBar_setItemNoStyle(kde_KToolBar* instPointer,int identifier, int no_style);
void kde_KToolBar_setFlat(kde_KToolBar* instPointer,int flag);

/** *

*/
int kde_KToolBar_count(kde_KToolBar* instPointer);

/** *
 Instruct the toolbar to save it's current state to either the app
 config file or to the XML-GUI resource file (whichever has
 precedence).
   
*/
void kde_KToolBar_saveState(kde_KToolBar* instPointer);

/** *
 Save the toolbar settings to group @p configGroup in @p config.
   
*/
void kde_KToolBar_saveSettings(kde_KToolBar* instPointer,kde_KConfig* config, qt_QString * configGroup);

/** *
 Read the toolbar settings from group @p configGroup in @p config
 and apply them.
   
*/
void kde_KToolBar_applySettings(kde_KToolBar* instPointer,kde_KConfig* config, qt_QString * configGroup);

/** *
 Tell the toolbar what XML-GUI resource file it should use to save
 it's state.  The state of the toolbar (position, size, etc) is
 saved in KConfig files if the application does not use XML-GUI..
 but if the app does, then it's saved the XML file.  This function
 allows this to happen.

*/
void kde_KToolBar_setXMLGUIClient(kde_KToolBar* instPointer,kde_KXMLGUIClient* client);

/** *
 Assign a (translated) text to this toolbar. This is used
 for the tooltip on the handle, and when listing the toolbars.
   
*/
void kde_KToolBar_setText(kde_KToolBar* instPointer,qt_QString * txt);

/** *

*/
qt_QString * kde_KToolBar_text(kde_KToolBar* instPointer);
void kde_KToolBar_setStretchableWidget(kde_KToolBar* instPointer,qt_QWidget * w);
qt_QSizePolicy* kde_KToolBar_sizePolicy(kde_KToolBar* instPointer);
int kde_KToolBar_highlight(kde_KToolBar* instPointer);
qt_QSize * kde_KToolBar_sizeHint(kde_KToolBar* instPointer);
qt_QSize * kde_KToolBar_minimumSizeHint(kde_KToolBar* instPointer);
qt_QSize * kde_KToolBar_minimumSize(kde_KToolBar* instPointer);
void kde_KToolBar_hide(kde_KToolBar* instPointer);
void kde_KToolBar_show(kde_KToolBar* instPointer);
void kde_KToolBar_updateRects(kde_KToolBar* instPointer,int arg1);
void kde_KToolBar_loadState(kde_KToolBar* instPointer,qt_QDomElement* e);
void kde_KToolBar_saveState1(kde_KToolBar* instPointer,qt_QDomElement* e);

/** *

     
*/
void kde_KToolBar_positionYourself(kde_KToolBar* instPointer,int force);
void kde_KToolBar_setIconText2(kde_KToolBar* instPointer,qt_QString * txt);
int kde_KToolBar_event(kde_KToolBar* instPointer,qt_QEvent * e);
void kde_KToolBar_applyAppearanceSettings(kde_KToolBar* instPointer,kde_KConfig* config, qt_QString * _configGroup, int forceGlobal);
qt_QString * kde_KToolBar_settingsGroup(kde_KToolBar* instPointer);
void kde_KToolBar_virtual_hook(kde_KToolBar* instPointer,int identifier, void* data);

#endif
