/***************************************************************************
                            kde_KEditToolbarWidget.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KEDITTOOLBARWIDGET
#define KDE_KEDITTOOLBARWIDGET

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This is a widget used to customize or configure toolbars

 This is the widget that does all of the work for the
 @ref KEditToolbar dialog.  In most cases, you will want to use the
 dialog instead of this widget directly.

 Typically, you would use this widget only if you wanted to embed
 the toolbar editing directly into your existing configure or
 preferences dialog.

 This widget only works if your application uses the XML UI
 framework for creating menus and toolbars.  It depends on the XML
 files to describe the toolbar layouts and it requires the actions
 to determine which buttons are active.

 @author Kurt Granroth <granroth@kde.org>

 @short A widget used to customize or configure toolbars.
*/

/** *
 Constructor.  This is the only entry point to this class.  You
 @p must pass along your collection of actions (some of which
 appear in your toolbars).  The other three parameters are
 optional.

 The second parameter, @ref #xmlfile, is the name (absolute or
 relative) of your application's UI resource file.  If it is
 left blank, then the resource file: share/apps/appname/appnameui.rc
 is used.  This is the same resource file that is used by the
 default createGUI function in KMainWindow so you're usually
 pretty safe in leaving it blank.

 The third parameter, @ref #global, controls whether or not the
 global resource file is used.  If this is true, then you may
 edit all of the actions in your toolbars -- global ones and
 local one.  If it is false, then you may edit only your
 application's entries.  The only time you should set this to
 false is if your application does not use the global resource
 file at all (very rare)

 The last parameter, @ref #parent, is the standard parent stuff.

*/
kde_KEditToolbarWidget * kde_new_KEditToolbarWidget(kde_KActionCollection* collection, qt_QString * file, int global, qt_QWidget * parent);

/** *
 Constructor for KParts based apps.

 The first parameter, @ref #factory, is a pointer to the XML GUI
 factory object for your application.  It contains a list of all
 of the GUI clients (along with the action collections and xml
 files) and the toolbar editor uses that.

 The second parameter, @ref #parent, is the standard parent

 Use this like so:
 <pre>
 KEditToolbar edit(factory());
 if ( edit.exec() )
 ...
 </pre>

*/
kde_KEditToolbarWidget * kde_new_KEditToolbarWidget1(kde_KXMLGUIFactory* factory, qt_QWidget * parent);

/** *
 Destructor.  Note that any changes done in this widget will
 @p NOT be saved in the destructor.  You @p must call @ref save()
 to do that.
   
*/
void kde_del_KEditToolbarWidget( kde_KEditToolbarWidget* p );

/** *
 Save any changes the user made.  The file will be in the user's
 local directory (usually $HOME/.kde/share/apps/<appname>).  The
 filename will be the one specified in the constructor.. or the
 made up one if the filename was NULL.

*/
int kde_KEditToolbarWidget_save(kde_KEditToolbarWidget* instPointer);
void kde_KEditToolbarWidget_setupLayout(kde_KEditToolbarWidget* instPointer);
void kde_KEditToolbarWidget_loadToolbarCombo(kde_KEditToolbarWidget* instPointer);
void kde_KEditToolbarWidget_loadActionList(kde_KEditToolbarWidget* instPointer,qt_QDomElement* elem);
void kde_KEditToolbarWidget_updateLocal(kde_KEditToolbarWidget* instPointer,qt_QDomElement* elem);
void kde_KEditToolbarWidget_virtual_hook(kde_KEditToolbarWidget* instPointer,int identifier, void* data);
void kde_KEditToolbarWidget_slotToolbarSelected(kde_KEditToolbarWidget* instPointer,qt_QString * text);
void kde_KEditToolbarWidget_slotInactiveSelected(kde_KEditToolbarWidget* instPointer,qt_QListViewItem * item);
void kde_KEditToolbarWidget_slotActiveSelected(kde_KEditToolbarWidget* instPointer,qt_QListViewItem * item);
void kde_KEditToolbarWidget_slotInsertButton(kde_KEditToolbarWidget* instPointer);
void kde_KEditToolbarWidget_slotRemoveButton(kde_KEditToolbarWidget* instPointer);
void kde_KEditToolbarWidget_slotUpButton(kde_KEditToolbarWidget* instPointer);
void kde_KEditToolbarWidget_slotDownButton(kde_KEditToolbarWidget* instPointer);

/** Casts a 'kde_KEditToolbarWidget *' to a 'kde_KXMLGUIClient*' */
kde_KXMLGUIClient* kde_KEditToolbarWidget_KXMLGUIClient(kde_KEditToolbarWidget* instPointer);

/** Casts a 'kde_KEditToolbarWidget *' to a 'qt_QWidget *' */
qt_QWidget * kde_KEditToolbarWidget_QWidget(kde_KEditToolbarWidget* instPointer);

#endif
