#include <qwidget.h>
#include "kab_mkIII.h"
#include "../kab_mkIII/kab3global.h"
#include <kdebug.h>
#include <kcmodule.h>
#include <kgenericfactory.h>

typedef KGenericFactory<KcmKab, QWidget> KcmKabFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kabmkIII, KcmKabFactory("kabmkIII") );

KcmKab::KcmKab(QWidget *parent, const char *name, const QStringList &)
    :   KCModule(KcmKabFactory::instance(), parent, name),
        m_changed(false),
        m_config(0)
{
    m_widget=new KcmKabMainWidget(this, "KcmKabMainWidget");
    load();
}

KcmKab::~KcmKab()
{
}

void KcmKab::defaults()
{
}

QString KcmKab::quickHelp() const
{
    return i18n( "<h1>Control Module for KAB MkIII</h1>"
      " Configure the KDE Address Book using this module.");
}

void KcmKab::load()
{
    kdDebug() << "KcmKab::load" << endl;
    m_config=new KConfig("kab3partrc", false, true);
    if(m_config!=0)
    {
        m_widget->configure(m_config);
        delete m_config;
        m_config=0;
    }
}

void KcmKab::save()
{
    kdDebug() << "KcmKab::save" << endl;
    m_config=new KConfig("kab3partrc", false, true);
    if(m_config!=0)
    {
        m_widget->commit(m_config);
        m_config->sync();
        delete m_config;
        m_config=0;
    }
}

int KcmKab::buttons()
{
  return KCModule::Help | KCModule::Default | KCModule::Apply;
}

void KcmKab::resizeEvent(QResizeEvent*)
{
    m_widget->setGeometry(0, 0, width(), height());
}

#include "kab_mkIII.moc"
