#ifndef KBBPREFS_H
#define KBBPREFS_H
// $Id: kbbprefs.h,v 1.8 2002/03/02 10:28:24 binner Exp $
// (C) 2001 by Cornelius Schumacher

#include <qmap.h>

#include "kprefs.h"
#include "mailsender.h"

class QStringList;

class KBBPrefs : public KPrefs
{
  public:
    virtual ~KBBPrefs();
  
    static KBBPrefs *instance();

  protected:
    void usrSetDefaults();
    void usrReadConfig();
    void usrWriteConfig();

    void setMessageButtonsDefault();

  private:
    KBBPrefs();

    static KBBPrefs *mInstance;

  public:
    QStringList     mRecentPackages;
    int             mRecentPackagesCount;

    QString         mCurrentPackage;
    QString         mCurrentBug;

    QValueList<int> mSplitter1;
    QValueList<int> mSplitter2;

    int             mMailClient;
    bool            mShowClosedBugs;
    bool            mShowWishes;
    bool            mSendBCC;
    QString         mOverrideRecipient;

    QMap<QString,QString> mMessageButtons;

    int mMsgDlgWidth;
    int mMsgDlgHeight;
    QValueList<int> mMsgDlgSplitter;
};

#endif
