/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef CATALOGSETTINGS_H
#define CATALOGSETTINGS_H

#include <qstring.h>
#include <qregexp.h>
#include <qdatetime.h>

class QTextCodec;
class QStringList;

enum FileEncoding{Locale,UTF8,UTF16};


struct SaveSettings
{
    bool autoUpdate;
    bool updateLastTranslator;
    bool updateRevisionDate;
    bool updateLanguageTeam;
    bool updateCharset;
    bool updateEncoding;

    FileEncoding encoding;
    bool useOldEncoding;

    Qt::DateFormat dateFormat;
    QString customDateFormat;

    bool autoSyntaxCheck;
};

struct IdentitySettings
{
    QString authorName;
    QString authorEmail;
    QString languageName;
    QString languageCode;
    QString mailingList;
    QString timeZone;

   /**
    * The number of plural forms. If <= 0 the number is determined
    * automatically.
    */
   int numberOfPluralForms;

};


struct MiscSettings
{
   /** 
    * The char, that marks keyboard accelerators.
    * Default is '&' as used by Qt
    */
   QChar accelMarker;
   
   /**
    * The regular expression for what is context information.
    * Default is "^_:.+" as used in KDE
    */ 
   QRegExp contextInfo;

   /** 
    * The regular expression for strings that contain a message for
    * singular and one for plural
    */
   QRegExp singularPlural;
};

struct TagSettings
{
    /**
    * A list of regular expressions defining tags
    */
    QStringList expressions;
};

QString charsetString(FileEncoding);
QString charsetString(QTextCodec *codec);

namespace Defaults
{
   /**
   * this class contains or computes the defaults values of the
   * Save preferences
   */
   class Save
   {
    public:
       static const bool autoUpdate=true;
       static const bool updateLastTranslator=true;
       static const bool updateRevisionDate=true;
       static const bool updateLanguageTeam=true;
       static const bool updateCharset=true;
       static const bool updateEncoding=true;

       static const FileEncoding encoding=UTF8;
       static const bool useOldEncoding=true;

       static const Qt::DateFormat dateFormat=Qt::ISODate;

       static const bool autoSyntaxCheck=true;

       static const QString customDateFormat();
   };

   class Identity
   {
    public:
       Identity();
       QString authorName();
       QString authorEmail();
       QString languageName();
       QString languageCode();
       QString mailingList();
       QString timezone();

       const int numberOfPluralForms;

    private:
       QString _authorName;
       QString _authorEmail;
       QString _mailingList;
       QString _timezone;
       QString _languageName;
       QString _languageCode;
   };

   class Misc
   {
      public:
         QChar accelMarker();
         QRegExp contextInfo();
         QRegExp singularPlural();
   };
   
   class Tag
   {
      public:
	 static QStringList expressions();
   };
}


#endif
