/*
  noatun visualisation interface for winskin
  Copyright (C) 2001  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "winSkinVis.h"

#define __BANDS     75
#define __SPAHEIGHT 15


#ifdef _COMPILE_WINSKINVIS


WinSkinVis::WinSkinVis(QObject *parent, const char *name):
  QObject(parent,name),Visualization(50) {

  // create FFT on server
  winSkinFFT=new Noatun::WinSkinFFT();
  *winSkinFFT=Arts::DynamicCast(server()->createObject("Noatun::WinSkinFFT"));
  
  if ( (*winSkinFFT).isNull() ) {
    delete winSkinFFT;
    winSkinFFT=NULL;
  } else {
    winSkinFFT->bandResolution(__BANDS);
    winSkinFFT->start();
    mId=visualizationStack().insertBottom(*winSkinFFT, "WinSkin FFT");
  }
  currentPeaks=new float[__BANDS];
  int i;
  for(i=0;i<__BANDS;i++) {
    currentPeaks[i]=0.0;
  }

  // start visualisation
  start();
}


WinSkinVis::~WinSkinVis() {
  if (winSkinFFT != NULL) {
    if (connected()) {
      visualizationStack().remove(mId);
      winSkinFFT->stop();
      delete winSkinFFT;
    }
  }

  delete[] currentPeaks;
}


void WinSkinVis::timeout() {

  if (winSkinFFT != NULL) {
	  std::vector<float> *data(winSkinFFT->scope());
    
    float *f=&data->front();
    if (data->size()) scopeEvent(f, data->size());
    delete data;
  }

}

float* WinSkinVis::getCurrentPeaks() {
  return currentPeaks;
}

void WinSkinVis::scopeEvent(float* bandPtr, int bands) {
  int i;

  for (i=0;i<bands;i++) {
    float value=bandPtr[i];
    // if the peak is less we prefer the higher one
    if (currentPeaks[i] < value) {
      currentPeaks[i]=value;
    } else {
      currentPeaks[i]=currentPeaks[i]-1.3;
    }
    if (currentPeaks[i] < 0) {
      currentPeaks[i]=0;
    }
    if (currentPeaks[i] > __SPAHEIGHT) {
      currentPeaks[i]=__SPAHEIGHT;
    }    
  }
  emit(dorepaint());
}


#include "winSkinVis.moc"

#endif
// _COMPILE_WINSKINVIS
