/***************************************************************************
	kjwidget.cpp  -  Base Class for all widgets
	--------------------------------------
	Maintainer: Stefan Gehn <sgehn@gmx.net>

 ***************************************************************************/

// local includes
#include "kjwidget.h"

// ugly static functions and stuff
#include "helpers.cpp"

#include <qpainter.h>

KJWidget::KJWidget(KJLoader *p) : mParent(p)
{
}

QBitmap KJWidget::getMask(const QImage &_rect, register QRgb transparent)
{
	QImage result(_rect.width(), _rect.height(), 1,2, QImage::LittleEndian);
	result.setColor(0, qRgb(0,0,0));
	result.setColor(1, qRgb(255,255,255));

	for (int height=0;height<_rect.height(); height++)
	{
		for (int width=0; width<_rect.width(); width++)
			setPixel1BPP(result, width, height,
			             _rect.pixel(width, height)!=transparent);
	}

	QBitmap bm;
	bm.convertFromImage(result);
	return bm;

/*
	register QRgb magenta=QColor(255,0,255).rgb();
	QImage rect=_rect.convertDepth(32);
	register int width=rect.width();
	register int height=rect.height();

	QImage result(width, height, 1,2, QImage::LittleEndian);
	result.setColor(0, qRgb(0,0,0));
	result.setColor(1, qRgb(255,255,255));

	for (register int cheight=height; cheight!=0; --cheight)
	{
		register QRgb *srcline=(QRgb*)rect.scanLine(cheight);
		register QRgb *resline=(QRgb*)result.scanLine(cheight);
		for (register int cwidth=width; cwidth!=0; --cwidth)
			setPixel1BPP(result, cwidth, cheight,srcline[cwidth]==magenta);
	}

	QBitmap bm;
	bm.convertFromImage(result);
	return bm;
*/
}

void KJWidget::repaint(bool me, const QRect &r, bool clear)
{
	QPainter p(parent());
	if (me)
		paint(&p, r.isValid() ? r : rect());
	else
		parent()->repaint(r.isValid() ? r : rect(), clear);
}

QString KJWidget::backgroundPressed ( const QString &bmp )
{
//	kdDebug(66666) << "returning pressed pixmap for " << bmp.latin1() << endl;
	return parser()["backgroundimagepressed"+QString::number(bmp.mid(3).toInt())][1];
}
