#ifndef __VIDEO_H
#define __VIDEO_H

#include <qframe.h>
#include <arts/kmedia2.h>


class Video : public QFrame
{
Q_OBJECT

public:
	/**
	 * Give this widget a name.  The name should be
	 * unique, probably the same as your plugin's
	 * name.  This class is OPTIONAL, and only useful
	 * for reparenting
	 **/
	Video(const QString &title, QWidget *parent, const char *name=0, WFlags f=0);
	~Video();

	bool fullscreen() const;

	Arts::VideoPlayObject video() const;
	
public slots:
	virtual void setFullscreen(bool fs);
	void setFullscreen() { setFullscreen(true); }
	
protected:
	virtual void window(WId video);
	virtual void destroyed();
	
private slots:
	void changed();
	void doItAgain();
public:
	void embed(WId w);
	bool embedded() { if(mWindow != 0) return true; else return false; }

	QSize sizeHint() const;
	QSize minimumSizeHint() const;
	QSizePolicy sizePolicy() const;

	bool eventFilter(QObject *, QEvent *);

protected:
	bool event(QEvent *);

	void focusInEvent(QFocusEvent *);
	void focusOutEvent(QFocusEvent *);
	void resizeEvent(QResizeEvent *);

	bool x11Event(XEvent *);

	bool focusNextPrevChild(bool next);

private:
	WId mWindow;
};


#endif

