/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org
    Artwork from KDevelop Project, Ralf Nolden, nolden@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include "kstartuplogo.h"
#include "kstartuplogo.moc"
#include <kapplication.h>
#include <kstandarddirs.h>
#include <qcursor.h>

KStartupLogo::KStartupLogo(QWidget * parent, const char *name) : QWidget(parent,name, WStyle_NoBorderEx | WStyle_Customize | WDestructiveClose ), m_bReadyToHide( false ){
  QPixmap pm;
  pm.load(locate("appdata", "pics/startlogo.png"));
  setBackgroundPixmap(pm);
  // We don't have any geometry yet so we just have to go with the cursor
  QRect desk = QApplication::desktop()->screenGeometry(QApplication::desktop()->screenNumber(QCursor::pos()));
  setGeometry(desk.center().x()-pm.width()/2, desk.center().y()-pm.height()/2, pm.width(),pm.height());
}

KStartupLogo::~KStartupLogo(){
}

void KStartupLogo::mousePressEvent( QMouseEvent*){
  if (m_bReadyToHide) hide();
}
