/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef KONCD_H
#define KONCD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

#include <kapp.h>
#include <koncd_mainwindow.h>

/** KOnCD is the base class of the project */
class KOnCD : public KOnCD_MainWindow {
  Q_OBJECT 

public:
    /** construtor */
    KOnCD(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~KOnCD();

protected:
	void setupMenubar();
  enum{ID_READER_LOAD, ID_READER_EJECT, ID_READER_RESET, ID_WRITER_LOAD, ID_WRITER_EJECT, ID_WRITER_RESET};

protected slots:
	void slot_exitApp();
	void slot_setup();
	void slot_setupRipCD();
	void slot_copyCD();
	void slot_masterCD();
	void slot_audioCD();
	void slot_tools();
	void slot_ripCD();
	void slot_image_type();
	void slot_resetDevices();
	void slot_devices(int);
};

#endif
