// userinterface.cpp
//
// Copyright (C) 2001 Neil Stevens <neil@qualityassistant.com>
// Copyright (C) 1999 Charles Samuels <charles@kde.org>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kconfig.h>
#include <kdialog.h>
#include <kglobal.h>
#include <klocale.h>
#include <kmenubar.h>
#include <kstdaction.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <qdragobject.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qvbox.h>

#include "conf.h"
#include "kaboodleapp.h"
#include "player.h"
#include "userinterface.h"
#include <kstatusbar.h>

UserInterface::UserInterface(QWidget *parent, const KURL &initialFile)
	: KParts::MainWindow(parent)
{
	setAcceptDrops(true);
	
	KStdAction::open(this, SLOT(fileOpen()), actionCollection());
	KStdAction::quit(kapp, SLOT(quit()), actionCollection());
	KStdAction::preferences(this, SLOT(playerPreferences()), actionCollection());
	toolbarAction = KStdAction::showToolbar(this, SLOT(showToolbar()), actionCollection());
	menubarAction = KStdAction::showMenubar(this, SLOT(showMenubar()), actionCollection());

	part = new KaboodlePart(this, "kaboodlepart");

	setCentralWidget(part->widget());	
	createGUI(part);
	toolBar("mainToolBar")->hide();
	
	statusBar()->show();

	connect(part, SIGNAL(setWindowCaption(const QString &)), this, SLOT(updateTitle(const QString &)));

	setIcon(SmallIcon("kaboodle"));

	KConfig &config = *KGlobal::config();
	
	toolBar("KaboodleToolbar")->applySettings(&config, "KaboodleToolbar");
	toolbarAction->setChecked( !toolBar("KaboodleToolbar")->isHidden() );

	config.setGroup("userinterface");
	menubarAction->setChecked( config.readBoolEntry("menuShown", true) );
	showMenubar();

	resize(320, minimumHeight());
	setFixedHeight(minimumHeight());

	if(!initialFile.isEmpty())
	    part->openFile(initialFile);

	show();
}

UserInterface::~UserInterface()
{
	KConfig &config = *KGlobal::config();
	toolBar("KaboodleToolbar")->saveSettings(&config, "KaboodleToolbar");
	config.setGroup("userinterface");
	config.writeEntry("menuShown", menubarAction->isChecked());
	config.sync();
}

void UserInterface::fileOpen()
{
	KURL file(KFileDialog::getOpenURL(QString::null, "*", this, i18n("Select a file to Play")));
	if(!file.isMalformed())
	    part->openFile(file);
}

void UserInterface::dragEnterEvent(QDragEnterEvent *event)
{
    // accept uri drops only
    event->accept(QUriDrag::canDecode(event));
}

void UserInterface::dropEvent(QDropEvent *event)
{
	QStrList uri;
	if (QUriDrag::decode(event, uri))
	{
		char *file = uri.first();
		if(file) part->openFile(KURL(file));
	}
}

void UserInterface::playerPreferences()
{
	Conf dlg(this);
	dlg.exec();
}

void UserInterface::showToolbar(void)
{
	if(toolbarAction->isChecked())
		toolBar("KaboodleToolbar")->show();
	else
		toolBar("KaboodleToolbar")->hide();
}

void UserInterface::showMenubar(void)
{
	if(menubarAction->isChecked())
		menuBar()->show();
	else
		menuBar()->hide();
}

void UserInterface::updateTitle(const QString &text)
{
	setCaption(text);
	statusBar()->message(text);
}

#include "userinterface.moc"

