/***************************************************************************
                          kcontrolheader.cpp  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcontrolheader.h"
#include "kcontrolheader.moc"

#include <klocale.h>
#include <kstandarddirs.h>
#include <kconfig.h>
#include <ksimpleconfig.h>

#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>

kcontrolheader::kcontrolheader(FileRead *KEDUCAPTR, QWidget *parent, const char *name ) : KDialogBase(Swallow, i18n("Document Information"), Ok|Cancel, Ok, parent, name, true, true)
{
	KEDUCA = KEDUCAPTR;
	init();
	configRead();
}

kcontrolheader::~kcontrolheader(){}

/** Init graphical interface */
void kcontrolheader::init()
{
	QWidget *mainView = new QWidget(this);

   	QVBoxLayout *Form2Layout = new QVBoxLayout( mainView );
    Form2Layout->setSpacing( 6 );
    Form2Layout->setMargin( 0 );

    QFrame *Frame16 = new QFrame( mainView, "Frame16" );
    Frame16->setMinimumSize( QSize( 0, 50 ) );
    Frame16->setMaximumSize( QSize( 32767, 50 ) );
    Frame16->setFrameShape( QFrame::Box );
    Frame16->setFrameShadow( QFrame::Plain );
		Frame16->setPalette( QPalette( QColor(255, 255, 255) ) );
    QHBoxLayout *Frame16Layout = new QHBoxLayout( Frame16 );
    Frame16Layout->setSpacing( 6 );
    Frame16Layout->setMargin( 1 );

    QFrame *Frame17 = new QFrame( Frame16, "Frame17" );
    Frame17->setMinimumSize( QSize( 125, 0 ) );
    Frame17->setMaximumSize( QSize( 125, 32767 ) );
    Frame17->setFrameShape( QFrame::NoFrame );
    Frame17->setFrameShadow( QFrame::Raised );
		Frame17->setBackgroundPixmap( QPixmap(locate("appdata","pics/bk_frame.png") ) );
    QVBoxLayout *Frame17Layout = new QVBoxLayout( Frame17 );
    Frame17Layout->setSpacing( 6 );
    Frame17Layout->setMargin( 11 );

    QLabel *TextLabel1 = new QLabel( Frame17, "TextLabel1" );
    TextLabel1->setText( i18n( "<b>Information</b><hr>" ) );
		TextLabel1->setBackgroundPixmap( QPixmap(locate("appdata","pics/bk_frame.png") ) );
    Frame17Layout->addWidget( TextLabel1 );
    Frame16Layout->addWidget( Frame17 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Frame16Layout->addItem( spacer );

    QLabel *TextLabel2 = new QLabel( Frame16, "TextLabel2" );
    TextLabel2->setText( i18n( "Description and rules of the project. " ) );
		TextLabel2->setPalette( QPalette( QColor(255, 255, 255) ) );
    Frame16Layout->addWidget( TextLabel2 );
    Form2Layout->addWidget( Frame16 );

    QGroupBox *GroupBox7 = new QGroupBox( mainView, "GroupBox7" );
    GroupBox7->setTitle( i18n( "Description" ) );
    GroupBox7->setColumnLayout(0, Qt::Vertical );
    GroupBox7->layout()->setSpacing( 0 );
    GroupBox7->layout()->setMargin( 0 );
    QVBoxLayout *GroupBox7Layout = new QVBoxLayout( GroupBox7->layout() );
    GroupBox7Layout->setAlignment( Qt::AlignTop );
    GroupBox7Layout->setSpacing( 6 );
    GroupBox7Layout->setMargin( 11 );

    QGridLayout *Layout13 = new QGridLayout;
    Layout13->setSpacing( 6 );
    Layout13->setMargin( 0 );

    QLabel *TextLabel10 = new QLabel( GroupBox7, "TextLabel10" );
    TextLabel10->setText( i18n( "Type :" ) );
    TextLabel10->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    Layout13->addWidget( TextLabel10, 2, 0 );

    QHBoxLayout *Layout12 = new QHBoxLayout;
    Layout12->setSpacing( 6 );
    Layout12->setMargin( 0 );

    header_type = new KComboBox( FALSE, GroupBox7, "header_type" );
    Layout12->addWidget( header_type );

    QLabel *TextLabel11 = new QLabel( GroupBox7, "TextLabel11" );
    TextLabel11->setText( i18n( "Level :" ) );
    TextLabel11->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    Layout12->addWidget( TextLabel11 );

    header_level = new KComboBox( FALSE, GroupBox7, "header_level" );
    Layout12->addWidget( header_level );

    QLabel *TextLabel12 = new QLabel( GroupBox7, "TextLabel12" );
    TextLabel12->setText( i18n( "Language :" ) );
    TextLabel12->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    Layout12->addWidget( TextLabel12 );

    header_lang = new KLanguageCombo( GroupBox7, "header_lang" );
		loadCountryList( header_lang );
    Layout12->addWidget( header_lang );

    Layout13->addLayout( Layout12, 2, 1 );

    QLabel *TextLabel9 = new QLabel( GroupBox7, "TextLabel9" );
    TextLabel9->setText( i18n( "Category :" ) );
    TextLabel9->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    Layout13->addWidget( TextLabel9, 1, 0 );

    header_category = new KComboBox( true, GroupBox7, "header_category" );
    Layout13->addWidget( header_category, 1, 1 );

    header_title = new QLineEdit( GroupBox7, "header_title" );
    Layout13->addWidget( header_title, 0, 1 );

    QLabel *TextLabel8 = new QLabel( GroupBox7, "TextLabel8" );
    TextLabel8->setText( i18n( "Title :" ) );
    TextLabel8->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    Layout13->addWidget( TextLabel8, 0, 0 );
    GroupBox7Layout->addLayout( Layout13 );
    Form2Layout->addWidget( GroupBox7 );

    QGroupBox *GroupBox8 = new QGroupBox( mainView, "GroupBox8" );
    GroupBox8->setTitle( i18n( "Picture" ) );
    GroupBox8->setColumnLayout(0, Qt::Vertical );
    GroupBox8->layout()->setSpacing( 0 );
    GroupBox8->layout()->setMargin( 0 );
    QHBoxLayout *GroupBox8Layout = new QHBoxLayout( GroupBox8->layout() );
    GroupBox8Layout->setAlignment( Qt::AlignTop );
    GroupBox8Layout->setSpacing( 6 );
    GroupBox8Layout->setMargin( 11 );

    QLabel *TextLabel13 = new QLabel( GroupBox8, "TextLabel13" );
    TextLabel13->setText( i18n( "Default picture :" ) );
    GroupBox8Layout->addWidget( TextLabel13 );

    header_picture = new KURLRequester( GroupBox8, "header_picture" );
    GroupBox8Layout->addWidget( header_picture );
    Form2Layout->addWidget( GroupBox8 );

    QGroupBox *GroupBox6 = new QGroupBox( mainView, "GroupBox6" );
    GroupBox6->setTitle( i18n( "Author" ) );
    GroupBox6->setColumnLayout(0, Qt::Vertical );
    GroupBox6->layout()->setSpacing( 0 );
    GroupBox6->layout()->setMargin( 0 );
    QGridLayout *GroupBox6Layout = new QGridLayout( GroupBox6->layout() );
    GroupBox6Layout->setAlignment( Qt::AlignTop );
    GroupBox6Layout->setSpacing( 6 );
    GroupBox6Layout->setMargin( 11 );

    header_name = new QLineEdit( GroupBox6, "header_name" );

    GroupBox6Layout->addWidget( header_name, 0, 1 );

    header_email = new QLineEdit( GroupBox6, "header_email" );

    GroupBox6Layout->addWidget( header_email, 1, 1 );

    QLabel *TextLabel7 = new QLabel( GroupBox6, "TextLabel7" );
    TextLabel7->setText( i18n( "Web Page :" ) );
    TextLabel7->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    GroupBox6Layout->addWidget( TextLabel7, 2, 0 );

    QLabel *TextLabel6 = new QLabel( GroupBox6, "TextLabel6" );
    TextLabel6->setText( i18n( "Email :" ) );
    TextLabel6->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    GroupBox6Layout->addWidget( TextLabel6, 1, 0 );

    QLabel *TextLabel5 = new QLabel( GroupBox6, "TextLabel5" );
    TextLabel5->setText( i18n( "Name :" ) );
    TextLabel5->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    GroupBox6Layout->addWidget( TextLabel5, 0, 0 );

    header_www = new QLineEdit( GroupBox6, "header_www" );

    GroupBox6Layout->addWidget( header_www, 2, 1 );
    Form2Layout->addWidget( GroupBox6 );

    // tab order
    setTabOrder( header_title, header_category );
    setTabOrder( header_category, header_type );
    setTabOrder( header_type, header_level );
    setTabOrder( header_level, header_lang );
    setTabOrder( header_lang, header_picture );
    setTabOrder( header_picture, header_name );
    setTabOrder( header_name, header_email );
    setTabOrder( header_email, header_www );

		this->setMainWidget(mainView);
}

/** Insert header */
void kcontrolheader::insertHeader()
{
	QStringList tmpResult = DefaultCategories.grep( header_category->currentText() );
	if( tmpResult.count() == 0 )
		{
		KConfig *appconfig = KGlobal::config();
		DefaultCategories.append( header_category->currentText() );
	 	appconfig->setGroup("General");
		appconfig->writeEntry( "Categories", DefaultCategories);
		appconfig->sync();
		}
	KEDUCA->setHeader( "category", 	header_category->currentText() );
	KEDUCA->setHeader( "title",			header_title->text() );
	KEDUCA->setHeader( "image",			header_picture->url() );
	KEDUCA->setHeader( "type", 			QString().setNum( header_type->currentItem() + 1 ) );
	KEDUCA->setHeader( "level",			QString().setNum( header_level->currentItem() + 1 ) );
	KEDUCA->setHeader( "language",	header_lang->currentTag() );
	KEDUCA->setHeader( "name",	 		header_name->text() );
	KEDUCA->setHeader( "email", 		header_email->text() );
	KEDUCA->setHeader( "www", 			header_www->text() );
}

/** Load country list */
void kcontrolheader::loadCountryList(KLanguageCombo *combo)
{
  QString sub = QString::fromLatin1("l10n/");

  // clear the list
  combo->clear();

  QStringList regionlist = KGlobal::dirs()->findAllResources("locale", sub + QString::fromLatin1("*.desktop"));
  regionlist.sort();

  for ( QStringList::ConstIterator it = regionlist.begin();
	it != regionlist.end();
	++it )
  {
    QString tag = *it;
    int index;

    index = tag.findRev('/');
    if (index != -1) tag = tag.mid(index + 1);

    index = tag.findRev('.');
    if (index != -1) tag.truncate(index);

    KSimpleConfig entry(*it);
    entry.setGroup(QString::fromLatin1("KCM Locale"));
    QString name = entry.readEntry(QString::fromLatin1("Name"));

    combo->insertSubmenu( name, '-' + tag, sub );
  }

  // add all languages to the list
  QStringList countrylist = KGlobal::dirs()->findAllResources("locale",  sub + QString::fromLatin1("*/entry.desktop"));
  countrylist.sort();

  for ( QStringList::ConstIterator it = countrylist.begin();
	it != countrylist.end(); ++it )
    {
	KSimpleConfig entry(*it);
	entry.setGroup(QString::fromLatin1("KCM Locale"));
	QString name = entry.readEntry(QString::fromLatin1("Name"));
	QString submenu = '-' + entry.readEntry(QString::fromLatin1("Region"));

	QString tag = *it;
	int index = tag.findRev('/');
	tag.truncate(index);
	index = tag.findRev('/');
	tag = tag.mid(index+1);
	combo->insertLanguage(tag, name, sub, submenu);
		}
}

/** Ok push */
void kcontrolheader::slotOk()
{
	insertHeader();
	configWrite();
	this->accept();
}

/** Read settings */
void kcontrolheader::configRead()
{
  KConfig *config = new KConfig("emaildefaults");
	KConfig *appconfig = KGlobal::config();

  config->setGroup("UserInfo");

	if( KEDUCA->getHeader( "name" ).isEmpty() )
	  header_name->setText(config->readEntry("FullName", QString::null ));
		else
		header_name->setText( KEDUCA->getHeader("name") );

	if( KEDUCA->getHeader( "email" ).isEmpty() )
	  header_email->setText(config->readEntry("EmailAddress", QString::null ));
		else
		header_email->setText( KEDUCA->getHeader("email") );

  header_www->setText( KEDUCA->getHeader("www") );

	if( !KEDUCA->getHeader("language").isEmpty() )
	{
	header_lang->setCurrentItem( KEDUCA->getHeader("language") );
	}
	else
	{
	config->setGroup("Locale");
	header_lang->setCurrentItem( config->readEntry("Country") );
	}

	appconfig->setGroup("General");
	DefaultCategories = appconfig->readListEntry("Categories");
	if( DefaultCategories.count() == 0 )
		{
		DefaultCategories.append(i18n("Computers"));
		}
	DefaultCategories.sort();
  header_category->insertStringList( DefaultCategories );
	if( !KEDUCA->getHeader( "category" ).isEmpty() ) header_category->setEditText( KEDUCA->getHeader("category") );

	header_type->insertItem( i18n("Test") );
	if( QString(KEDUCA->getHeader("type")).toInt() > 0 ) header_type->setCurrentItem( QString(KEDUCA->getHeader("type")).toInt() -1 );

  header_level->insertItem( i18n("Easy") );
  header_level->insertItem( i18n("Normal") );
  header_level->insertItem( i18n("Expert") );
  header_level->insertItem( i18n("Supreme") );
	if( QString(KEDUCA->getHeader("level")).toInt() >0 ) header_level->setCurrentItem( QString(KEDUCA->getHeader("level")).toInt() -1 );

	header_picture->setURL( KEDUCA->getHeader("image") );
	header_title->setText( KEDUCA->getHeader("title") );

	appconfig->setGroup("kcontrolheader");
	QSize *defaultSize = new QSize(500,400);
	this->resize( appconfig->readSizeEntry("Geometry", defaultSize ) );
}

/** Write settings */
void kcontrolheader::configWrite()
{
	KConfig *config = KGlobal::config();
	config->setGroup("kcontrolheader");
	config->writeEntry("Geometry", this->size() );
	config->sync();
}
