/***************************************************************************
                            KLineEditDlg.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KLINEEDITDLG_H
#define KLINEEDITDLG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 Dialog for user to enter a single line of text.

 @author David Faure <faure@kde.org>, layout management by Preston Brown <pbrown@kde.org>
 
 @version $Id: KLineEditDlg.h,v 1.3 2002/03/15 02:12:21 rdale Exp $

 @short 
 Dialog for user to enter a single line of text.
*/
@class KLineEdit; 
@class QValidator; 

@interface KLineEditDlg : KDialogBase 

/** 
 Create a dialog that asks for a single line of text. _value is
 the initial value of the line. _text appears as label on top of
 the entry box. If the internal line edit has an associated @ref
 QValidator set, the OK button is disabled as long as the
 validator doesn't return Acceptable. If there's no validator, the
 OK button is enabled whenever the line edit isn't empty.

 If you want to accept empty input, make a trivial QValidator that
 always returns Acceptable, e.g. @ref QRegExpValidator with a
 regexp of ".*".

*/
- initWithText: (NSString *)_text _value: (NSString *)_value parent: (QWidget *)parent;
- (void) dealloc;

/** 

*/
- (NSString *) text;

/** 

*/
- (KLineEdit*) lineEdit;

/** 
 Clears the edit widget
   
*/
- slotClear;

/** 
 Static convenience function to get a textual input from the user.

*/
+ (NSString *) getText: (NSString *)_text _value: (NSString *)_value ok: (int*)ok parent: (QWidget *)parent validator: (QValidator *)validator;

/** 
 Static convenience function to get a textual input from the user.
 This method includes a caption, and has (almost) the same API as -[QInputDialog getText](no echo mode, we have KPasswordDialog).

*/
+ (NSString *) getText: (NSString *)_caption _text: (NSString *)_text _value: (NSString *)_value ok: (int*)ok parent: (QWidget *)parent validator: (QValidator *)validator;

/**  
 Enables and disables the OK button depending on the state
 returned by the lineedit's @ref QValidator.
   
*/
- slotTextChanged: (NSString *)arg1;
@end

/** Override these methods in subclasses of KLineEditDlg to customise event handling behaviour */
@protocol KLineEditDlgEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
