/***************************************************************************
                            KInstance.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KINSTANCE_H
#define KINSTANCE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Access to KDE global objects for use in shared libraries.  In
 practical terms, this class is used in KDE components.  This allows
 components to store things that normally would be accessed by
 @ref KGlobal.

 @author Torben Weis

 @version $Id: KInstance.h,v 1.3 2002/03/15 02:12:21 rdale Exp $
 
 @short 
 Access to KDE global objects for use in shared libraries.
*/

@class KAboutData;
@class KCharsets;
@class KConfig;
@class KIconLoader;
@class KStandardDirs;

@protocol KInstanceInterface

/** 
  Returns the application standard dirs object.
     
*/
- (KStandardDirs*) dirs;

/** 
  Returns the general config object.
     
*/
- (KConfig*) config;

/** 
  Returns an iconloader object.
     
*/
- (KIconLoader*) iconLoader;

/** 
 Re-allocate the global iconloader.
     
*/
- newIconLoader;
//- (KCharsets*) charsets;

/** 
  Returns the about data of this instance
  Warning, can be 0L
     
*/
- (KAboutData*) aboutData;

/** 

*/
- (NSString *) instanceName;

/** 

 Mainly added for API completeness and future extensibility.
     
*/
//- (KMimeSourceFactory*) mimeSourceFactory;

@end

@interface KInstance : NSObject <QtSupport,KInstanceInterface>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/**
  Constructor

*/
- initWithText: (NSString *)instanceName;

/**
  Constructor

  When building a KInstance that is not your KApplication,
  make sure that the KAboutData and the KInstance have the same life time.
  You have to destroy both, since the instance doesn't own the about data.
  Don't build a KAboutData on the stack in this case !
  Building a KAboutData on the stack is only ok for usage with
  KCmdLineArgs and KApplication (not destroyed until the app exits).

*/
- initWithAboutData: (KAboutData*)aboutData;
- copyWithZone: (NSZone *) zone;

/**
 Destructor.

*/
- (void) dealloc;


@end

#endif
