/***************************************************************************
                            KFilePreview.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEPREVIEW_H
#define KFILEPREVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KFileView.h>
#include <qtobjc/QSplitter.h>

@class KURL;

@class KActionCollection; 
@class KFileItem; 

@class KFileViewSignaler; 

@interface KFilePreview : QSplitter 
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- initWithFileView: (KFileView*)view parent: (QWidget *)parent name: (NSString *)name;
- (void) dealloc;
- (QWidget*) widget;
- clearView;

/** 
 Delets the current view and sets the view to the given @p view.
 The view is reparented to have this as parent, if necessary.
     
*/
- setFileView: (KFileView*)view;

/** 

*/
- (KFileView*) fileView;
- updateView: (BOOL)arg1;
- updateFileView: (KFileItem*)arg1;
- removeFileItem: (KFileItem*)arg1;
- listingCompleted;
- setSelectionMode: (int)sm;
- setSelected: (KFileItem*)arg1 bool: (BOOL)arg2;
- (BOOL) isSelected: (KFileItem*)arg1;
- clearSelection;
- selectAll;
- invertSelection;
- insertFileItem: (KFileItem*)arg1;
- clear;
- setCurrentItem: (KFileItem*)arg1;
- (KFileItem*) currentFileItem;
- (KFileItem*) firstFileItem;
- (KFileItem*) nextItem: (KFileItem*)arg1;
- (KFileItem*) prevItem: (KFileItem*)arg1;
- setSorting: (int)sort;
- ensureItemVisible: (KFileItem*)arg1;
- setPreviewWidget: (QWidget *)w u: (KURL*)u;
- slotHighlighted: (KFileItem*)arg1;
@end

@class KFileViewItem; 
@class KURL; 

@class KActionCollection; 
@class KFileItem; 

@class KFileViewSignaler; 

@interface KFilePreview (KFileViewImplementation) <KFileViewInterface>
@end

/** Override these methods in subclasses of KFilePreview to customise event handling behaviour */
@protocol KFilePreviewEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
