/***************************************************************************
                            KCrash.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCRASH_H
#define KCRASH_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This class handles segmentation-faults.
 By default it displays a  message-box saying the application crashed.
 This default can be overridden by setting a custom crash handler with
 @ref -setCrashHandler.
 If a function is specified with @ref -setEmergencySaveFunction it will
 be called by the default crash handler, giving the application a chance
 to save its data.
 
 @short 
 This class handles segmentation-faults.
*/

@interface  KCrash : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
//- (typedef) void: (* HandlerType)(int)arg1;
+ defaultCrashHandler: (int)signal;

/** 
 Install a function to be called in case a SIGSEGV is caught.

*/
//+ setCrashHandler: (HandlerType*)handler;
//+ setCrashHandler;

/** 
 Returns the installed crash handler
   
*/
//+ (HandlerType*) crashHandler;

/** 
 Installs a function which should try to save the applications data.
 It is the crash handlers responsibility to call this function.
 Therefore, if no crash handler is set, the default crash handler
 is installed to ensure the save function is called.
   
*/
//+ setEmergencySaveFunction: (HandlerType saveFunction)0;
//+ setEmergencySaveFunction;

/** 
 Return the currently set emergency save function.
   
*/
//+ (HandlerType*) emergencySaveFunction;

/** 
 Sets the application path @p path which should be passed to
 Dr. Konqi, our nice crash display application.
   
*/
+ setApplicationPath: (NSString *)path;

/** 
 Sets the application name @p name which should be passed to
 Dr. Konqi, our nice crash display application.
   
*/
+ setApplicationName: (NSString *)name;
@end

#endif
