/***************************************************************************
                            KDockManager.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The manager that knows all dockwidgets and handles the dock process (and member of the dockwidget class set).
 More or less a helper class for the KDockWidget class set but of interest for some functionality
 that can be called within a {@link KDockMainWindow} or a {@link KDockWidget} .

 An important feature is the ability to read or save the current state of all things concerning to
 dockwidgets to {@link KConfig} .

 The dockmanager is also often used when a certain dockwidget or a child of such dockwidget must be found.

 See {@link KDockManagerSignals} for signals emitted by KDockManager.

 See {@link KDockManagerEventHandling} for event handlers to override in subclasses of KDockManager.

 @author Max Judin (documentation: Falk Brettschneider).
 
 @short 
 The manager that knows all dockwidgets and handles the dock process (and member of the dockwidget class set).
*/
public class KDockManager extends QObject  {
	protected KDockManager(Class dummy){super((Class) null);}

	private native void newKDockManager( QWidget mainWindow, String name);

/** 
 Constructs a dockmanager. Some initialization happen:

*/
	public KDockManager( QWidget mainWindow, String name) {
		super((Class) null);
		newKDockManager( mainWindow, name);
	}
	private native void newKDockManager( QWidget mainWindow);
	public KDockManager( QWidget mainWindow) {
		super((Class) null);
		newKDockManager( mainWindow);
	}

/** 
 Destructs a dockmanager.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Saves the current state of the dockmanager and of all controlled widgets.
 State means here to save the geometry, visibility, parents, internal object names, orientation,
 separator positions, dockwidget-group information, tab widget states (if it is a tab group) and
 last but not least some necessary things for recovering the dockmainwindow state.

*/
	public native void writeConfig( KConfig c, String group);
	public native void writeConfig();

/** 
 Like writeConfig but reads the whole stuff in.

 In order to restore a window configuration
 from a config file, it looks up widgets by name
 (QObject.name) in the childDock variable of
 KDockManager. This list in turn contains all
 KDockWidgets (according to the KDockWidget constructor).
 So in principle, in order to restore a window layout,
 one must first construct all widgets, put each of them in a
 KDockWidget and then call readConfig(). And for all that
 to work, each widget must have a unique name.

*/
	public native void readConfig( KConfig c, String group);
	public native void readConfig();

/** 
 Saves the current dock window layout into a DOM tree below the given element.
   
*/
	public native void writeConfig( QDomElement base);

/** 
 Reads the current dock window layout from a DOM tree below the given element.
   
*/
	public native void readConfig( QDomElement base);

/** 
 Shows all encapsulated widgets of all controlled dockwidgets and shows all dockwidgets which are
 parent of a dockwidget tab group.
   
*/
	public native void activate();

/** 
 It's more or less a method that catches several events which are interesting for the dockmanager.
 Mainly mouse events during the drag process of a dockwidgets are of interest here.

*/
	public native boolean eventFilter( QObject arg1, QEvent arg2);

/** 
 This method finds out what a widgets' dockwidget is. That means the dockmanager has a look at all
 dockwidgets it knows and tells you when one of those dockwidgets covers the given widget.

*/
	public native KDockWidget findWidgetParentDock( QWidget w);

/** 
 Works like makeDockVisible() but can be called for widgets that covered by a dockwidget.

*/
	public native void makeWidgetDockVisible( QWidget w);

/** 

*/
	public native QPopupMenu dockHideShowMenu();

/** 

*/
	public native KDockWidget getDockWidgetFromName( String dockName);

/** 
 Enables opaque resizing. Opaque resizing is initially turned off.
 Call this method before you create any dock widgets!   
   
*/
	public native void setSplitterOpaqueResize( boolean b);
	public native void setSplitterOpaqueResize();

/** 
 Returns TRUE if opaque resizing is enabled, FALSE otherwise.
   
*/
	public native boolean splitterOpaqueResize();

/** 
 Try to preserve the widget's size. Works like KeepSize resize mode
 of QSplitter. Off by default.
 Call this method before you create any dock widgets!
   
*/
	public native void setSplitterKeepSize( boolean b);
	public native void setSplitterKeepSize();

/** 
 Returns TRUE if the KeepSize is enabled, FALSE otherwise.
   
*/
	public native boolean splitterKeepSize();

/** 
 Operate the splitter with a higher resolution. Off by default.
 Call this method before you create any dock widgets!
 If high resolution is used all splitter position parameters
 are percent100 instead of percent.
   
*/
	public native void setSplitterHighResolution( boolean b);
	public native void setSplitterHighResolution();

/** 
 Returns TRUE if the splitter uses the high resolution, FALSE otherwise.
   
*/
	public native boolean splitterHighResolution();
}
