/***************************************************************************
                            KSocket.cpp -  description
                             -------------------
    begin                : Fri Mar 15 15:14:30 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar 15 15:14:30 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

#define _BOOL_H_
#include <ksock.h>
#include <qstring.h>
#include <qcstring.h>

#include <qtjava/QtSupport.h>
#include <kdejava/KDESupport.h>
#include <kdejava/KSocket.h>

class KSocketJBridge : public KSocket
{
public:
	KSocketJBridge(int _sock) : KSocket(_sock) {}
	KSocketJBridge(const char* _host, unsigned short int _port, int timeOut) : KSocket(_host, _port, timeOut) {}
	KSocketJBridge(const char* _path) : KSocket(_path) {}
	~KSocketJBridge() {QtSupport::qtKeyDeleted(this);}
	bool  protected_connect(const QString& _host, unsigned short int _port, int timeout) {
		return (bool ) KSocket::connect(_host, _port, timeout);
	}
	bool  protected_connect(const char* _path) {
		return (bool ) KSocket::connect(_path);
	}
	void childEvent(QChildEvent* arg1) {
		if (! QtSupport::eventDelegate(this, "childEvent", arg1, "org.kde.qt.QChildEvent")) {
			QObject::childEvent(arg1);
		}
		return;
	}
	void customEvent(QCustomEvent* arg1) {
		if (! QtSupport::eventDelegate(this, "customEvent", arg1, "org.kde.qt.QCustomEvent")) {
			QObject::customEvent(arg1);
		}
		return;
	}
	void timerEvent(QTimerEvent* arg1) {
		if (! QtSupport::eventDelegate(this, "timerEvent", arg1, "org.kde.qt.QTimerEvent")) {
			QObject::timerEvent(arg1);
		}
		return;
	}
};


JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_newKSocket__I(JNIEnv *env, jobject obj, jint _sock)
{
	if (QtSupport::getQt(env, obj) == 0) {
		QtSupport::setQt(env, obj, new KSocketJBridge((int) _sock));
		QtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));
	}
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_newKSocket__Ljava_lang_String_2SI(JNIEnv *env, jobject obj, jstring _host, jshort _port, jint timeOut)
{
static QCString * _qstring__host = 0;
	if (QtSupport::getQt(env, obj) == 0) {
		QtSupport::setQt(env, obj, new KSocketJBridge((char*) QtSupport::toCharString(env, _host, &_qstring__host), (unsigned short int) _port, (int) timeOut));
		QtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));
	}
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_newKSocket__Ljava_lang_String_2S(JNIEnv *env, jobject obj, jstring _host, jshort _port)
{
static QCString * _qstring__host = 0;
	if (QtSupport::getQt(env, obj) == 0) {
		QtSupport::setQt(env, obj, new KSocketJBridge((char*) QtSupport::toCharString(env, _host, &_qstring__host), (unsigned short int) _port, 30));
		QtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));
	}
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_newKSocket__Ljava_lang_String_2(JNIEnv *env, jobject obj, jstring _path)
{
static QCString * _qstring__path = 0;
	if (QtSupport::getQt(env, obj) == 0) {
		QtSupport::setQt(env, obj, new KSocketJBridge((char*) QtSupport::toCharString(env, _path, &_qstring__path)));
		QtSupport::setObjectForQtKey(env, obj, QtSupport::getQt(env, obj));
	}
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_finalize(JNIEnv *env, jobject obj)
{
	if (QtSupport::allocatedInJavaWorld(env, obj) && ((KSocket*)QtSupport::getQt(env, obj))->parent() == (QObject *) 0) {
		delete (KSocket*)QtSupport::getQt(env, obj);
		QtSupport::setQt(env, obj, 0);
	}
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_dispose(JNIEnv *env, jobject obj)
{
	Java_org_kde_koala_KSocket_finalize(env, obj);
	return;
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KSocket_isDisposed(JNIEnv *env, jobject obj)
{
	return (QtSupport::getQt(env, obj) == 0);
}

JNIEXPORT jint JNICALL
Java_org_kde_koala_KSocket_socket(JNIEnv *env, jobject obj)
{
	return (jint) ((KSocket*) QtSupport::getQt(env, obj))->socket();
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_enableRead(JNIEnv *env, jobject obj, jboolean arg1)
{
	((KSocket*) QtSupport::getQt(env, obj))->enableRead((bool) arg1);
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_enableWrite(JNIEnv *env, jobject obj, jboolean arg1)
{
	((KSocket*) QtSupport::getQt(env, obj))->enableWrite((bool) arg1);
	return;
}

//JNIEXPORT jlong JNICALL
//Java_org_kde_koala_KSocket_ipv4_addr(JNIEnv *env, jobject obj)
//{
//	return (jlong) ((KSocket*) QtSupport::getQt(env, obj))->ipv4_addr();
//}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_slotWrite(JNIEnv *env, jobject obj, jint arg1)
{
	((KSocket*) QtSupport::getQt(env, obj))->slotWrite((int) arg1);
	return;
}

JNIEXPORT void JNICALL
Java_org_kde_koala_KSocket_slotRead(JNIEnv *env, jobject obj, jint arg1)
{
	((KSocket*) QtSupport::getQt(env, obj))->slotRead((int) arg1);
	return;
}

//JNIEXPORT jboolean JNICALL
//Java_org_kde_koala_KSocket_initSockaddr__ILjava_lang_String_2SI(JNIEnv *env, jclass obj, jint server_name, jstring hostname, jshort port, jint domain)
//{
//static QCString * _qstring_hostname = 0;
//	return (jboolean) KSocketJBridge::initSockaddr((ksockaddr_in*) server_name, (char*) QtSupport::toCharString(env, hostname, &_qstring_hostname), (unsigned short int) port, (int) domain);
//}

//JNIEXPORT jboolean JNICALL
//Java_org_kde_koala_KSocket_initSockaddr__ILjava_lang_String_2S(JNIEnv *env, jclass obj, jint server_name, jstring hostname, jshort port)
//{
//static QCString * _qstring_hostname = 0;
//	return (jboolean) KSocketJBridge::initSockaddr((ksockaddr_in*) server_name, (char*) QtSupport::toCharString(env, hostname, &_qstring_hostname), (unsigned short int) port, KSocket::PF_INET);
//}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KSocket_connect__Ljava_lang_String_2SI(JNIEnv *env, jobject obj, jstring _host, jshort _port, jint timeout)
{
static QString * _qstring__host = 0;
	return (jboolean) ((KSocketJBridge*) QtSupport::getQt(env, obj))->protected_connect((QString&) * (QString *) QtSupport::toQString(env, _host, &_qstring__host), (unsigned short int) _port, (int) timeout);
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KSocket_connect__Ljava_lang_String_2S(JNIEnv *env, jobject obj, jstring _host, jshort _port)
{
static QString * _qstring__host = 0;
	return (jboolean) ((KSocketJBridge*) QtSupport::getQt(env, obj))->protected_connect((QString&) * (QString *) QtSupport::toQString(env, _host, &_qstring__host), (unsigned short int) _port, 0);
}

JNIEXPORT jboolean JNICALL
Java_org_kde_koala_KSocket_connect__Ljava_lang_String_2(JNIEnv *env, jobject obj, jstring _path)
{
static QCString * _qstring__path = 0;
	return (jboolean) ((KSocketJBridge*) QtSupport::getQt(env, obj))->protected_connect((char*) QtSupport::toCharString(env, _path, &_qstring__path));
}

