/***************************************************************************
                            kde_KMacroCommand.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KMACROCOMMAND
#define KDE_KMACROCOMMAND

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A Macro Command is a command that holds several sub-commands.
 It will appear as one to the user and in the command history,
 but it can use the implementation of multiple commands internally.
 
 @short 
 A Macro Command is a command that holds several sub-commands.
*/

/** 
 Creates a macro command. You will then need to call @ref addCommand
 for each subcommand to be added to this macro command.

*/
kde_KMacroCommand * kde_new_KMacroCommand(qt_QString * name);
void kde_del_KMacroCommand( kde_KMacroCommand* p );

/** 
 Appends a command to this macro command.
 The ownership is transfered to the macro command.
     
*/
void kde_KMacroCommand_addCommand(kde_KMacroCommand* instPointer,kde_KCommand* command);

/** 
 Executes this command, i.e. execute all the sub-commands
 in the order in which they were added.
     
*/
void kde_KMacroCommand_execute(kde_KMacroCommand* instPointer);

/** 
 Undoes the execution of this command, i.e. unexecute all the sub-commands
 in the _reverse_ order to the one in which they were added.
     
*/
void kde_KMacroCommand_unexecute(kde_KMacroCommand* instPointer);

#endif
