/***************************************************************************
                            kde_KConfigBackEnd.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCONFIGBACKEND
#define KDE_KCONFIGBACKEND

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Abstract base class for KDE configuration file loading/saving.

 This class forms the base for all classes that implement some
 manner of loading/saving to configuration files.  It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. As of right now, the only back end available
 is one to read/write to INI-style files, but in the future, other
 formats may be available, such as XML or a database.

 @author Preston Brown <pbrown@kde.org>, 
         Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: kde_KConfigBackEnd.h,v 1.3 2002/02/21 00:43:09 rdale Exp $

 @short KDE Configuration file loading/saving abstract base class.
*/

/** 
 Destructs the configuration backend.
   
*/
void kde_del_KConfigBackEnd( kde_KConfigBackEnd* p );

/** 
 Parses all configuration files for a configuration object.  This
 method must be reimplemented by the derived classes.

*/
int kde_KConfigBackEnd_parseConfigFiles(kde_KConfigBackEnd* instPointer);

/** 
 Writes configuration data to file(s).  This method must be
 reimplemented by the derived classes.

*/
void kde_KConfigBackEnd_sync(kde_KConfigBackEnd* instPointer,int bMerge);

/** 
 Changes the filenames associated with this back end.  You should
 probably reparse your config info after doing this.

*/
void kde_KConfigBackEnd_changeFileName(kde_KConfigBackEnd* instPointer,qt_QString * _fileName, char* _resType, int _useKDEGlobals);

/** 
 Returns the state of the app-config object.

*/
//kde_KConfigBase_ConfigState kde_KConfigBackEnd_getConfigState(kde_KConfigBackEnd* instPointer);

/** 

*/
qt_QString * kde_KConfigBackEnd_fileName(kde_KConfigBackEnd* instPointer);

/** 

*/
char* kde_KConfigBackEnd_resource(kde_KConfigBackEnd* instPointer);
void kde_KConfigBackEnd_setLocaleString(kde_KConfigBackEnd* instPointer,qt_QCString* _localeString);

#endif
