/***************************************************************************
                            kde_HTMLElement.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLELEMENT
#define KDE_HTMLELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 All HTML element interfaces derive from this class. Elements that
 only expose the HTML core attributes are represented by the base
 <code> HTMLElement </code> interface. These elements are as
 follows:

  <ulist> <item> HEAD

  </item> <item> special: SUB, SUP, SPAN, BDO

  </item> <item> font: TT, I, B, U, S, STRIKE, BIG, SMALL

  </item> <item> phrase: EM, STRONG, DFN, CODE, SAMP, KBD, VAR,
 CITE, ACRONYM, ABBR

  </item> <item> list: DD, DT

  </item> <item> NOFRAMES, NOSCRIPT

  </item> <item> ADDRESS, CENTER

  </item> </ulist> Note. The <code> style </code> attribute for this
 interface is reserved for future usage.

 
 @short 
 All HTML element interfaces derive from this class.
*/
kde_HTMLElement * kde_new_HTMLElement();
kde_HTMLElement * kde_new_HTMLElement1(kde_HTMLElement* other);
kde_HTMLElement * kde_new_HTMLElement2(kde_DOMNode* other);
void kde_del_HTMLElement( kde_HTMLElement* p );

/** 
 The element's identifier. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-id">
 id attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLElement_id(kde_HTMLElement* instPointer);

/** 
 see @ref id
     
*/
void kde_HTMLElement_setId(kde_HTMLElement* instPointer,kde_DOMString* arg1);

/** 
 The element's advisory title. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-title">
 title attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLElement_title(kde_HTMLElement* instPointer);

/** 
 see @ref title
     
*/
void kde_HTMLElement_setTitle(kde_HTMLElement* instPointer,kde_DOMString* arg1);

/** 
 Language code defined in RFC 1766. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/dirlang.html#adef-lang">
 lang attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLElement_lang(kde_HTMLElement* instPointer);

/** 
 see @ref lang
     
*/
void kde_HTMLElement_setLang(kde_HTMLElement* instPointer,kde_DOMString* arg1);

/** 
 Specifies the base direction of directionally neutral text and
 the directionality of tables. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/dirlang.html#adef-dir">
 dir attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLElement_dir(kde_HTMLElement* instPointer);

/** 
 see @ref dir
     
*/
void kde_HTMLElement_setDir(kde_HTMLElement* instPointer,kde_DOMString* arg1);

/** 
 The class attribute of the element. This attribute has been
 renamed due to conflicts with the "class" keyword exposed by
 many languages. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.html#adef-class">
 class attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLElement_className(kde_HTMLElement* instPointer);

/** 
 see @ref className
     
*/
void kde_HTMLElement_setClassName(kde_HTMLElement* instPointer,kde_DOMString* arg1);

/** 
 The HTML code contained in this element.
 This function is not part of the DOM specifications as defined by the w3c.
     
*/
kde_DOMString* kde_HTMLElement_innerHTML(kde_HTMLElement* instPointer);

/** 
 Set the HTML content of this node.

*/
void kde_HTMLElement_setInnerHTML(kde_HTMLElement* instPointer,kde_DOMString* html);

/** 
 The text contained in this element.
 This function is not part of the DOM specifications as defined by the w3c.
     
*/
kde_DOMString* kde_HTMLElement_innerText(kde_HTMLElement* instPointer);

/** 
 Set the text content of this node.

*/
void kde_HTMLElement_setInnerText(kde_HTMLElement* instPointer,kde_DOMString* text);

/** 
 Retrieves a collection of nodes that are direct descendants of this node.
 IE-specific extension.
     
*/
kde_HTMLCollection* kde_HTMLElement_children(kde_HTMLElement* instPointer);
void kde_HTMLElement_removeCSSProperty(kde_HTMLElement* instPointer,kde_DOMString* property);
void kde_HTMLElement_addCSSProperty(kde_HTMLElement* instPointer,kde_DOMString* property, kde_DOMString* value);

#endif
