/***************************************************************************
                          glowbutton.h  -  description
                             -------------------
    begin                : Thu Sep 14 2001
    copyright            : (C) 2001 by Henning Burchardt
    email                : h_burchardt@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GLOW_BUTTON_H
#define GLOW_BUTTON_H

#include <vector>
#include <map>
#include <kwin/kwinbutton.h>

class QPixmap;
class QBitmap;
class QTimer;
class QString;

class PixmapCache
{
public:
	static QPixmap* find(const QString& key);
	static void insert(const QString& key, QPixmap *pixmap);
	static void clear();
private:
	static std::map<QString, QPixmap*> m_pixmapMap;
};

namespace KWinInternal
{

//-----------------------------------------------------------------------------

class GlowButton : public KWinWidgetButton
{
	Q_OBJECT

public:
	GlowButton(QWidget *parent, const char* name,const QString& tip);
	~GlowButton();

	QString getPixmapName() const;

	/** Sets the name of the pixmap in the pixmap cache.
	 * If not background pixmap is wanted use QString::null as name. */
	void setPixmapName(const QString& pixmapName);

protected:
	virtual void paintEvent( QPaintEvent * );
	virtual void enterEvent( QEvent * );
	virtual void leaveEvent( QEvent * );
	virtual void mousePressEvent( QMouseEvent * );
	virtual void mouseReleaseEvent( QMouseEvent * );

protected slots:
	void slotTimeout();

private:
	enum TimerStatus { Run, Stop };

	int m_updateTime;
	int m_steps;
	QString m_pixmapName;

	QTimer *m_timer;
	int m_pos;
	TimerStatus m_timerStatus;

signals:
	void clicked();
	void clicked(int button);
};

//-----------------------------------------------------------------------------

class GlowButtonFactory
{
public:
	GlowButtonFactory();

	int getSteps();

	/**
	 * Sets the number of pixmaps used to create the glow effect of the
	 * glow buttons.
	 */
	void setSteps(int steps);

	QPixmap* createGlowButtonPixmap(
		const QSize& size, const QColor& glowColor,
		const QColorGroup& colorGroup, const QPixmap& fgPixmap );
	/**
	 * Creates a background pixmap for a glow button.
	 * The pixmap will consist of sub pixmaps of the size of the button which
	 * are placed one below the other. Each sub pixmap is copied on the button
	 * in succession to create the glow effect. The last sub pixmap is used
	 * when the button is pressed.
	 */
	QPixmap* createGlowButtonPixmap(
		const QSize& size, const QPixmap& glowPixmap,
		const QColorGroup& colorGroup, const QPixmap& fgPixmap );
	GlowButton* createGlowButton(
		QWidget *parent, const char* name, const QString& tip);

private:
	int m_steps;
};

//-----------------------------------------------------------------------------

class DrawUtils
{
public:
	static QPixmap fadePixmaps(
		const QPixmap& bgPixmap, const QPixmap& glowPixmap,
		const std::vector< std::vector<float> >& intensityField, float intensity );
	static QImage &drawLightEffect(
		const QImage& image, const QRect& location, float intensity=1.0 );
	static QPixmap drawRoundButton(
		const QSize& size, const QColorGroup& group);
	static QBitmap drawRoundButtonMask(const QSize& size);
	static QPixmap drawRoundRectButton(
		const QSize& size, const QColorGroup& group);
	static QBitmap drawRoundRectButtonMask(const QSize& size);
};

}; // namespace

#endif
