/* vi:set ts=8 sts=0 sw=8:
 * $Id: htmltags.h,v 1.13 2000/02/21 17:49:25 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __HTMLTAGS_H__
#define __HTMLTAGS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdio.h>
#include "win.h"

#ifdef USE_HTMLTAGS

typedef enum {
	HtmlAbbr,
	HtmlAcro,
	HtmlAddress,
	HtmlArea,
	HtmlApplet,
	HtmlBase,
	HtmlBaseFont,
	HtmlBdo,
	HtmlBig,
	HtmlBlkQuote,
	HtmlBody,
	HtmlBold,
	HtmlButton,
	HtmlCaption,
	HtmlCent,
	HtmlCite,
	HtmlCmnt,
	HtmlCode,
	HtmlCol,
	HtmlColGrp,
	HtmlDef,	/* Definition */
	HtmlDefList,	/* Definition List */
	HtmlDefTerm,	/* Definition Term */
	HtmlDel,
	HtmlDfn,
	HtmlDir,
	HtmlDiv,
	HtmlDocType,
	HtmlEmph,
	HtmlFieldSet,
	HtmlFont,
	HtmlFontM,	/* font size -1 */
	HtmlFontP,	/* font size +1 */
	HtmlFormBtn,
	HtmlFormChk,
	HtmlFormFile,
	HtmlFormHid,
	HtmlFormImg,
	HtmlFormInput,
	HtmlFormNew,
	HtmlFormOpt,
	HtmlFormPass,
	HtmlFormRadio,
	HtmlFormReset,
	HtmlFormSel,
	HtmlFormSubmit,
	HtmlFormTarea,
	HtmlFormTfield,
	HtmlFrameBase,
	HtmlFrameI,
	HtmlFrameNew,
	HtmlFrameNo,
	HtmlFrameSet,
	HtmlH1,
	HtmlH2,
	HtmlH3,
	HtmlH4,
	HtmlH5,
	HtmlH6,
	HtmlHead,
	HtmlHtml,
	HtmlImg,
	HtmlIns,
	HtmlIsIdx,
	HtmlItal,
	HtmlKbd,
	HtmlLabel,
	HtmlLbrk,	/* Line Break */
	HtmlLeft,
	HtmlLegend,
	HtmlLink,
	HtmlLinkReal,
	HtmlLitm,	/* List Item */
	HtmlMap,
	HtmlMeta,
	HtmlMenu,
	HtmlNoScript,
	HtmlObject,
	HtmlOptGrp,
	HtmlOrdr,	/* Ordered List */
	HtmlPara,
	HtmlParam,
	HtmlPre,
	HtmlQ,
	HtmlRght,
	HtmlSamp,
	HtmlScript,
	HtmlSep,
	HtmlSmll,
	HtmlSpan,
	HtmlStrg,
	HtmlStrike,
	HtmlStrk,
	HtmlStyle,
	HtmlSub,
	HtmlSup,
	HtmlTarg,
	HtmlTblData,
	HtmlTblHdr,
	HtmlTblNew,
	HtmlTblRow,
	HtmlTbody,
	HtmlTfoot,
	HtmlThead,
	HtmlTtl,
	HtmlTty,	/* Typewriter */
	HtmlUlne,	/* Underline */
	HtmlUord,	/* Unordered List */
	HtmlVar,
	HtmlNONE
} html_action_t;


extern void html_tag_chooser_cb(GtkWidget *wgt, gpointer cbdata);
extern void html_tag_lower(GtkWidget *wgt, gpointer cbdata);
extern void html_tag_upper(GtkWidget *wgt, gpointer cbdata);

#ifdef USE_TOOLBARS
extern GtkWidget *html_tb_create(win_t *w);
#endif
#if defined(GTK_HAVE_FEATURES_1_1_0) && !defined(USE_GNOME)
extern void html_menu_cb(GtkWidget *wgt, gpointer cbdata, guint cbaction);
#endif
#if defined(USE_GNOME) || !defined(GTK_HAVE_FEATURES_1_1_0)
extern void html_fontp1_cb(GtkWidget *widget, gpointer cbdata);
extern void html_fontm1_cb(GtkWidget *widget, gpointer cbdata);
extern void html_preformatted_cb(GtkWidget *widget, gpointer cbdata);
extern void html_deflist_cb(GtkWidget *widget, gpointer cbdata);
extern void html_defterm_cb(GtkWidget *widget, gpointer cbdata);
extern void html_def_cb(GtkWidget *widget, gpointer cbdata);
extern void html_menu_cb(GtkWidget *widget, gpointer cbdata);
extern void html_tablenew_cb(GtkWidget *widget, gpointer cbdata);
extern void html_tablerow_cb(GtkWidget *widget, gpointer cbdata);
extern void html_tablehdr_cb(GtkWidget *widget, gpointer cbdata);
extern void html_tabledata_cb(GtkWidget *widget, gpointer cbdata);
extern void html_framenew_cb(GtkWidget *widget, gpointer cbdata);
extern void html_frameset_cb(GtkWidget *widget, gpointer cbdata);
extern void html_framebase_cb(GtkWidget *widget, gpointer cbdata);
extern void html_frameno_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formnew_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formtfield_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formpasswd_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formtarea_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formselect_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formoption_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formradio_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formchkbox_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formbutton_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formimage_cb(GtkWidget *widget, gpointer cbdata);
extern void html_formsubmit_cb(GtkWidget *widget, gpointer cbdata);
extern void html_title_cb(GtkWidget *widget, gpointer cbdata);
extern void html_comment_cb(GtkWidget *widget, gpointer cbdata);
extern void html_link_cb(GtkWidget *widget, gpointer cbdata);
extern void html_target_cb(GtkWidget *widget, gpointer cbdata);
extern void html_image_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h1_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h2_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h3_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h4_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h5_cb(GtkWidget *widget, gpointer cbdata);
extern void html_h6_cb(GtkWidget *widget, gpointer cbdata);
extern void html_left_cb(GtkWidget *widget, gpointer cbdata);
extern void html_center_cb(GtkWidget *widget, gpointer cbdata);
extern void html_right_cb(GtkWidget *widget, gpointer cbdata);
extern void html_paragraph_cb(GtkWidget *widget, gpointer cbdata);
extern void html_linebreak_cb(GtkWidget *widget, gpointer cbdata);
extern void html_separator_cb(GtkWidget *widget, gpointer cbdata);
extern void html_bold_cb(GtkWidget *widget, gpointer cbdata);
extern void html_italic_cb(GtkWidget *widget, gpointer cbdata);
extern void html_underline_cb(GtkWidget *widget, gpointer cbdata);
extern void html_typewriter_cb(GtkWidget *widget, gpointer cbdata);
extern void html_strikeout_cb(GtkWidget *widget, gpointer cbdata);
extern void html_emphasis_cb(GtkWidget *widget, gpointer cbdata);
extern void html_strong_cb(GtkWidget *widget, gpointer cbdata);
extern void html_subscript_cb(GtkWidget *widget, gpointer cbdata);
extern void html_superscript_cb(GtkWidget *widget, gpointer cbdata);
extern void html_big_cb(GtkWidget *widget, gpointer cbdata);
extern void html_small_cb(GtkWidget *widget, gpointer cbdata);
extern void html_ordered_cb(GtkWidget *widget, gpointer cbdata);
extern void html_unordered_cb(GtkWidget *widget, gpointer cbdata);
extern void html_listitem_cb(GtkWidget *widget, gpointer cbdata);
#endif	/* defined(USE_GNOME) || !defined(GTK_HAVE_FEATURES_1_1_0) */

#endif	/* USE_HTMLTAGS */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __HTMLTAGS_H__ */
