/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateStore;
import sun.plugin.usability.Trace;
import sun.plugin.usability.UserProfile;

public class RootCACertificateStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _cacerts = null;

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.loading") + _filename, 2);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (RootCACertificateStore.this._cacerts == null) {
                        RootCACertificateStore.this._cacerts = KeyStore.getInstance("JKS");
                        RootCACertificateStore.this._cacerts.load(null, null);
                    }
                    if ((file = new File(_filename)).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        RootCACertificateStore.this._cacerts.load(bufferedInputStream, null);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    } else {
                        Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.noload") + _filename, 2);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.loaded") + _filename, 2);
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.saving") + _filename, 2);
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.adding"), 2);
        throw new KeyStoreException("Cannot add root CA certificate");
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.removing"), 2);
        throw new KeyStoreException("Cannot remove root CA certificate");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.instore"), 2);
        return false;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.canverify"), 2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Certificate to be verified:\n");
        stringBuffer.append(certificate.toString());
        Trace.securityPrintln(stringBuffer.toString(), 2);
        Enumeration<String> enumeration = this._cacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate2 = this._cacerts.getCertificate(string);
            stringBuffer.setLength(0);
            stringBuffer.append("Comparing certificate against Root CA certificate:\n");
            stringBuffer.append(certificate2.toString());
            Trace.securityPrintln(stringBuffer.toString(), 2);
            try {
                certificate.verify(certificate2.getPublicKey());
                Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.verify.ok"), 2);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.verify.fail"), 2);
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("rootcertstore.cert.iterator"), 2);
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._cacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._cacerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }

    static {
        _filename = UserProfile.getRootCertificateFile();
    }
}

