/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom;

import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.w3c.dom.DOMException;
import sun.plugin.dom.exception.InvalidAccessException;
import sun.plugin.dom.exception.InvalidStateException;
import sun.plugin.security.ActivatorSecurityManager;

public class DOMObject {
    private JSObject jsobj;
    static /* synthetic */ Class class$sun$plugin$dom$DOMService;

    public DOMObject(JSObject jSObject) {
        this.jsobj = jSObject;
    }

    public Object call(String string, Object[] objectArray) throws DOMException {
        this.checkThreadAccess();
        try {
            Object[] objectArray2 = null;
            if (objectArray != null) {
                objectArray2 = new Object[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    objectArray2[n] = this.unwrapObject(objectArray[n]);
                    ++n;
                }
            }
            return this.jsobj.call(string, objectArray2);
        }
        catch (JSException jSException) {
            throw new InvalidStateException(jSException.toString());
        }
    }

    public Object getMember(String string) throws DOMException {
        this.checkThreadAccess();
        try {
            Object object = this.jsobj.getMember(string);
            return this.wrapObject(object);
        }
        catch (JSException jSException) {
            throw new InvalidStateException(jSException.toString());
        }
    }

    public void setMember(String string, Object object) throws DOMException {
        this.checkThreadAccess();
        object = this.unwrapObject(object);
        try {
            this.jsobj.setMember(string, object);
        }
        catch (JSException jSException) {
            throw new InvalidStateException(jSException.toString());
        }
    }

    public void removeMember(String string) throws DOMException {
        this.checkThreadAccess();
        try {
            this.jsobj.removeMember(string);
        }
        catch (JSException jSException) {
            throw new InvalidStateException(jSException.toString());
        }
    }

    public Object getSlot(int n) throws DOMException {
        this.checkThreadAccess();
        try {
            Object object = this.jsobj.getSlot(n);
            return this.wrapObject(object);
        }
        catch (JSException jSException) {
            throw new InvalidStateException(jSException.toString());
        }
    }

    public void setSlot(int n, Object object) throws DOMException {
        this.checkThreadAccess();
        object = this.unwrapObject(object);
        try {
            this.jsobj.setSlot(n, object);
        }
        catch (JSException jSException) {
            throw new InvalidStateException(jSException.toString());
        }
    }

    private void checkThreadAccess() throws InvalidAccessException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager instanceof ActivatorSecurityManager) {
            ActivatorSecurityManager activatorSecurityManager = (ActivatorSecurityManager)((Object)securityManager);
            Class[] classArray = activatorSecurityManager.getExecutionStackContext();
            int n = 0;
            while (n < classArray.length) {
                Class clazz;
                if ((class$sun$plugin$dom$DOMService == null ? DOMObject.class$("sun.plugin.dom.DOMService") : class$sun$plugin$dom$DOMService).isAssignableFrom(clazz = classArray[n])) {
                    return;
                }
                ++n;
            }
        }
        throw new InvalidAccessException("Invalid access to DOM object from non-dispatch thread.");
    }

    private Object wrapObject(Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof JSObject) {
            return new DOMObject((JSObject)object);
        }
        return object;
    }

    private Object unwrapObject(Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof DOMObject) {
            DOMObject dOMObject = (DOMObject)object;
            return dOMObject.getJSObject();
        }
        return object;
    }

    private Object getJSObject() {
        return this.jsobj;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

