/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.ietf.jgss.MessageProp;

public class TokenTracker {
    static final int MAX_INTERVALS = 5;
    private int initNumber;
    private int windowStart;
    private int expectedNumber;
    private int windowStartIndex = 0;
    private LinkedList list = new LinkedList();

    public TokenTracker(int n2) {
        this.initNumber = n2;
        this.windowStart = n2;
        this.expectedNumber = n2;
        Entry entry = new Entry(n2 - 1);
        this.list.add(entry);
    }

    private int getIntervalIndex(int n2) {
        Entry entry = null;
        int n3 = this.list.size() - 1;
        while (n3 >= 0) {
            entry = (Entry)this.list.get(n3);
            if (entry.compareTo(n2) <= 0) break;
            --n3;
        }
        return n3;
    }

    public final synchronized void getProps(int n2, MessageProp messageProp) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = this.getIntervalIndex(n2);
        Entry entry = null;
        if (n3 != -1) {
            entry = (Entry)this.list.get(n3);
        }
        if (n2 == this.expectedNumber) {
            ++this.expectedNumber;
        } else if (entry != null && entry.contains(n2)) {
            bl5 = true;
        } else if (this.expectedNumber >= this.initNumber) {
            if (n2 > this.expectedNumber) {
                bl2 = true;
            } else if (n2 >= this.windowStart) {
                bl4 = true;
            } else if (n2 >= this.initNumber) {
                bl3 = true;
            } else {
                bl2 = true;
            }
        } else if (n2 > this.expectedNumber) {
            if (n2 < this.initNumber) {
                bl2 = true;
            } else if (this.windowStart >= this.initNumber) {
                if (n2 >= this.windowStart) {
                    bl4 = true;
                } else {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
        } else if (this.windowStart > this.expectedNumber) {
            bl4 = true;
        } else if (n2 < this.windowStart) {
            bl3 = true;
        } else {
            bl4 = true;
        }
        if (!bl5 && !bl3) {
            this.add(n2, n3);
        }
        if (bl2) {
            this.expectedNumber = n2 + 1;
        }
        messageProp.setSupplementaryStates(bl5, bl3, bl4, bl2, 0, null);
    }

    private void add(int n2, int n3) {
        Entry entry;
        int n4;
        Entry entry2 = null;
        Entry entry3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n3 != -1 && n2 == (entry2 = (Entry)this.list.get(n3)).getEnd() + 1) {
            entry2.setEnd(n2);
            bl2 = true;
        }
        if ((n4 = n3 + 1) < this.list.size() && n2 == (entry3 = (Entry)this.list.get(n4)).getStart() - 1) {
            if (!bl2) {
                entry3.setStart(n2);
            } else {
                entry3.setStart(entry2.getStart());
                this.list.remove(n3);
                if (this.windowStartIndex > n3) {
                    --this.windowStartIndex;
                }
            }
            bl3 = true;
        }
        if (bl3 || bl2) {
            return;
        }
        if (this.list.size() < 5) {
            entry = new Entry(n2);
            if (n3 < this.windowStartIndex) {
                ++this.windowStartIndex;
            }
        } else {
            int n5 = this.windowStartIndex;
            if (this.windowStartIndex == this.list.size() - 1) {
                this.windowStartIndex = 0;
            }
            entry = (Entry)this.list.remove(n5);
            this.windowStart = ((Entry)this.list.get(this.windowStartIndex)).getStart();
            entry.setStart(n2);
            entry.setEnd(n2);
            if (n3 >= n5) {
                --n3;
            } else if (n5 != this.windowStartIndex) {
                if (n3 == -1) {
                    this.windowStart = n2;
                }
            } else {
                ++this.windowStartIndex;
            }
        }
        this.list.add(n3 + 1, entry);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TokenTracker: ");
        stringBuffer.append(" initNumber=").append(this.initNumber);
        stringBuffer.append(" windowStart=").append(this.windowStart);
        stringBuffer.append(" expectedNumber=").append(this.expectedNumber);
        stringBuffer.append(" windowStartIndex=").append(this.windowStartIndex);
        stringBuffer.append("\n\tIntervals are: {");
        int n2 = 0;
        while (n2 < this.list.size()) {
            if (n2 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.list.get(n2).toString());
            ++n2;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Enter expected starting sequence number: ");
        int n2 = Integer.parseInt(bufferedReader.readLine());
        MessageProp messageProp = new MessageProp(0, true);
        TokenTracker tokenTracker = new TokenTracker(n2);
        System.out.println("Now enter actual received sequence numbers and watch the list and the MessageProp:");
        while (true) {
            n2 = Integer.parseInt(bufferedReader.readLine());
            try {
                tokenTracker.getProps(n2, messageProp);
            }
            catch (Exception exception) {
                System.out.println(exception);
                System.out.println(tokenTracker);
                throw exception;
            }
            System.out.println(messageProp);
            System.out.println(tokenTracker);
            System.out.println("");
        }
    }

    class Entry {
        private int start;
        private int end;

        Entry(int n2) {
            this.start = n2;
            this.end = n2;
        }

        final int compareTo(int n2) {
            if (this.start > n2) {
                return 1;
            }
            if (this.end < n2) {
                return -1;
            }
            return 0;
        }

        final boolean contains(int n2) {
            return n2 >= this.start && n2 <= this.end;
        }

        final void append(int n2) {
            if (n2 == this.end + 1) {
                this.end = n2;
            }
        }

        final void setInterval(int n2, int n3) {
            this.start = n2;
            this.end = n3;
        }

        final void setEnd(int n2) {
            this.end = n2;
        }

        final void setStart(int n2) {
            this.start = n2;
        }

        final int getStart() {
            return this.start;
        }

        final int getEnd() {
            return this.end;
        }

        public String toString() {
            return "[" + this.start + ", " + this.end + "]";
        }
    }
}

