/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketAdaptor;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class SocketChannelImpl
extends SocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private final int fdVal;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_CONNECTED = 2;
    private volatile int state = -1;
    private volatile SocketAddress localAddress = null;
    private volatile SocketAddress remoteAddress = null;
    private volatile boolean isInputOpen = true;
    private volatile boolean isOutputOpen = true;
    private volatile boolean readyToConnect = false;
    private boolean isKilled = false;
    private volatile SocketOpts.IP.TCP options = null;
    private Socket socket = null;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$SocketChannelImpl;

    SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 2;
        this.remoteAddress = inetSocketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket socket() {
        Object object = this.readLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = SocketAdaptor.create(this);
            }
            Socket socket = this.socket;
            return socket;
        }
    }

    private boolean ensureReadOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        return this.isInputOpen;
    }

    private void ensureWriteOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.isOutputOpen) {
            throw new ClosedChannelException();
        }
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            boolean bl2;
            int n2;
            if (!this.ensureReadOpen()) {
                return -1;
            }
            int n3 = 0;
            try {
                this.begin();
                n2 = n3 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.readLock);
                Object var7_6 = null;
                bl2 = n3 > 0;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.end(n3 > 0);
                if (n3 > 0) throw throwable;
                if (this.isInputOpen) throw throwable;
                throw new AsynchronousCloseException();
            }
            this.end(bl2);
            if (n3 > 0) return n2;
            if (this.isInputOpen) return n2;
            throw new AsynchronousCloseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int read0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            boolean bl2;
            int n2;
            if (!this.ensureReadOpen()) {
                return -1;
            }
            int n3 = 0;
            try {
                this.begin();
                n2 = n3 = IOUtil.read(this.fd, byteBufferArray, nd);
                Object var7_6 = null;
                bl2 = n3 > 0;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.end(n3 > 0);
                if (n3 > 0) throw throwable;
                if (this.isInputOpen) throw throwable;
                throw new AsynchronousCloseException();
            }
            this.end(bl2);
            if (n3 > 0) return n2;
            if (this.isInputOpen) return n2;
            throw new AsynchronousCloseException();
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.read0(Util.subsequence(byteBufferArray, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            boolean bl2;
            int n2;
            this.ensureWriteOpen();
            int n3 = 0;
            try {
                this.begin();
                n2 = n3 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.writeLock);
                Object var6_5 = null;
                bl2 = n3 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n3 > 0);
                if (n3 <= 0 && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            this.end(bl2);
            if (n3 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            boolean bl2;
            int n2;
            this.ensureWriteOpen();
            int n3 = 0;
            try {
                this.begin();
                n2 = n3 = IOUtil.write(this.fd, byteBufferArray, nd);
                Object var6_5 = null;
                bl2 = n3 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n3 > 0);
                if (n3 <= 0 && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            this.end(bl2);
            if (n3 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            return n2;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.write0(Util.subsequence(byteBufferArray, n2, n3));
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        IOUtil.configureBlocking(this.fd, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        if (this.options != null) {
            return this.options;
        }
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3;
                if (this.options == null) {
                    object3 = new SocketOptsImpl.Dispatcher(){

                        int getInt(int n2) throws IOException {
                            return Net.getIntOption(SocketChannelImpl.this.fd, n2);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        void setInt(int n2, int n3) throws IOException {
                            Object object = SocketChannelImpl.this.readLock;
                            synchronized (object) {
                                Object object2 = SocketChannelImpl.this.writeLock;
                                synchronized (object2) {
                                    Net.setIntOption(SocketChannelImpl.this.fd, n2, n3);
                                }
                            }
                        }
                    };
                    this.options = new SocketOptsImpl.IP.TCP((SocketOptsImpl.Dispatcher)object3);
                }
                object3 = this.options;
                return object3;
            }
        }
    }

    public boolean isBound() {
        return this.localAddress != null;
    }

    public SocketAddress localAddress() {
        if (this.isConnected() && this.localAddress == null) {
            this.localAddress = Net.localAddress(this.fd);
        }
        return this.localAddress;
    }

    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                this.ensureOpenAndUnconnected();
                if (this.localAddress != null) {
                    throw new AlreadyBoundException();
                }
                InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                this.localAddress = Net.localAddress(this.fd);
            }
        }
    }

    public boolean isConnected() {
        return this.state == 2;
    }

    public boolean isConnectionPending() {
        return this.state == 1;
    }

    void ensureOpenAndUnconnected() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.state == 2) {
            throw new AlreadyConnectedException();
        }
        if (this.state == 1) {
            throw new ConnectionPendingException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect(SocketAddress socketAddress) throws IOException {
        int n2 = 0;
        boolean bl2 = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                this.ensureOpenAndUnconnected();
                InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
                Object object3 = this.blockingLock();
                synchronized (object3) {
                    boolean bl3 = false;
                    try {
                        bl3 = Net.connect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), n2);
                    }
                    catch (IOException iOException) {
                        this.close();
                        throw iOException;
                    }
                    this.remoteAddress = inetSocketAddress;
                    if (bl3) {
                        this.state = 2;
                        return true;
                    }
                    if (this.isBlocking()) throw new InternalError();
                    this.state = 1;
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean finishConnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (this.isConnected()) {
                    return true;
                }
                if (this.state != 1) {
                    throw new NoConnectionPendingException();
                }
                boolean bl2 = false;
                try {
                    if (!this.isBlocking()) {
                        bl2 = SocketChannelImpl.checkConnect(this.fd, false, this.readyToConnect);
                    } else {
                        while (!SocketChannelImpl.checkConnect(this.fd, true, this.readyToConnect)) {
                        }
                        bl2 = true;
                    }
                }
                catch (IOException iOException) {
                    this.close();
                    throw iOException;
                }
                if (!bl2) return false;
                this.state = 2;
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownInput() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            SocketChannelImpl.shutdown(this.fd, 0);
            this.isInputOpen = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownOutput() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            SocketChannelImpl.shutdown(this.fd, 1);
            this.isOutputOpen = false;
        }
    }

    public boolean isInputOpen() {
        return this.isInputOpen;
    }

    public boolean isOutputOpen() {
        return this.isOutputOpen;
    }

    protected void implCloseSelectableChannel() throws IOException {
        if (!this.isRegistered()) {
            this.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.isKilled) {
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.isKilled = true;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public void translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 0x20) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if (((n2 & 1) != 0 || (n2 & 8) != 0) && (selectionKeyImpl.interestOps() & 1) != 0 && this.state == 2) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0 || (n2 & 8) != 0) {
            if ((selectionKeyImpl.interestOps() & 4) != 0 && this.state == 2) {
                n3 |= 4;
            }
            if ((selectionKeyImpl.interestOps() & 8) != 0 && this.state != 2) {
                n3 |= 8;
                this.readyToConnect = true;
            }
        }
        selectionKeyImpl.readyOps(n3);
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 8) != 0) {
            n3 |= 4;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n3);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSuperclass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            if (!this.isConnected()) {
                stringBuffer.append("unconnected");
            } else if (this.isConnectionPending()) {
                stringBuffer.append("connection-pending");
            } else {
                stringBuffer.append("connected");
                if (!this.isInputOpen) {
                    stringBuffer.append(" ishut");
                }
                if (!this.isOutputOpen) {
                    stringBuffer.append(" oshut");
                }
            }
            if (this.localAddress() != null) {
                stringBuffer.append(" local=");
                stringBuffer.append(this.localAddress().toString());
            }
            if (this.remoteAddress() != null) {
                stringBuffer.append(" remote=");
                stringBuffer.append(this.remoteAddress().toString());
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static native void initIDs();

    private static native boolean checkConnect(FileDescriptor var0, boolean var1, boolean var2) throws IOException;

    private static native void shutdown(FileDescriptor var0, int var1) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$SocketChannelImpl == null ? (class$sun$nio$ch$SocketChannelImpl = SocketChannelImpl.class$("sun.nio.ch.SocketChannelImpl")) : class$sun$nio$ch$SocketChannelImpl).desiredAssertionStatus();
        Util.load();
        SocketChannelImpl.initIDs();
        nd = new SocketDispatcher();
    }
}

