/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.ServerSocketAdaptor;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class ServerSocketChannelImpl
extends ServerSocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private int fdVal;
    private volatile SocketAddress localAddress = null;
    private volatile SocketOpts.IP.TCP options = null;
    private final Object lock = new Object();
    private boolean isKilled = false;
    ServerSocket socket;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$ServerSocketChannelImpl;

    public ServerSocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocket socket() {
        Object object = this.lock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = ServerSocketAdaptor.create(this);
            }
            ServerSocket serverSocket = this.socket;
            return serverSocket;
        }
    }

    public boolean isBound() {
        return this.localAddress != null;
    }

    public SocketAddress localAddress() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isBound()) {
                throw new AlreadyBoundException();
            }
            InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(inetSocketAddress.getPort());
            }
            Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            ServerSocketChannelImpl.listen(this.fd, n2 < 1 ? 50 : n2);
            this.localAddress = Net.localAddress(this.fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SocketChannel accept() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            SocketChannelImpl socketChannelImpl2;
            SocketChannelImpl socketChannelImpl;
            block12: {
                boolean bl2;
                SocketChannel socketChannel;
                block11: {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (!this.isBound()) {
                        throw new NotYetBoundException();
                    }
                    socketChannelImpl = null;
                    try {
                        this.begin();
                        FileDescriptor fileDescriptor = new FileDescriptor();
                        InetSocketAddress inetSocketAddress = this.accept0(this.fd, fileDescriptor);
                        if (inetSocketAddress == null) {
                            socketChannel = null;
                            Object var9_6 = null;
                            bl2 = socketChannelImpl != null;
                            break block11;
                        }
                        IOUtil.configureBlocking(fileDescriptor, true);
                        socketChannelImpl = new SocketChannelImpl(this.provider(), fileDescriptor, inetSocketAddress);
                        SecurityManager securityManager = System.getSecurityManager();
                        if (securityManager != null) {
                            try {
                                securityManager.checkAccept(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                            }
                            catch (SecurityException securityException) {
                                socketChannelImpl.close();
                                throw securityException;
                            }
                        }
                        socketChannelImpl2 = socketChannelImpl;
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        this.end(socketChannelImpl != null);
                        throw throwable;
                    }
                }
                this.end(bl2);
                return socketChannel;
            }
            Object var9_7 = null;
            this.end(socketChannelImpl != null);
            return socketChannelImpl2;
        }
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        IOUtil.configureBlocking(this.fd, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        if (this.options != null) {
            return this.options;
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            if (this.options == null) {
                object2 = new SocketOptsImpl.Dispatcher(){

                    int getInt(int n2) throws IOException {
                        return Net.getIntOption(ServerSocketChannelImpl.this.fd, n2);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    void setInt(int n2, int n3) throws IOException {
                        Object object = ServerSocketChannelImpl.this.lock;
                        synchronized (object) {
                            Net.setIntOption(ServerSocketChannelImpl.this.fd, n2, n3);
                        }
                    }
                };
                this.options = new SocketOptsImpl.IP.TCP((SocketOptsImpl.Dispatcher)object2);
            }
            object2 = this.options;
            return object2;
        }
    }

    protected void implCloseSelectableChannel() throws IOException {
        if (!this.isRegistered()) {
            this.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isKilled) {
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.isKilled = true;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public void translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        if ((n2 & 1) != 0 || (n2 & 8) != 0) {
            selectionKeyImpl.readyOps(16);
        }
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 0x10) != 0) {
            n3 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n3);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else if (this.localAddress() == null) {
            stringBuffer.append("unbound");
        } else {
            stringBuffer.append(this.localAddress().toString());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static native void listen(FileDescriptor var0, int var1) throws IOException;

    private native InetSocketAddress accept0(FileDescriptor var1, FileDescriptor var2) throws IOException;

    private static native void initIDs();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$ServerSocketChannelImpl == null ? (class$sun$nio$ch$ServerSocketChannelImpl = ServerSocketChannelImpl.class$("sun.nio.ch.ServerSocketChannelImpl")) : class$sun$nio$ch$ServerSocketChannelImpl).desiredAssertionStatus();
        Util.load();
        ServerSocketChannelImpl.initIDs();
        nd = new SocketDispatcher();
    }
}

